/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base;

import io.deephaven.datastructures.util.CollectionUtil;
import io.deephaven.util.codec.ObjectCodec;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BigIntegerParquetBytesCodec
implements ObjectCodec<BigInteger> {
    private final int encodedSizeInBytes;
    private final byte[] nullBytes;

    public BigIntegerParquetBytesCodec(int encodedSizeInBytes) {
        this.encodedSizeInBytes = encodedSizeInBytes;
        if (encodedSizeInBytes > 0) {
            this.nullBytes = new byte[encodedSizeInBytes];
            for (int i = 0; i < encodedSizeInBytes; ++i) {
                this.nullBytes[i] = -1;
            }
        } else {
            this.nullBytes = CollectionUtil.ZERO_LENGTH_BYTE_ARRAY;
        }
    }

    public BigIntegerParquetBytesCodec() {
        this(-1);
    }

    public boolean isNullable() {
        return true;
    }

    public int getPrecision() {
        return 0;
    }

    public int getScale() {
        return 1;
    }

    public int expectedObjectWidth() {
        return this.encodedSizeInBytes <= 0 ? Integer.MIN_VALUE : this.encodedSizeInBytes;
    }

    @NotNull
    public byte[] encode(@Nullable BigInteger input) {
        if (input == null) {
            return this.nullBytes;
        }
        return input.toByteArray();
    }

    @Nullable
    public BigInteger decode(@NotNull byte[] input, int offset, int length) {
        if (length <= 0) {
            return null;
        }
        if (length == this.encodedSizeInBytes) {
            boolean allPreviousBitsSet = true;
            for (int i = 0; i < this.encodedSizeInBytes; ++i) {
                if (input[offset + i] == -1) continue;
                allPreviousBitsSet = false;
                break;
            }
            if (allPreviousBitsSet) {
                return null;
            }
        }
        ByteBuffer buffer = ByteBuffer.wrap(input, offset, length);
        byte[] unscaledValueBytes = new byte[length];
        buffer.get(unscaledValueBytes);
        return new BigInteger(unscaledValueBytes);
    }
}

