/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base;

import io.deephaven.parquet.base.ColumnPageReader;
import io.deephaven.parquet.base.PageMaterializerFactory;
import io.deephaven.util.channel.SeekableChannelContext;
import io.deephaven.util.channel.SeekableChannelsProvider;
import java.io.IOException;
import java.net.URI;
import java.util.function.Function;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.schema.PrimitiveType;
import org.jetbrains.annotations.Nullable;

public interface ColumnChunkReader {
    public static final Dictionary NULL_DICTIONARY = new NullDictionary();

    public String columnName();

    public URI getURI();

    public long numRows();

    public long numValues();

    public int getMaxRl();

    public boolean hasOffsetIndex();

    public OffsetIndex getOffsetIndex(SeekableChannelContext var1);

    public ColumnPageReaderIterator getPageIterator(PageMaterializerFactory var1) throws IOException;

    public ColumnPageDirectAccessor getPageAccessor(OffsetIndex var1, PageMaterializerFactory var2);

    public boolean usesDictionaryOnEveryPage();

    public Function<SeekableChannelContext, Dictionary> getDictionarySupplier();

    public PrimitiveType getType();

    @Nullable
    public String getVersion();

    public SeekableChannelsProvider getChannelsProvider();

    public static final class NullDictionary
    extends Dictionary {
        private NullDictionary() {
            super(null);
        }

        public int getMaxId() {
            return -1;
        }
    }

    public static interface ColumnPageDirectAccessor {
        public ColumnPageReader getPageReader(int var1, SeekableChannelContext var2);
    }

    public static interface ColumnPageReaderIterator {
        public boolean hasNext();

        public ColumnPageReader next(SeekableChannelContext var1);
    }
}

