/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base;

import io.deephaven.UncheckedDeephavenException;
import io.deephaven.base.FileUtils;
import io.deephaven.parquet.base.ColumnChunkReader;
import io.deephaven.parquet.base.ColumnPageReader;
import io.deephaven.parquet.base.ColumnPageReaderImpl;
import io.deephaven.parquet.base.OffsetIndexReader;
import io.deephaven.parquet.base.OffsetIndexReaderImpl;
import io.deephaven.parquet.base.PageMaterializerFactory;
import io.deephaven.parquet.compress.CompressorAdapter;
import io.deephaven.parquet.compress.DeephavenCompressorAdapterFactory;
import io.deephaven.util.channel.SeekableChannelContext;
import io.deephaven.util.channel.SeekableChannelsProvider;
import io.deephaven.util.datastructures.SoftCachingFunction;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.apache.commons.io.FilenameUtils;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.format.ColumnChunk;
import org.apache.parquet.format.ColumnMetaData;
import org.apache.parquet.format.Encoding;
import org.apache.parquet.format.PageEncodingStats;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.PageType;
import org.apache.parquet.format.Util;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.jetbrains.annotations.NotNull;

final class ColumnChunkReaderImpl
implements ColumnChunkReader {
    private final String columnName;
    private final ColumnChunk columnChunk;
    private final SeekableChannelsProvider channelsProvider;
    private final CompressorAdapter decompressor;
    private final ColumnDescriptor path;
    private final OffsetIndexReader offsetIndexReader;
    private final List<Type> fieldTypes;
    private final Function<SeekableChannelContext, Dictionary> dictionarySupplier;
    private final URI columnChunkURI;
    private final long numRows;
    private final String version;

    ColumnChunkReaderImpl(String columnName, ColumnChunk columnChunk, SeekableChannelsProvider channelsProvider, URI rootURI, MessageType type, List<Type> fieldTypes, long numRows, String version) {
        this.columnName = columnName;
        this.channelsProvider = channelsProvider;
        this.columnChunk = columnChunk;
        this.path = type.getColumnDescription(columnChunk.meta_data.getPath_in_schema().toArray(new String[0]));
        this.decompressor = columnChunk.getMeta_data().isSetCodec() ? DeephavenCompressorAdapterFactory.getInstance().getByName(columnChunk.getMeta_data().getCodec().name()) : CompressorAdapter.PASSTHRU;
        this.fieldTypes = fieldTypes;
        this.dictionarySupplier = new SoftCachingFunction(this::getDictionary);
        this.numRows = numRows;
        this.version = version;
        if (columnChunk.isSetFile_path() && "file".equals(rootURI.getScheme())) {
            String relativePath = FilenameUtils.separatorsToSystem((String)columnChunk.getFile_path());
            this.columnChunkURI = FileUtils.convertToURI((Path)Path.of(rootURI).resolve(relativePath), (boolean)false);
        } else {
            this.columnChunkURI = rootURI;
        }
        this.offsetIndexReader = columnChunk.isSetOffset_index_offset() ? new OffsetIndexReaderImpl(channelsProvider, columnChunk, this.columnChunkURI) : OffsetIndexReader.NULL;
    }

    @Override
    public String columnName() {
        return this.columnName;
    }

    @Override
    public long numRows() {
        return this.numRows;
    }

    @Override
    public long numValues() {
        return this.columnChunk.getMeta_data().num_values;
    }

    @Override
    public int getMaxRl() {
        return this.path.getMaxRepetitionLevel();
    }

    @Override
    public boolean hasOffsetIndex() {
        return this.columnChunk.isSetOffset_index_offset();
    }

    @Override
    public OffsetIndex getOffsetIndex(SeekableChannelContext context) {
        return this.offsetIndexReader.getOffsetIndex(context);
    }

    @Override
    public ColumnChunkReader.ColumnPageReaderIterator getPageIterator(PageMaterializerFactory pageMaterializerFactory) {
        return new ColumnPageReaderIteratorImpl(pageMaterializerFactory);
    }

    @Override
    public ColumnChunkReader.ColumnPageDirectAccessor getPageAccessor(OffsetIndex offsetIndex, PageMaterializerFactory pageMaterializerFactory) {
        if (offsetIndex == null) {
            throw new UnsupportedOperationException("Cannot use direct accessor without offset index");
        }
        return new ColumnPageDirectAccessorImpl(offsetIndex, pageMaterializerFactory);
    }

    @Override
    public URI getURI() {
        return this.columnChunkURI;
    }

    @Override
    public boolean usesDictionaryOnEveryPage() {
        ColumnMetaData columnMeta = this.columnChunk.getMeta_data();
        if (columnMeta.encoding_stats == null) {
            return false;
        }
        for (PageEncodingStats encodingStat : columnMeta.encoding_stats) {
            if (encodingStat.page_type != PageType.DATA_PAGE && encodingStat.page_type != PageType.DATA_PAGE_V2 || encodingStat.encoding == Encoding.PLAIN_DICTIONARY || encodingStat.encoding == Encoding.RLE_DICTIONARY) continue;
            return false;
        }
        return true;
    }

    @Override
    public Function<SeekableChannelContext, Dictionary> getDictionarySupplier() {
        return this.dictionarySupplier;
    }

    @NotNull
    private Dictionary getDictionary(SeekableChannelContext channelContext) {
        ColumnMetaData chunkMeta = this.columnChunk.getMeta_data();
        long dictionaryPageOffset = chunkMeta.isSetDictionary_page_offset() ? chunkMeta.getDictionary_page_offset() : chunkMeta.getData_page_offset();
        return this.readDictionary(dictionaryPageOffset, channelContext);
    }

    @Override
    public PrimitiveType getType() {
        return this.path.getPrimitiveType();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public SeekableChannelsProvider getChannelsProvider() {
        return this.channelsProvider;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private Dictionary readDictionary(long dictionaryPageOffset, SeekableChannelContext channelContext) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Function<SeekableChannelContext, Dictionary> getPageDictionarySupplier(PageHeader pageHeader) {
        Encoding encoding = this.getEncoding(pageHeader);
        return encoding == Encoding.PLAIN_DICTIONARY || encoding == Encoding.RLE_DICTIONARY ? this.dictionarySupplier : context -> NULL_DICTIONARY;
    }

    private Encoding getEncoding(PageHeader pageHeader) {
        switch (pageHeader.type) {
            case DATA_PAGE: {
                return pageHeader.getData_page_header().getEncoding();
            }
            case DATA_PAGE_V2: {
                return pageHeader.getData_page_header_v2().getEncoding();
            }
        }
        throw new UncheckedDeephavenException("Unknown parquet data page header type " + pageHeader.type + " for column: " + this.columnName + ", uri: " + this.getURI());
    }

    private PageHeader readPageHeader(SeekableByteChannel ch) throws IOException {
        try (InputStream in = SeekableChannelsProvider.channelPositionInputStream((SeekableChannelsProvider)this.channelsProvider, (SeekableByteChannel)ch, (int)128);){
            PageHeader pageHeader = Util.readPageHeader((InputStream)in);
            return pageHeader;
        }
    }

    private static int getNumValues(PageHeader pageHeader) {
        return pageHeader.isSetData_page_header() ? pageHeader.getData_page_header().getNum_values() : pageHeader.getData_page_header_v2().getNum_values();
    }

    private final class ColumnPageDirectAccessorImpl
    implements ColumnChunkReader.ColumnPageDirectAccessor {
        private final OffsetIndex offsetIndex;
        private final PageMaterializerFactory pageMaterializerFactory;

        ColumnPageDirectAccessorImpl(@NotNull OffsetIndex offsetIndex, PageMaterializerFactory pageMaterializerFactory) {
            this.offsetIndex = offsetIndex;
            this.pageMaterializerFactory = pageMaterializerFactory;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        public ColumnPageReader getPageReader(int pageNum, SeekableChannelContext channelContext) {
            if (pageNum < 0 || pageNum >= this.offsetIndex.getPageCount()) {
                throw new IndexOutOfBoundsException("pageNum=" + pageNum + ", offsetIndex.getPageCount()=" + this.offsetIndex.getPageCount() + " for column: " + ColumnChunkReaderImpl.this.columnName + ", uri: " + ColumnChunkReaderImpl.this.getURI());
            }
            long headerOffset = this.offsetIndex.getOffset(pageNum);
            try (SeekableChannelContext.ContextHolder holder = SeekableChannelContext.ensureContext((SeekableChannelsProvider)ColumnChunkReaderImpl.this.channelsProvider, (SeekableChannelContext)channelContext);){
                ColumnPageReaderImpl columnPageReaderImpl;
                block16: {
                    SeekableByteChannel ch = ColumnChunkReaderImpl.this.channelsProvider.getReadChannel(holder.get(), ColumnChunkReaderImpl.this.getURI());
                    try {
                        ch.position(headerOffset);
                        PageHeader pageHeader = ColumnChunkReaderImpl.this.readPageHeader(ch);
                        long dataOffset = ch.position();
                        PageType pageType = pageHeader.type;
                        if (pageType != PageType.DATA_PAGE && pageType != PageType.DATA_PAGE_V2) {
                            throw new IllegalStateException("Expected data page, but got " + pageType + " for page number " + pageNum + " at offset " + headerOffset + " for file " + ColumnChunkReaderImpl.this.getURI());
                        }
                        Function<SeekableChannelContext, Dictionary> pageDictionarySupplier = ColumnChunkReaderImpl.this.getPageDictionarySupplier(pageHeader);
                        columnPageReaderImpl = new ColumnPageReaderImpl(ColumnChunkReaderImpl.this.columnName, ColumnChunkReaderImpl.this.channelsProvider, ColumnChunkReaderImpl.this.decompressor, pageDictionarySupplier, this.pageMaterializerFactory, ColumnChunkReaderImpl.this.path, ColumnChunkReaderImpl.this.getURI(), ColumnChunkReaderImpl.this.fieldTypes, dataOffset, pageHeader, ColumnChunkReaderImpl.getNumValues(pageHeader));
                        if (ch == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (ch != null) {
                            try {
                                ch.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    ch.close();
                }
                return columnPageReaderImpl;
            }
            catch (IOException e) {
                throw new UncheckedDeephavenException("Error reading page header for page number " + pageNum + " at offset " + headerOffset + " for column: " + ColumnChunkReaderImpl.this.columnName + ", uri: " + ColumnChunkReaderImpl.this.getURI(), (Throwable)e);
            }
        }
    }

    private final class ColumnPageReaderIteratorImpl
    implements ColumnChunkReader.ColumnPageReaderIterator {
        private long nextHeaderOffset;
        private long remainingValues;
        PageMaterializerFactory pageMaterializerFactory;

        ColumnPageReaderIteratorImpl(PageMaterializerFactory pageMaterializerFactory) {
            this.remainingValues = ColumnChunkReaderImpl.this.columnChunk.meta_data.getNum_values();
            this.nextHeaderOffset = ColumnChunkReaderImpl.this.columnChunk.meta_data.getData_page_offset();
            this.pageMaterializerFactory = pageMaterializerFactory;
        }

        @Override
        public boolean hasNext() {
            return this.remainingValues > 0L;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        public ColumnPageReader next(@NotNull SeekableChannelContext channelContext) {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No next element in column: " + ColumnChunkReaderImpl.this.columnName + ", uri:  " + ColumnChunkReaderImpl.this.getURI());
            }
            long headerOffset = this.nextHeaderOffset;
            try (SeekableChannelContext.ContextHolder holder = SeekableChannelContext.ensureContext((SeekableChannelsProvider)ColumnChunkReaderImpl.this.channelsProvider, (SeekableChannelContext)channelContext);){
                ColumnPageReaderImpl columnPageReaderImpl;
                block20: {
                    PageType pageType;
                    long dataOffset;
                    PageHeader pageHeader;
                    SeekableByteChannel ch;
                    block18: {
                        ColumnPageReader columnPageReader;
                        block19: {
                            ch = ColumnChunkReaderImpl.this.channelsProvider.getReadChannel(holder.get(), ColumnChunkReaderImpl.this.getURI());
                            try {
                                ch.position(headerOffset);
                                pageHeader = ColumnChunkReaderImpl.this.readPageHeader(ch);
                                dataOffset = ch.position();
                                this.nextHeaderOffset = dataOffset + (long)pageHeader.getCompressed_page_size();
                                pageType = pageHeader.type;
                                if (pageType != PageType.DICTIONARY_PAGE || headerOffset != ColumnChunkReaderImpl.this.columnChunk.meta_data.getData_page_offset() || ColumnChunkReaderImpl.this.columnChunk.meta_data.getDictionary_page_offset() != 0L) break block18;
                                columnPageReader = this.next(holder.get());
                                if (ch == null) break block19;
                            }
                            catch (Throwable throwable) {
                                if (ch != null) {
                                    try {
                                        ch.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            ch.close();
                        }
                        return columnPageReader;
                    }
                    if (pageType != PageType.DATA_PAGE && pageType != PageType.DATA_PAGE_V2) {
                        throw new IllegalStateException("Expected data page, but got " + pageType + " at offset " + headerOffset + " for file " + ColumnChunkReaderImpl.this.getURI());
                    }
                    int numValuesInPage = ColumnChunkReaderImpl.getNumValues(pageHeader);
                    this.remainingValues -= (long)numValuesInPage;
                    Function<SeekableChannelContext, Dictionary> pageDictionarySupplier = ColumnChunkReaderImpl.this.getPageDictionarySupplier(pageHeader);
                    columnPageReaderImpl = new ColumnPageReaderImpl(ColumnChunkReaderImpl.this.columnName, ColumnChunkReaderImpl.this.channelsProvider, ColumnChunkReaderImpl.this.decompressor, pageDictionarySupplier, this.pageMaterializerFactory, ColumnChunkReaderImpl.this.path, ColumnChunkReaderImpl.this.getURI(), ColumnChunkReaderImpl.this.fieldTypes, dataOffset, pageHeader, numValuesInPage);
                    if (ch == null) break block20;
                    ch.close();
                }
                return columnPageReaderImpl;
            }
            catch (IOException e) {
                throw new UncheckedDeephavenException("Error reading page header at offset " + headerOffset + " for column: " + ColumnChunkReaderImpl.this.columnName + ", uri: " + ColumnChunkReaderImpl.this.getURI(), (Throwable)e);
            }
        }
    }
}

