/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base;

import io.deephaven.UncheckedDeephavenException;
import io.deephaven.base.Pair;
import io.deephaven.base.verify.Require;
import io.deephaven.parquet.base.ColumnChunkReader;
import io.deephaven.parquet.base.ColumnPageReader;
import io.deephaven.parquet.base.DataWithMultiLevelOffsets;
import io.deephaven.parquet.base.DataWithOffsets;
import io.deephaven.parquet.base.KeyIndexReader;
import io.deephaven.parquet.base.LevelsController;
import io.deephaven.parquet.base.PageMaterializer;
import io.deephaven.parquet.base.PageMaterializerFactory;
import io.deephaven.parquet.base.RunLengthBitPackingHybridBufferDecoder;
import io.deephaven.parquet.base.materializers.IntMaterializer;
import io.deephaven.parquet.compress.CompressorAdapter;
import io.deephaven.util.channel.SeekableChannelContext;
import io.deephaven.util.channel.SeekableChannelsProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.column.ValuesType;
import org.apache.parquet.column.page.DataPageV1;
import org.apache.parquet.column.page.DataPageV2;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.dictionary.DictionaryValuesReader;
import org.apache.parquet.format.DataPageHeader;
import org.apache.parquet.format.DataPageHeaderV2;
import org.apache.parquet.format.Encoding;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.PageType;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.schema.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ColumnPageReaderImpl
implements ColumnPageReader {
    private static final int NULL_OFFSET = -1;
    private final String columnName;
    private final SeekableChannelsProvider channelsProvider;
    private final CompressorAdapter compressorAdapter;
    private final Function<SeekableChannelContext, Dictionary> dictionarySupplier;
    private final PageMaterializerFactory pageMaterializerFactory;
    private final ColumnDescriptor path;
    private final URI uri;
    private final List<Type> fieldTypes;
    private final long dataOffset;
    private final PageHeader pageHeader;
    private final int numValues;
    private int rowCount = -1;

    ColumnPageReaderImpl(String columnName, SeekableChannelsProvider channelsProvider, CompressorAdapter compressorAdapter, Function<SeekableChannelContext, Dictionary> dictionarySupplier, PageMaterializerFactory materializerFactory, ColumnDescriptor path, URI uri, List<Type> fieldTypes, long dataOffset, PageHeader pageHeader, int numValues) {
        this.columnName = columnName;
        this.channelsProvider = channelsProvider;
        this.compressorAdapter = compressorAdapter;
        this.dictionarySupplier = dictionarySupplier;
        this.pageMaterializerFactory = materializerFactory;
        this.path = path;
        this.uri = uri;
        this.fieldTypes = fieldTypes;
        this.dataOffset = dataOffset;
        this.pageHeader = (PageHeader)Require.neqNull((Object)pageHeader, (String)"pageHeader");
        this.numValues = Require.geqZero((int)numValues, (String)"numValues");
    }

    @Override
    public Object materialize(@NotNull Object nullValue, @NotNull SeekableChannelContext channelContext) throws IOException {
        try (SeekableChannelContext.ContextHolder holder = SeekableChannelContext.ensureContext((SeekableChannelsProvider)this.channelsProvider, (SeekableChannelContext)channelContext);){
            Object object;
            block12: {
                SeekableByteChannel ch = this.channelsProvider.getReadChannel(holder.get(), this.uri);
                try {
                    ch.position(this.dataOffset);
                    object = this.readDataPage(nullValue, ch, holder.get());
                    if (ch == null) break block12;
                }
                catch (Throwable throwable) {
                    if (ch != null) {
                        try {
                            ch.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ch.close();
            }
            return object;
        }
    }

    private int readRowCount(@NotNull SeekableChannelContext channelContext) throws IOException {
        try (SeekableChannelContext.ContextHolder holder = SeekableChannelContext.ensureContext((SeekableChannelsProvider)this.channelsProvider, (SeekableChannelContext)channelContext);){
            int n;
            block12: {
                SeekableByteChannel ch = this.channelsProvider.getReadChannel(holder.get(), this.uri);
                try {
                    ch.position(this.dataOffset);
                    n = this.readRowCountFromDataPage(ch, holder.get());
                    if (ch == null) break block12;
                }
                catch (Throwable throwable) {
                    if (ch != null) {
                        try {
                            ch.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ch.close();
            }
            return n;
        }
    }

    @Override
    public IntBuffer readKeyValues(IntBuffer keyDest, int nullPlaceholder, @NotNull SeekableChannelContext channelContext) throws IOException {
        try (SeekableChannelContext.ContextHolder holder = SeekableChannelContext.ensureContext((SeekableChannelsProvider)this.channelsProvider, (SeekableChannelContext)channelContext);){
            IntBuffer intBuffer;
            block12: {
                SeekableByteChannel ch = this.channelsProvider.getReadChannel(holder.get(), this.uri);
                try {
                    ch.position(this.dataOffset);
                    intBuffer = this.readKeysFromDataPage(keyDest, nullPlaceholder, ch, holder.get());
                    if (ch == null) break block12;
                }
                catch (Throwable throwable) {
                    if (ch != null) {
                        try {
                            ch.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ch.close();
            }
            return intBuffer;
        }
    }

    private DataPageV1 readV1Unsafe(InputStream in, @NotNull SeekableChannelContext channelContext) throws IOException {
        if (this.pageHeader.type != PageType.DATA_PAGE) {
            throw new IllegalArgumentException("Expected parquet DATA_PAGE V1, found " + this.pageHeader.getType() + " for column: " + this.columnName + ", uri: " + this.uri);
        }
        int uncompressedPageSize = this.pageHeader.getUncompressed_page_size();
        int compressedPageSize = this.pageHeader.getCompressed_page_size();
        BytesInput decompressedInput = this.compressorAdapter.decompress(in, compressedPageSize, uncompressedPageSize, (Function)channelContext);
        DataPageHeader header = this.pageHeader.getData_page_header();
        return new DataPageV1(decompressedInput, header.getNum_values(), uncompressedPageSize, null, ColumnPageReaderImpl.getEncoding(header.getRepetition_level_encoding()), ColumnPageReaderImpl.getEncoding(header.getDefinition_level_encoding()), ColumnPageReaderImpl.getEncoding(header.getEncoding()));
    }

    private DataPageV2 readV2Unsafe(InputStream in, @NotNull SeekableChannelContext channelContext) throws IOException {
        if (this.pageHeader.type != PageType.DATA_PAGE_V2) {
            throw new IllegalArgumentException("Expected parquet DATA_PAGE_V2, found " + this.pageHeader.getType() + " for column: " + this.columnName + ", uri: " + this.uri);
        }
        int uncompressedPageSize = this.pageHeader.getUncompressed_page_size();
        int compressedPageSize = this.pageHeader.getCompressed_page_size();
        DataPageHeaderV2 header = this.pageHeader.getData_page_header_v2();
        int compressedSize = compressedPageSize - header.getRepetition_levels_byte_length() - header.getDefinition_levels_byte_length();
        int uncompressedSize = uncompressedPageSize - header.getRepetition_levels_byte_length() - header.getDefinition_levels_byte_length();
        BytesInput repetitionLevels = BytesInput.copy((BytesInput)BytesInput.from((InputStream)in, (int)header.getRepetition_levels_byte_length()));
        BytesInput definitionLevels = BytesInput.copy((BytesInput)BytesInput.from((InputStream)in, (int)header.getDefinition_levels_byte_length()));
        BytesInput data = this.compressorAdapter.decompress(in, compressedSize, uncompressedSize, (Function)channelContext);
        return new DataPageV2(header.getNum_rows(), header.getNum_nulls(), header.getNum_values(), repetitionLevels, definitionLevels, ColumnPageReaderImpl.getEncoding(header.getEncoding()), data, uncompressedPageSize, null, false);
    }

    private int readRowCountFromDataPage(SeekableByteChannel ch, @NotNull SeekableChannelContext channelContext) throws IOException {
        switch (this.pageHeader.type) {
            case DATA_PAGE: {
                try (InputStream in = this.channelsProvider.getInputStream(ch, this.pageHeader.getCompressed_page_size());){
                    int n = this.readRowCountFromPageV1(this.readV1Unsafe(in, channelContext));
                    return n;
                }
            }
            case DATA_PAGE_V2: {
                DataPageHeaderV2 dataHeaderV2 = this.pageHeader.getData_page_header_v2();
                return dataHeaderV2.getNum_rows();
            }
        }
        throw new UncheckedDeephavenException("Unsupported page type " + this.pageHeader.type + " for column: " + this.columnName + ", uri: " + this.uri);
    }

    private IntBuffer readKeysFromDataPage(IntBuffer keyDest, int nullPlaceholder, SeekableByteChannel ch, @NotNull SeekableChannelContext channelContext) throws IOException {
        switch (this.pageHeader.type) {
            case DATA_PAGE: {
                try (InputStream in = this.channelsProvider.getInputStream(ch, this.pageHeader.getCompressed_page_size());){
                    IntBuffer intBuffer = this.readKeysFromPageV1(this.readV1Unsafe(in, channelContext), keyDest, nullPlaceholder, channelContext);
                    return intBuffer;
                }
            }
            case DATA_PAGE_V2: {
                try (InputStream in = this.channelsProvider.getInputStream(ch, this.pageHeader.getCompressed_page_size());){
                    IntBuffer intBuffer = this.readKeysFromPageV2(this.readV2Unsafe(in, channelContext), keyDest, nullPlaceholder, channelContext);
                    return intBuffer;
                }
            }
        }
        throw new IOException(String.format("Unexpected page of type %s of size %d", this.pageHeader.getType(), this.pageHeader.getCompressed_page_size()) + " for column: " + this.columnName + ", uri: " + this.uri);
    }

    private Object readDataPage(Object nullValue, SeekableByteChannel ch, @NotNull SeekableChannelContext channelContext) throws IOException {
        switch (this.pageHeader.type) {
            case DATA_PAGE: {
                try (InputStream in = this.channelsProvider.getInputStream(ch, this.pageHeader.getCompressed_page_size());){
                    Object object = this.readPageV1(this.readV1Unsafe(in, channelContext), nullValue, channelContext);
                    return object;
                }
            }
            case DATA_PAGE_V2: {
                try (InputStream in = this.channelsProvider.getInputStream(ch, this.pageHeader.getCompressed_page_size());){
                    Object object = this.readPageV2(this.readV2Unsafe(in, channelContext), nullValue, channelContext);
                    return object;
                }
            }
        }
        throw new IOException(String.format("Unexpected page of type %s of size %d", this.pageHeader.getType(), this.pageHeader.getCompressed_page_size()) + " for column: " + this.columnName + ", uri: " + this.uri);
    }

    private static org.apache.parquet.column.Encoding getEncoding(Encoding encoding) {
        return org.apache.parquet.column.Encoding.valueOf((String)encoding.name());
    }

    private int readRowCountFromPageV1(DataPageV1 page) {
        try {
            if (this.path.getMaxRepetitionLevel() != 0) {
                ByteBuffer bytes = page.getBytes().toByteBuffer();
                bytes.order(ByteOrder.LITTLE_ENDIAN);
                int length = bytes.getInt();
                return this.readRepetitionLevels(bytes.slice().limit(length));
            }
            return page.getValueCount();
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Failed to read row count from Parquet V1 page for column: " + this.columnName + ", uri: " + this.uri, (Throwable)e);
        }
    }

    @Nullable
    private RunLengthBitPackingHybridBufferDecoder getRlDecoderPageV1(ByteBuffer pageBytes) {
        if (this.path.getMaxRepetitionLevel() != 0) {
            int length = pageBytes.getInt();
            RunLengthBitPackingHybridBufferDecoder rlDecoder = new RunLengthBitPackingHybridBufferDecoder(this.path.getMaxRepetitionLevel(), pageBytes.slice().limit(length));
            pageBytes.position(pageBytes.position() + length);
            return rlDecoder;
        }
        return null;
    }

    @Nullable
    private RunLengthBitPackingHybridBufferDecoder getDlDecoderPageV1(ByteBuffer pageBytes) {
        if (this.path.getMaxDefinitionLevel() > 0) {
            int length = pageBytes.getInt();
            RunLengthBitPackingHybridBufferDecoder dlDecoder = new RunLengthBitPackingHybridBufferDecoder(this.path.getMaxDefinitionLevel(), pageBytes.slice().limit(length));
            pageBytes.position(pageBytes.position() + length);
            return dlDecoder;
        }
        return null;
    }

    @Nullable
    private IntBuffer readKeysFromPageV1(DataPageV1 page, IntBuffer keyDest, int nullPlaceholder, @NotNull SeekableChannelContext channelContext) {
        try {
            ByteBuffer bytes = page.getBytes().toByteBuffer();
            bytes.order(ByteOrder.LITTLE_ENDIAN);
            RunLengthBitPackingHybridBufferDecoder rlDecoder = this.getRlDecoderPageV1(bytes);
            RunLengthBitPackingHybridBufferDecoder dlDecoder = this.getDlDecoderPageV1(bytes);
            KeyIndexReader dataReader = new KeyIndexReader((DictionaryValuesReader)this.getDataReader(page.getValueEncoding(), bytes, page.getValueCount(), channelContext));
            return this.readKeysFromPageCommon(keyDest, nullPlaceholder, rlDecoder, dlDecoder, dataReader);
        }
        catch (IOException e) {
            throw new ParquetDecodingException("could not read page " + page + " in col " + this.path, (Throwable)e);
        }
    }

    @Nullable
    private IntBuffer readKeysFromPageCommon(IntBuffer keyDest, int nullPlaceholder, RunLengthBitPackingHybridBufferDecoder rlDecoder, RunLengthBitPackingHybridBufferDecoder dlDecoder, ValuesReader dataReader) throws IOException {
        Object result = this.materialize(IntMaterializer.FACTORY, dlDecoder, rlDecoder, dataReader, nullPlaceholder);
        if (result instanceof DataWithOffsets) {
            keyDest.put((int[])((DataWithOffsets)result).materializeResult);
            return ((DataWithOffsets)result).offsets;
        }
        keyDest.put((int[])result);
        return null;
    }

    private int readRepetitionLevels(ByteBuffer byteBuffer) throws IOException {
        RunLengthBitPackingHybridBufferDecoder rlDecoder = new RunLengthBitPackingHybridBufferDecoder(this.path.getMaxRepetitionLevel(), byteBuffer);
        int rowsRead = 0;
        int totalCount = 0;
        while (rlDecoder.hasNext() && totalCount < this.numValues) {
            rlDecoder.readNextRange();
            int count = rlDecoder.currentRangeCount();
            if ((totalCount += count) > this.numValues) {
                count -= totalCount - this.numValues;
                totalCount = this.numValues;
            }
            if (rlDecoder.currentValue() != 0) continue;
            rowsRead += count;
        }
        return rowsRead;
    }

    private Object readPageV1(DataPageV1 page, Object nullValue, @NotNull SeekableChannelContext channelContext) {
        try {
            ByteBuffer bytes = page.getBytes().toByteBuffer();
            bytes.order(ByteOrder.LITTLE_ENDIAN);
            RunLengthBitPackingHybridBufferDecoder rlDecoder = this.getRlDecoderPageV1(bytes);
            RunLengthBitPackingHybridBufferDecoder dlDecoder = this.getDlDecoderPageV1(bytes);
            ValuesReader dataReader = this.getDataReader(page.getValueEncoding(), bytes, page.getValueCount(), channelContext);
            return this.materialize(this.pageMaterializerFactory, dlDecoder, rlDecoder, dataReader, nullValue);
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Failed to read parquet V1 page for column: " + this.columnName + ", uri: " + this.uri, (Throwable)e);
        }
    }

    private Object materialize(PageMaterializerFactory factory, RunLengthBitPackingHybridBufferDecoder dlDecoder, RunLengthBitPackingHybridBufferDecoder rlDecoder, ValuesReader dataReader, Object nullValue) throws IOException {
        if (dlDecoder == null) {
            return ColumnPageReaderImpl.materializeNonNull(factory, this.numValues, dataReader);
        }
        return this.materializeWithNulls(factory, dlDecoder, rlDecoder, dataReader, nullValue);
    }

    @Nullable
    private RunLengthBitPackingHybridBufferDecoder getRlDecoderPageV2(DataPageV2 page) throws IOException {
        if (this.path.getMaxRepetitionLevel() != 0) {
            return new RunLengthBitPackingHybridBufferDecoder(this.path.getMaxRepetitionLevel(), page.getRepetitionLevels().toByteBuffer());
        }
        return null;
    }

    @Nullable
    private RunLengthBitPackingHybridBufferDecoder getDlDecoderPageV2(DataPageV2 page) throws IOException {
        if (this.path.getMaxDefinitionLevel() > 0) {
            return new RunLengthBitPackingHybridBufferDecoder(this.path.getMaxDefinitionLevel(), page.getDefinitionLevels().toByteBuffer());
        }
        return null;
    }

    @Nullable
    private IntBuffer readKeysFromPageV2(DataPageV2 page, IntBuffer keyDest, int nullPlaceholder, @NotNull SeekableChannelContext channelContext) throws IOException {
        RunLengthBitPackingHybridBufferDecoder rlDecoder = this.getRlDecoderPageV2(page);
        RunLengthBitPackingHybridBufferDecoder dlDecoder = this.getDlDecoderPageV2(page);
        KeyIndexReader dataReader = new KeyIndexReader((DictionaryValuesReader)this.getDataReader(page.getDataEncoding(), page.getData().toByteBuffer(), page.getValueCount(), channelContext));
        return this.readKeysFromPageCommon(keyDest, nullPlaceholder, rlDecoder, dlDecoder, dataReader);
    }

    private Object readPageV2(DataPageV2 page, Object nullValue, @NotNull SeekableChannelContext channelContext) {
        try {
            RunLengthBitPackingHybridBufferDecoder rlDecoder = this.getRlDecoderPageV2(page);
            RunLengthBitPackingHybridBufferDecoder dlDecoder = this.getDlDecoderPageV2(page);
            ValuesReader dataReader = this.getDataReader(page.getDataEncoding(), page.getData().toByteBuffer(), page.getValueCount(), channelContext);
            return this.materialize(this.pageMaterializerFactory, dlDecoder, rlDecoder, dataReader, nullValue);
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Failed to read parquet V2 page for column: " + this.columnName + ", uri: " + this.uri, (Throwable)e);
        }
    }

    private static Object materializeWithNulls(PageMaterializerFactory factory, int numberOfValues, IntBuffer nullOffsets, ValuesReader dataReader, Object nullValue) {
        int nextNullPos;
        PageMaterializer materializer = factory.makeMaterializerWithNulls(dataReader, nullValue, numberOfValues);
        int startIndex = 0;
        int n = nextNullPos = nullOffsets.hasRemaining() ? nullOffsets.get() : numberOfValues;
        while (startIndex < numberOfValues) {
            int rangeEnd;
            for (rangeEnd = startIndex; nextNullPos == rangeEnd && rangeEnd < numberOfValues; ++rangeEnd) {
                nextNullPos = nullOffsets.hasRemaining() ? nullOffsets.get() : numberOfValues;
            }
            materializer.fillNulls(startIndex, rangeEnd);
            materializer.fillValues(rangeEnd, nextNullPos);
            startIndex = nextNullPos;
        }
        return materializer.data();
    }

    private static IntBuffer combineOptionalAndRepeating(IntBuffer nullOffsets, IntBuffer repeatingRanges, int nullValue) {
        int nextNullPos;
        IntBuffer result = IntBuffer.allocate(nullOffsets.limit() + repeatingRanges.limit());
        int startIndex = 0;
        int n = nextNullPos = nullOffsets.hasRemaining() ? nullOffsets.get() : result.capacity();
        while (result.hasRemaining()) {
            int i;
            int rangeEnd;
            for (rangeEnd = startIndex; nextNullPos == rangeEnd; ++rangeEnd) {
                nextNullPos = nullOffsets.hasRemaining() ? nullOffsets.get() : result.capacity();
            }
            for (i = startIndex; i < rangeEnd && result.hasRemaining(); ++i) {
                result.put(nullValue);
            }
            for (i = rangeEnd; i < nextNullPos; ++i) {
                result.put(repeatingRanges.get());
            }
            startIndex = nextNullPos;
        }
        result.flip();
        return result;
    }

    private Object materializeWithNulls(PageMaterializerFactory factory, RunLengthBitPackingHybridBufferDecoder dlDecoder, RunLengthBitPackingHybridBufferDecoder rlDecoder, ValuesReader dataReader, Object nullValue) throws IOException {
        Pair<Pair<Type.Repetition, IntBuffer>[], Integer> offsetsAndCount = this.getOffsetsAndNulls(dlDecoder, rlDecoder);
        int updatedNumValues = (Integer)offsetsAndCount.second;
        Pair[] offsetAndNulls = (Pair[])offsetsAndCount.first;
        ArrayList<IntBuffer> offsetsWithNull = new ArrayList<IntBuffer>();
        Buffer currentNullOffsets = null;
        for (Pair offsetAndNull : offsetAndNulls) {
            if (offsetAndNull.first == Type.Repetition.OPTIONAL) {
                if (currentNullOffsets != null) {
                    throw new UnsupportedOperationException("Failed to read parquet page because nested optional levels are not supported, found for column: " + this.columnName + ", uri: " + this.uri);
                }
                currentNullOffsets = (IntBuffer)offsetAndNull.second;
                continue;
            }
            if (currentNullOffsets != null) {
                offsetsWithNull.add(ColumnPageReaderImpl.combineOptionalAndRepeating((IntBuffer)currentNullOffsets, (IntBuffer)offsetAndNull.second, -1));
                currentNullOffsets = null;
                continue;
            }
            offsetsWithNull.add((IntBuffer)offsetAndNull.second);
        }
        Object values = currentNullOffsets != null && currentNullOffsets.hasRemaining() ? ColumnPageReaderImpl.materializeWithNulls(factory, updatedNumValues, (IntBuffer)currentNullOffsets, dataReader, nullValue) : ColumnPageReaderImpl.materializeNonNull(factory, updatedNumValues, dataReader);
        if (offsetsWithNull.isEmpty()) {
            return values;
        }
        if (offsetsWithNull.size() == 1) {
            return new DataWithOffsets((IntBuffer)offsetsWithNull.get(0), values);
        }
        return new DataWithMultiLevelOffsets(offsetsWithNull.toArray(new IntBuffer[0]), values);
    }

    private static Object materializeNonNull(PageMaterializerFactory factory, int numberOfValues, ValuesReader dataReader) {
        return factory.makeMaterializerNonNull(dataReader, numberOfValues).fillAll();
    }

    private ValuesReader getDataReader(org.apache.parquet.column.Encoding dataEncoding, ByteBuffer in, int valueCount, @NotNull SeekableChannelContext channelContext) {
        ValuesReader dataReader;
        if (dataEncoding == org.apache.parquet.column.Encoding.DELTA_BYTE_ARRAY) {
            throw new RuntimeException("DELTA_BYTE_ARRAY encoding not supported");
        }
        if (dataEncoding.usesDictionary()) {
            Dictionary dictionary = this.dictionarySupplier.apply(channelContext);
            if (dictionary == ColumnChunkReader.NULL_DICTIONARY) {
                throw new ParquetDecodingException("Failed to read parquet page for column: " + this.columnName + ", uri: " + this.uri + " as the dictionary was missing for encoding: " + dataEncoding);
            }
            dataReader = new DictionaryValuesReader(dictionary);
        } else {
            dataReader = dataEncoding.getValuesReader(this.path, ValuesType.VALUES);
        }
        try {
            dataReader.initFromPage(valueCount, ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{in}));
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Failed to read parquet page for column: " + this.columnName + ", uri: " + this.uri, (Throwable)e);
        }
        return dataReader;
    }

    @Override
    public int numValues() {
        return this.numValues;
    }

    @Override
    @NotNull
    public Dictionary getDictionary(@NotNull SeekableChannelContext channelContext) {
        return this.dictionarySupplier.apply(channelContext);
    }

    @Override
    public void close() {
    }

    @Override
    public long numRows(@NotNull SeekableChannelContext channelContext) throws IOException {
        if (this.rowCount == -1) {
            this.rowCount = this.path.getMaxRepetitionLevel() == 0 ? this.numValues() : this.readRowCount(channelContext);
        }
        return this.rowCount;
    }

    private Pair<Pair<Type.Repetition, IntBuffer>[], Integer> getOffsetsAndNulls(RunLengthBitPackingHybridBufferDecoder dlDecoder, RunLengthBitPackingHybridBufferDecoder rlDecoder) throws IOException {
        int currentRangeSize;
        dlDecoder.readNextRange();
        if (rlDecoder != null) {
            rlDecoder.readNextRange();
        }
        int dlRangeSize = dlDecoder.currentRangeCount();
        int currentDl = dlDecoder.currentValue();
        int rlRangeSize = rlDecoder == null ? this.numValues : rlDecoder.currentRangeCount();
        int currentRl = rlDecoder == null ? 0 : rlDecoder.currentValue();
        LevelsController levelsController = new LevelsController((Type.Repetition[])this.fieldTypes.stream().map(Type::getRepetition).toArray(Type.Repetition[]::new));
        for (int valuesProcessed = 0; valuesProcessed < this.numValues; valuesProcessed += currentRangeSize) {
            if (dlRangeSize == 0) {
                dlDecoder.readNextRange();
                dlRangeSize = Math.min(this.numValues - valuesProcessed, dlDecoder.currentRangeCount());
                currentDl = dlDecoder.currentValue();
            }
            if (rlRangeSize == 0) {
                rlDecoder.readNextRange();
                rlRangeSize = Math.min(this.numValues - valuesProcessed, rlDecoder.currentRangeCount());
                currentRl = rlDecoder.currentValue();
            }
            currentRangeSize = Math.min(dlRangeSize, rlRangeSize);
            dlRangeSize -= currentRangeSize;
            rlRangeSize -= currentRangeSize;
            levelsController.addElements(currentRl, currentDl, currentRangeSize);
        }
        return levelsController.getFinalState();
    }
}

