/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base;

import io.deephaven.parquet.base.BulkWriter;
import io.deephaven.parquet.base.ColumnWriter;
import io.deephaven.parquet.base.NullStatistics;
import io.deephaven.parquet.base.PlainBinaryChunkedWriter;
import io.deephaven.parquet.base.PlainBooleanChunkedWriter;
import io.deephaven.parquet.base.PlainDoubleChunkedWriter;
import io.deephaven.parquet.base.PlainFloatChunkedWriter;
import io.deephaven.parquet.base.PlainIntChunkedWriter;
import io.deephaven.parquet.base.PlainLongChunkedWriter;
import io.deephaven.parquet.base.PositionedBufferedOutputStream;
import io.deephaven.parquet.base.RleIntChunkedWriter;
import io.deephaven.parquet.base.RowGroupWriterImpl;
import io.deephaven.parquet.compress.CompressorAdapter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.HashSet;
import java.util.Set;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.EncodingStats;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridEncoder;
import org.apache.parquet.format.DataPageHeader;
import org.apache.parquet.format.DataPageHeaderV2;
import org.apache.parquet.format.DictionaryPageHeader;
import org.apache.parquet.format.Encoding;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.PageType;
import org.apache.parquet.format.Util;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.internal.column.columnindex.OffsetIndexBuilder;
import org.apache.parquet.io.ParquetEncodingException;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.jetbrains.annotations.NotNull;

final class ColumnWriterImpl
implements ColumnWriter {
    private static final int MIN_SLAB_SIZE = 64;
    private final PositionedBufferedOutputStream bufferedOutput;
    private final ColumnDescriptor column;
    private final RowGroupWriterImpl owner;
    private final CompressorAdapter compressorAdapter;
    private boolean hasDictionary;
    private int pageCount = 0;
    private Statistics<?> statistics;
    private static final ParquetMetadataConverter metadataConverter = new ParquetMetadataConverter();
    private BulkWriter bulkWriter;
    private final int targetPageSize;
    private final ByteBufferAllocator allocator;
    private final RunLengthBitPackingHybridEncoder dlEncoder;
    private final RunLengthBitPackingHybridEncoder rlEncoder;
    private long dictionaryOffset = -1L;
    private final Set<org.apache.parquet.column.Encoding> encodings = new HashSet<org.apache.parquet.column.Encoding>();
    private long firstDataPageOffset = -1L;
    private long uncompressedLength;
    private long compressedLength;
    private long totalValueCount;
    private DictionaryPageHeader dictionaryPage;
    private final OffsetIndexBuilder offsetIndexBuilder;
    private final EncodingStats.Builder encodingStatsBuilder = new EncodingStats.Builder();

    ColumnWriterImpl(RowGroupWriterImpl owner, PositionedBufferedOutputStream bufferedOutput, ColumnDescriptor column, CompressorAdapter compressorAdapter, int targetPageSize, ByteBufferAllocator allocator) {
        this.bufferedOutput = bufferedOutput;
        this.column = column;
        this.compressorAdapter = compressorAdapter;
        this.targetPageSize = targetPageSize;
        this.allocator = allocator;
        this.dlEncoder = column.getMaxDefinitionLevel() == 0 ? null : new RunLengthBitPackingHybridEncoder(BytesUtils.getWidthFromMaxInt((int)column.getMaxDefinitionLevel()), 64, targetPageSize, allocator);
        this.rlEncoder = column.getMaxRepetitionLevel() == 0 ? null : new RunLengthBitPackingHybridEncoder(BytesUtils.getWidthFromMaxInt((int)column.getMaxRepetitionLevel()), 64, targetPageSize, allocator);
        this.owner = owner;
        this.offsetIndexBuilder = OffsetIndexBuilder.getBuilder();
        this.statistics = Statistics.createStats((Type)column.getPrimitiveType());
    }

    @Override
    public void addPageNoNulls(@NotNull Object pageData, int valuesCount, @NotNull Statistics<?> statistics) throws IOException {
        this.initWriter();
        this.bulkWriter.writeBulk(pageData, valuesCount, statistics);
        if (this.dlEncoder != null) {
            for (int i = 0; i < valuesCount; ++i) {
                this.dlEncoder.writeInt(1);
            }
        }
        this.writePage(this.bulkWriter.getByteBufferView(), valuesCount, valuesCount);
        this.bulkWriter.reset();
    }

    private void initWriter() {
        if (this.bulkWriter == null) {
            this.bulkWriter = this.hasDictionary ? new RleIntChunkedWriter(this.targetPageSize, this.allocator, (byte)(32 - Integer.numberOfLeadingZeros(this.dictionaryPage.num_values))) : this.getWriter(this.column.getPrimitiveType());
        } else {
            this.bulkWriter.reset();
        }
    }

    @Override
    public void addDictionaryPage(@NotNull Object dictionaryValues, int valuesCount) throws IOException {
        if (this.pageCount > 0) {
            throw new IllegalStateException("Attempting to add dictionary past the first page");
        }
        this.encodingStatsBuilder.addDictEncoding(org.apache.parquet.column.Encoding.PLAIN);
        BulkWriter dictionaryWriter = this.getWriter(this.column.getPrimitiveType());
        dictionaryWriter.writeBulk(dictionaryValues, valuesCount, (Statistics<?>)NullStatistics.INSTANCE);
        this.dictionaryOffset = this.bufferedOutput.position();
        this.writeDictionaryPage(dictionaryWriter.getByteBufferView(), valuesCount);
        ++this.pageCount;
        this.hasDictionary = true;
        this.dictionaryPage = new DictionaryPageHeader(valuesCount, Encoding.PLAIN);
    }

    private void writeDictionaryPage(ByteBuffer dictionaryBuffer, int valuesCount) throws IOException {
        long currentChunkDictionaryPageOffset = this.bufferedOutput.position();
        int uncompressedSize = dictionaryBuffer.remaining();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (WritableByteChannel channel = Channels.newChannel(this.compressorAdapter.compress((OutputStream)baos));){
            channel.write(dictionaryBuffer);
        }
        this.compressorAdapter.reset();
        BytesInput compressedBytes = BytesInput.from((ByteArrayOutputStream)baos);
        int compressedPageSize = (int)compressedBytes.size();
        metadataConverter.writeDictionaryPageHeader(uncompressedSize, compressedPageSize, valuesCount, org.apache.parquet.column.Encoding.PLAIN, (OutputStream)this.bufferedOutput);
        long headerSize = this.bufferedOutput.position() - currentChunkDictionaryPageOffset;
        this.uncompressedLength += (long)uncompressedSize + headerSize;
        this.compressedLength += (long)compressedPageSize + headerSize;
        compressedBytes.writeAllTo((OutputStream)this.bufferedOutput);
        this.encodings.add(org.apache.parquet.column.Encoding.PLAIN);
    }

    private BulkWriter getWriter(PrimitiveType primitiveType) {
        switch (primitiveType.getPrimitiveTypeName()) {
            case INT96: 
            case FIXED_LEN_BYTE_ARRAY: {
                throw new UnsupportedOperationException("No support for writing FIXED_LENGTH or INT96 types");
            }
            case INT32: {
                LogicalTypeAnnotation annotation = primitiveType.getLogicalTypeAnnotation();
                if (annotation != null) {
                    if (LogicalTypeAnnotation.intType((int)8, (boolean)true).equals((Object)annotation)) {
                        return new PlainIntChunkedWriter(this.targetPageSize, this.allocator, -128);
                    }
                    if (LogicalTypeAnnotation.intType((int)16, (boolean)true).equals((Object)annotation)) {
                        return new PlainIntChunkedWriter(this.targetPageSize, this.allocator, Short.MIN_VALUE);
                    }
                    if (LogicalTypeAnnotation.intType((int)16, (boolean)false).equals((Object)annotation)) {
                        return new PlainIntChunkedWriter(this.targetPageSize, this.allocator, 65535);
                    }
                }
                return new PlainIntChunkedWriter(this.targetPageSize, this.allocator);
            }
            case INT64: {
                return new PlainLongChunkedWriter(this.targetPageSize, this.allocator);
            }
            case FLOAT: {
                return new PlainFloatChunkedWriter(this.targetPageSize, this.allocator);
            }
            case DOUBLE: {
                return new PlainDoubleChunkedWriter(this.targetPageSize, this.allocator);
            }
            case BINARY: {
                return new PlainBinaryChunkedWriter(this.targetPageSize, this.allocator);
            }
            case BOOLEAN: {
                return new PlainBooleanChunkedWriter();
            }
        }
        throw new UnsupportedOperationException("Unknown type " + primitiveType.getPrimitiveTypeName());
    }

    @Override
    public void addPage(@NotNull Object pageData, int valuesCount, @NotNull Statistics<?> statistics) throws IOException {
        if (this.dlEncoder == null) {
            throw new IllegalStateException("Null values not supported");
        }
        this.initWriter();
        this.bulkWriter.writeBulkFilterNulls(pageData, this.dlEncoder, valuesCount, statistics);
        this.writePage(this.bulkWriter.getByteBufferView(), valuesCount, valuesCount);
        this.bulkWriter.reset();
    }

    @Override
    public void addVectorPage(@NotNull Object pageData, @NotNull IntBuffer repeatCount, int nonNullValueCount, @NotNull Statistics<?> statistics) throws IOException {
        if (this.dlEncoder == null) {
            throw new IllegalStateException("Null values not supported");
        }
        if (this.rlEncoder == null) {
            throw new IllegalStateException("Repeating values not supported");
        }
        this.initWriter();
        int valueCount = this.bulkWriter.writeBulkVector(pageData, repeatCount, this.rlEncoder, this.dlEncoder, nonNullValueCount, statistics);
        this.writePage(this.bulkWriter.getByteBufferView(), valueCount, repeatCount.limit());
        this.bulkWriter.reset();
    }

    private void writeDataPageV2Header(int uncompressedSize, int compressedSize, int valueCount, int nullCount, int rowCount, int rlByteLength, int dlByteLength, OutputStream to) throws IOException {
        Util.writePageHeader((PageHeader)this.newDataPageV2Header(uncompressedSize, compressedSize, valueCount, nullCount, rowCount, rlByteLength, dlByteLength), (OutputStream)to);
    }

    private PageHeader newDataPageV2Header(int uncompressedSize, int compressedSize, int valueCount, int nullCount, int rowCount, int rlByteLength, int dlByteLength) {
        DataPageHeaderV2 dataPageHeaderV2 = new DataPageHeaderV2(valueCount, nullCount, rowCount, this.hasDictionary ? Encoding.PLAIN_DICTIONARY : Encoding.PLAIN, dlByteLength, rlByteLength);
        PageHeader pageHeader = new PageHeader(PageType.DATA_PAGE_V2, uncompressedSize, compressedSize);
        pageHeader.setData_page_header_v2(dataPageHeaderV2);
        if (this.hasDictionary) {
            pageHeader.setDictionary_page_header(this.dictionaryPage);
        }
        this.encodings.add(org.apache.parquet.column.Encoding.valueOf((String)dataPageHeaderV2.encoding.name()));
        return pageHeader;
    }

    public void writePageV2(int rowCount, int nullCount, int valueCount, BytesInput repetitionLevels, BytesInput definitionLevels, ByteBuffer data) throws IOException {
        int rlByteLength = (int)repetitionLevels.size();
        int dlByteLength = (int)definitionLevels.size();
        int uncompressedDataSize = data.remaining();
        int uncompressedSize = (int)((long)uncompressedDataSize + repetitionLevels.size() + definitionLevels.size());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (WritableByteChannel channel = Channels.newChannel(this.compressorAdapter.compress((OutputStream)baos));){
            channel.write(data);
        }
        this.compressorAdapter.reset();
        BytesInput compressedData = BytesInput.from((ByteArrayOutputStream)baos);
        int compressedSize = (int)(compressedData.size() + repetitionLevels.size() + definitionLevels.size());
        long initialOffset = this.bufferedOutput.position();
        if (this.firstDataPageOffset == -1L) {
            this.firstDataPageOffset = initialOffset;
        }
        this.writeDataPageV2Header(uncompressedSize, compressedSize, valueCount, nullCount, rowCount, rlByteLength, dlByteLength, this.bufferedOutput);
        long headerSize = this.bufferedOutput.position() - initialOffset;
        this.uncompressedLength += (long)uncompressedSize + headerSize;
        this.compressedLength += (long)compressedSize + headerSize;
        this.totalValueCount += (long)valueCount;
        ++this.pageCount;
        definitionLevels.writeAllTo((OutputStream)this.bufferedOutput);
        compressedData.writeAllTo((OutputStream)this.bufferedOutput);
    }

    private void writePage(BytesInput bytes, int valueCount, long rowCount, org.apache.parquet.column.Encoding valuesEncoding) throws IOException {
        long uncompressedSize;
        long initialOffset = this.bufferedOutput.position();
        if (this.firstDataPageOffset == -1L) {
            this.firstDataPageOffset = initialOffset;
        }
        if ((uncompressedSize = bytes.size()) > Integer.MAX_VALUE) {
            throw new ParquetEncodingException("Cannot write page larger than Integer.MAX_VALUE bytes: " + uncompressedSize);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (OutputStream cos = this.compressorAdapter.compress((OutputStream)baos);){
            bytes.writeAllTo(cos);
        }
        this.compressorAdapter.reset();
        BytesInput compressedBytes = BytesInput.from((ByteArrayOutputStream)baos);
        long compressedSize = compressedBytes.size();
        if (compressedSize > Integer.MAX_VALUE) {
            throw new ParquetEncodingException("Cannot write compressed page larger than Integer.MAX_VALUE bytes: " + compressedSize);
        }
        this.writeDataPageV1Header((int)uncompressedSize, (int)compressedSize, valueCount, valuesEncoding, this.bufferedOutput);
        long headerSize = this.bufferedOutput.position() - initialOffset;
        this.uncompressedLength += uncompressedSize + headerSize;
        this.compressedLength += compressedSize + headerSize;
        this.totalValueCount += (long)valueCount;
        ++this.pageCount;
        compressedBytes.writeAllTo((OutputStream)this.bufferedOutput);
        this.offsetIndexBuilder.add((int)(this.bufferedOutput.position() - initialOffset), rowCount);
        this.encodings.add(valuesEncoding);
        this.encodingStatsBuilder.addDataEncoding(valuesEncoding);
    }

    private void writeDataPageV1Header(int uncompressedSize, int compressedSize, int valueCount, org.apache.parquet.column.Encoding valuesEncoding, OutputStream to) throws IOException {
        Util.writePageHeader((PageHeader)ColumnWriterImpl.newDataPageHeader(uncompressedSize, compressedSize, valueCount, valuesEncoding), (OutputStream)to);
    }

    private static PageHeader newDataPageHeader(int uncompressedSize, int compressedSize, int valueCount, org.apache.parquet.column.Encoding valuesEncoding) {
        PageHeader pageHeader = new PageHeader(PageType.DATA_PAGE, uncompressedSize, compressedSize);
        pageHeader.setData_page_header(new DataPageHeader(valueCount, Encoding.valueOf((String)valuesEncoding.name()), Encoding.valueOf((String)org.apache.parquet.column.Encoding.RLE.name()), Encoding.valueOf((String)org.apache.parquet.column.Encoding.RLE.name())));
        return pageHeader;
    }

    private void writePage(ByteBuffer encodedData, long valueCount, long rowCount) {
        try {
            BytesInput bytes = BytesInput.from((ByteBuffer[])new ByteBuffer[]{encodedData});
            if (this.dlEncoder != null) {
                BytesInput dlBytesInput = this.dlEncoder.toBytes();
                bytes = BytesInput.concat((BytesInput[])new BytesInput[]{BytesInput.fromInt((int)((int)dlBytesInput.size())), dlBytesInput, bytes});
            }
            if (this.rlEncoder != null) {
                BytesInput rlBytesInput = this.rlEncoder.toBytes();
                bytes = BytesInput.concat((BytesInput[])new BytesInput[]{BytesInput.fromInt((int)((int)rlBytesInput.size())), rlBytesInput, bytes});
            }
            this.writePage(bytes, (int)valueCount, rowCount, this.hasDictionary ? org.apache.parquet.column.Encoding.RLE_DICTIONARY : org.apache.parquet.column.Encoding.PLAIN);
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write page for " + this.column.getPath()[0], (Throwable)e);
        }
        if (this.dlEncoder != null) {
            this.dlEncoder.reset();
        }
        if (this.rlEncoder != null) {
            this.rlEncoder.reset();
        }
    }

    public void close() {
        this.owner.releaseWriter(this, ColumnChunkMetaData.get((ColumnPath)ColumnPath.get((String[])this.column.getPath()), (PrimitiveType)this.column.getPrimitiveType(), (CompressionCodecName)this.compressorAdapter.getCodecName(), (EncodingStats)this.encodingStatsBuilder.build(), this.encodings, this.statistics, (long)this.firstDataPageOffset, (long)this.dictionaryOffset, (long)this.totalValueCount, (long)this.compressedLength, (long)this.uncompressedLength));
    }

    public ColumnDescriptor getColumn() {
        return this.column;
    }

    OffsetIndex getOffsetIndex() {
        return this.offsetIndexBuilder.build(this.firstDataPageOffset);
    }

    @Override
    public void resetStats() {
        this.statistics = Statistics.createStats((Type)this.column.getPrimitiveType());
    }

    @Override
    public Statistics<?> getStats() {
        return this.statistics;
    }
}

