/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base;

import io.deephaven.base.Pair;
import java.nio.IntBuffer;
import java.util.Arrays;
import org.apache.parquet.schema.Type;

class LevelsController {
    private final Level[] levelsList;
    private final int[] repeatLevelToDefLevel;

    LevelsController(Type.Repetition ... levels) {
        Type.Repetition[] newLevels = new Type.Repetition[levels.length + 1];
        newLevels[0] = Type.Repetition.REPEATED;
        System.arraycopy(levels, 0, newLevels, 1, levels.length);
        levels = newLevels;
        this.levelsList = new Level[levels.length];
        this.repeatLevelToDefLevel = new int[(int)Arrays.stream(levels).filter(levelType -> levelType == Type.Repetition.REPEATED).count()];
        int rlPos = 0;
        for (int i = 0; i < levels.length; ++i) {
            this.levelsList[i] = this.buildLevel(levels[i]);
            if (levels[i] != Type.Repetition.REPEATED) continue;
            this.repeatLevelToDefLevel[rlPos++] = i;
        }
        this.levelsList[0].addElements(1);
    }

    private Level buildLevel(Type.Repetition level) {
        switch (level) {
            case OPTIONAL: {
                return new OptionalLevel();
            }
            case REPEATED: {
                return new RepeatingLevel();
            }
        }
        throw new UnsupportedOperationException("No need for processing " + level);
    }

    void addElements(int repeatLevel, int defLevel, int elementsCount) {
        int correspondingDefLevel = this.repeatLevelToDefLevel[repeatLevel];
        this.levelsList[correspondingDefLevel].addValues(elementsCount);
        for (int i = correspondingDefLevel + 1; i <= defLevel; ++i) {
            this.levelsList[i].addElements(elementsCount);
        }
        if (defLevel + 1 < this.levelsList.length) {
            this.levelsList[defLevel + 1].addNulls(elementsCount);
        }
    }

    Pair<Pair<Type.Repetition, IntBuffer>[], Integer> getFinalState() {
        int childCount = this.levelsList[this.levelsList.length - 1].childCount();
        if (this.levelsList.length == 1) {
            --childCount;
        }
        return new Pair((Object)((Pair[])Arrays.stream(this.levelsList).skip(1L).map(Level::finalState).toArray(Pair[]::new)), (Object)childCount);
    }

    private static IntBuffer ensureCapacity(IntBuffer nullOffsets, int extraElementsCount) {
        while (nullOffsets.remaining() < extraElementsCount) {
            nullOffsets.flip();
            IntBuffer newBuf = IntBuffer.allocate(nullOffsets.capacity() * 2);
            newBuf.put(nullOffsets);
            nullOffsets = newBuf;
        }
        return nullOffsets;
    }

    static class OptionalLevel
    implements Level {
        int currentCount;
        private IntBuffer nullOffsets = IntBuffer.allocate(4);

        OptionalLevel() {
        }

        @Override
        public void addElements(int elementsCount) {
            this.currentCount += elementsCount;
        }

        @Override
        public void addValues(int valuesCount) {
            throw new UnsupportedOperationException("Optional levels don't allow multiple values - use addElements");
        }

        @Override
        public void addNulls(int elementsCount) {
            this.nullOffsets = LevelsController.ensureCapacity(this.nullOffsets, elementsCount);
            for (int i = 0; i < elementsCount; ++i) {
                this.nullOffsets.put(this.currentCount++);
            }
        }

        @Override
        public Pair<Type.Repetition, IntBuffer> finalState() {
            this.nullOffsets.flip();
            return new Pair((Object)Type.Repetition.OPTIONAL, (Object)this.nullOffsets);
        }

        @Override
        public int childCount() {
            return this.currentCount;
        }
    }

    static class RepeatingLevel
    implements Level {
        int childValueCount = 0;
        private IntBuffer rangeCap = IntBuffer.allocate(4);

        RepeatingLevel() {
        }

        @Override
        public void addElements(int elementsCount) {
            this.rangeCap = LevelsController.ensureCapacity(this.rangeCap, elementsCount);
            for (int i = 0; i < elementsCount; ++i) {
                this.rangeCap.put(++this.childValueCount);
            }
        }

        @Override
        public void addValues(int valuesCount) {
            if (this.rangeCap.position() == 0) {
                throw new IllegalStateException("Cannot add more values to this repeating level. It's possible that a single row is getting split across pages, which is not supported.");
            }
            this.rangeCap.put(this.rangeCap.position() - 1, this.childValueCount += valuesCount);
        }

        @Override
        public void addNulls(int elementsCount) {
            this.rangeCap = LevelsController.ensureCapacity(this.rangeCap, elementsCount);
            for (int i = 0; i < elementsCount; ++i) {
                this.rangeCap.put(this.childValueCount);
            }
        }

        @Override
        public Pair<Type.Repetition, IntBuffer> finalState() {
            this.rangeCap.flip();
            return new Pair((Object)Type.Repetition.REPEATED, (Object)this.rangeCap);
        }

        @Override
        public int childCount() {
            return this.childValueCount;
        }
    }

    static interface Level {
        public void addElements(int var1);

        public void addValues(int var1);

        public void addNulls(int var1);

        public Pair<Type.Repetition, IntBuffer> finalState();

        public int childCount();
    }
}

