/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base;

import io.deephaven.base.FileUtils;
import io.deephaven.parquet.base.Helpers;
import io.deephaven.parquet.base.InvalidParquetFileException;
import io.deephaven.parquet.base.ParquetFileReaderException;
import io.deephaven.parquet.base.ParquetUtils;
import io.deephaven.parquet.base.RowGroupReader;
import io.deephaven.parquet.base.RowGroupReaderImpl;
import io.deephaven.util.channel.CachedChannelProvider;
import io.deephaven.util.channel.SeekableChannelContext;
import io.deephaven.util.channel.SeekableChannelsProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.parquet.format.ColumnChunk;
import org.apache.parquet.format.ColumnMetaData;
import org.apache.parquet.format.ColumnOrder;
import org.apache.parquet.format.ConvertedType;
import org.apache.parquet.format.DecimalType;
import org.apache.parquet.format.Encoding;
import org.apache.parquet.format.FieldRepetitionType;
import org.apache.parquet.format.FileMetaData;
import org.apache.parquet.format.IntType;
import org.apache.parquet.format.LogicalType;
import org.apache.parquet.format.PageEncodingStats;
import org.apache.parquet.format.PageType;
import org.apache.parquet.format.RowGroup;
import org.apache.parquet.format.SchemaElement;
import org.apache.parquet.format.TimeType;
import org.apache.parquet.format.TimeUnit;
import org.apache.parquet.format.TimestampType;
import org.apache.parquet.format.Type;
import org.apache.parquet.format.Util;
import org.apache.parquet.schema.ColumnOrder;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.jetbrains.annotations.NotNull;

public class ParquetFileReader {
    private static final int FOOTER_LENGTH_SIZE = 4;
    public static final String FILE_URI_SCHEME = "file";
    public final FileMetaData fileMetaData;
    private final SeekableChannelsProvider channelsProvider;
    private final URI rootURI;
    private final MessageType type;
    private Set<String> columnsWithDictionaryUsedOnEveryDataPage = null;

    public static ParquetFileReader create(@NotNull File parquetFile, @NotNull SeekableChannelsProvider channelsProvider) {
        try {
            return new ParquetFileReader(FileUtils.convertToURI((File)parquetFile, (boolean)false), channelsProvider);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create Parquet file reader: " + parquetFile, e);
        }
    }

    public static ParquetFileReader create(@NotNull URI parquetFileURI, @NotNull SeekableChannelsProvider channelsProvider) {
        try {
            return new ParquetFileReader(parquetFileURI, channelsProvider);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create Parquet file reader: " + parquetFileURI, e);
        }
    }

    private ParquetFileReader(@NotNull URI parquetFileURI, @NotNull SeekableChannelsProvider provider) throws IOException {
        this.channelsProvider = CachedChannelProvider.create((SeekableChannelsProvider)provider, (int)128);
        this.rootURI = !parquetFileURI.getRawPath().endsWith(".parquet") && FILE_URI_SCHEME.equals(parquetFileURI.getScheme()) ? FileUtils.convertToURI((File)new File(parquetFileURI).getParentFile(), (boolean)true) : parquetFileURI;
        try (SeekableChannelContext context = this.channelsProvider.makeSingleUseContext();
             SeekableByteChannel ch = this.channelsProvider.getReadChannel(context, parquetFileURI);){
            int footerLength = ParquetFileReader.positionToFileMetadata(parquetFileURI, ch);
            try (InputStream in = this.channelsProvider.getInputStream(ch, footerLength);){
                this.fileMetaData = Util.readFileMetaData((InputStream)in);
            }
        }
        this.type = ParquetFileReader.fromParquetSchema(this.fileMetaData.schema, this.fileMetaData.column_orders);
    }

    private static int positionToFileMetadata(URI parquetFileURI, SeekableByteChannel readChannel) throws IOException {
        long fileLen = readChannel.size();
        if (fileLen < (long)(ParquetUtils.MAGIC.length + 4 + ParquetUtils.MAGIC.length)) {
            throw new InvalidParquetFileException(parquetFileURI + " is not a Parquet file (too small length: " + fileLen + ")");
        }
        byte[] trailer = new byte[4 + ParquetUtils.MAGIC.length];
        long footerLengthIndex = fileLen - 4L - (long)ParquetUtils.MAGIC.length;
        readChannel.position(footerLengthIndex);
        Helpers.readBytes((ReadableByteChannel)readChannel, trailer);
        if (!Arrays.equals(ParquetUtils.MAGIC, 0, ParquetUtils.MAGIC.length, trailer, 4, trailer.length)) {
            throw new InvalidParquetFileException(parquetFileURI + " is not a Parquet file. expected magic number at tail " + Arrays.toString(ParquetUtils.MAGIC) + " but found " + Arrays.toString(Arrays.copyOfRange(trailer, 4, trailer.length)));
        }
        int footerLength = ParquetFileReader.makeLittleEndianInt(trailer[0], trailer[1], trailer[2], trailer[3]);
        long footerIndex = footerLengthIndex - (long)footerLength;
        if (footerIndex < (long)ParquetUtils.MAGIC.length || footerIndex >= footerLengthIndex) {
            throw new InvalidParquetFileException("corrupted file: the footer index is not within the file: " + footerIndex);
        }
        readChannel.position(footerIndex);
        return footerLength;
    }

    private static int makeLittleEndianInt(byte b0, byte b1, byte b2, byte b3) {
        return b0 & 0xFF | (b1 & 0xFF) << 8 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 24;
    }

    public SeekableChannelsProvider getChannelsProvider() {
        return this.channelsProvider;
    }

    public Set<String> getColumnsWithDictionaryUsedOnEveryDataPage() {
        if (this.columnsWithDictionaryUsedOnEveryDataPage == null) {
            this.columnsWithDictionaryUsedOnEveryDataPage = this.calculateColumnsWithDictionaryUsedOnEveryDataPage();
        }
        return this.columnsWithDictionaryUsedOnEveryDataPage;
    }

    private static boolean columnChunkUsesDictionaryOnEveryPage(ColumnChunk columnChunk) {
        ColumnMetaData columnMeta = columnChunk.getMeta_data();
        if (columnMeta.encoding_stats == null) {
            return false;
        }
        for (PageEncodingStats encodingStat : columnMeta.encoding_stats) {
            if (encodingStat.page_type != PageType.DATA_PAGE && encodingStat.page_type != PageType.DATA_PAGE_V2 || encodingStat.encoding == Encoding.PLAIN_DICTIONARY || encodingStat.encoding == Encoding.RLE_DICTIONARY) continue;
            return false;
        }
        return true;
    }

    private Set<String> calculateColumnsWithDictionaryUsedOnEveryDataPage() {
        HashSet<String> result = new HashSet<String>(this.fileMetaData.getSchemaSize());
        List rowGroups = this.fileMetaData.getRow_groups();
        Iterator riter = rowGroups.iterator();
        if (!riter.hasNext()) {
            for (SchemaElement se : this.fileMetaData.getSchema()) {
                if (se.isSetNum_children()) continue;
                result.add(se.getName());
            }
            return result;
        }
        RowGroup rg0 = (RowGroup)riter.next();
        for (ColumnChunk columnChunk : rg0.columns) {
            if (!ParquetFileReader.columnChunkUsesDictionaryOnEveryPage(columnChunk)) continue;
            String parquetColumnName = (String)columnChunk.getMeta_data().path_in_schema.get(0);
            result.add(parquetColumnName);
        }
        while (riter.hasNext()) {
            RowGroup rowGroup = (RowGroup)riter.next();
            for (ColumnChunk columnChunk : rowGroup.columns) {
                String parquetColumnName = (String)columnChunk.getMeta_data().path_in_schema.get(0);
                if (!result.contains(parquetColumnName) || ParquetFileReader.columnChunkUsesDictionaryOnEveryPage(columnChunk)) continue;
                result.remove(parquetColumnName);
            }
        }
        return result;
    }

    public RowGroupReader getRowGroup(int groupNumber, String version) {
        return new RowGroupReaderImpl((RowGroup)this.fileMetaData.getRow_groups().get(groupNumber), this.channelsProvider, this.rootURI, this.type, this.getSchema(), version);
    }

    private static MessageType fromParquetSchema(List<SchemaElement> schema, List<ColumnOrder> columnOrders) throws ParquetFileReaderException {
        Iterator<SchemaElement> iterator = schema.iterator();
        SchemaElement root = iterator.next();
        Types.MessageTypeBuilder builder = Types.buildMessage();
        if (root.isSetField_id()) {
            builder.id(root.field_id);
        }
        ParquetFileReader.buildChildren((Types.GroupBuilder)builder, iterator, root.getNum_children(), columnOrders, 0);
        return builder.named(root.name);
    }

    private static void buildChildren(Types.GroupBuilder builder, Iterator<SchemaElement> schema, int childrenCount, List<ColumnOrder> columnOrders, int columnCount) throws ParquetFileReaderException {
        for (int i = 0; i < childrenCount; ++i) {
            Types.GroupBuilder childBuilder;
            SchemaElement schemaElement = schema.next();
            if (schemaElement.type != null) {
                Types.PrimitiveBuilder primitiveBuilder = builder.primitive(ParquetFileReader.getPrimitive(schemaElement.type), ParquetFileReader.fromParquetRepetition(schemaElement.repetition_type));
                if (schemaElement.isSetType_length()) {
                    primitiveBuilder.length(schemaElement.type_length);
                }
                if (schemaElement.isSetPrecision()) {
                    primitiveBuilder.precision(schemaElement.precision);
                }
                if (schemaElement.isSetScale()) {
                    primitiveBuilder.scale(schemaElement.scale);
                }
                if (columnOrders != null) {
                    org.apache.parquet.schema.ColumnOrder columnOrder = ParquetFileReader.fromParquetColumnOrder(columnOrders.get(columnCount));
                    if (columnOrder.getColumnOrderName() == ColumnOrder.ColumnOrderName.TYPE_DEFINED_ORDER && (schemaElement.type == Type.INT96 || schemaElement.converted_type == ConvertedType.INTERVAL)) {
                        columnOrder = org.apache.parquet.schema.ColumnOrder.undefined();
                    }
                    primitiveBuilder.columnOrder(columnOrder);
                }
                childBuilder = primitiveBuilder;
            } else {
                childBuilder = builder.group(ParquetFileReader.fromParquetRepetition(schemaElement.repetition_type));
                ParquetFileReader.buildChildren(childBuilder, schema, schemaElement.num_children, columnOrders, columnCount);
            }
            if (schemaElement.isSetLogicalType()) {
                ((Types.Builder)childBuilder).as(ParquetFileReader.getLogicalTypeAnnotation(schemaElement.logicalType));
            }
            if (schemaElement.isSetConverted_type()) {
                LogicalTypeAnnotation newOriginalType;
                LogicalTypeAnnotation originalType = ParquetFileReader.getLogicalTypeAnnotation(schemaElement.converted_type, schemaElement.logicalType, schemaElement);
                LogicalTypeAnnotation logicalTypeAnnotation = newOriginalType = schemaElement.isSetLogicalType() && ParquetFileReader.getLogicalTypeAnnotation(schemaElement.logicalType) != null ? ParquetFileReader.getLogicalTypeAnnotation(schemaElement.logicalType) : null;
                if (!originalType.equals(newOriginalType)) {
                    ((Types.Builder)childBuilder).as(originalType);
                }
            }
            if (schemaElement.isSetField_id()) {
                ((Types.Builder)childBuilder).id(schemaElement.field_id);
            }
            ((Types.Builder)childBuilder).named(schemaElement.name);
            ++columnCount;
        }
    }

    private static LogicalTypeAnnotation.TimeUnit convertTimeUnit(TimeUnit unit) throws ParquetFileReaderException {
        switch ((TimeUnit._Fields)unit.getSetField()) {
            case MICROS: {
                return LogicalTypeAnnotation.TimeUnit.MICROS;
            }
            case MILLIS: {
                return LogicalTypeAnnotation.TimeUnit.MILLIS;
            }
            case NANOS: {
                return LogicalTypeAnnotation.TimeUnit.NANOS;
            }
        }
        throw new ParquetFileReaderException("Unknown time unit " + unit);
    }

    static LogicalTypeAnnotation getLogicalTypeAnnotation(LogicalType type) throws ParquetFileReaderException {
        switch ((LogicalType._Fields)type.getSetField()) {
            case MAP: {
                return LogicalTypeAnnotation.mapType();
            }
            case BSON: {
                return LogicalTypeAnnotation.bsonType();
            }
            case DATE: {
                return LogicalTypeAnnotation.dateType();
            }
            case ENUM: {
                return LogicalTypeAnnotation.enumType();
            }
            case JSON: {
                return LogicalTypeAnnotation.jsonType();
            }
            case LIST: {
                return LogicalTypeAnnotation.listType();
            }
            case TIME: {
                TimeType time = type.getTIME();
                return LogicalTypeAnnotation.timeType((boolean)time.isAdjustedToUTC, (LogicalTypeAnnotation.TimeUnit)ParquetFileReader.convertTimeUnit(time.unit));
            }
            case STRING: {
                return LogicalTypeAnnotation.stringType();
            }
            case DECIMAL: {
                DecimalType decimal = type.getDECIMAL();
                return LogicalTypeAnnotation.decimalType((int)decimal.scale, (int)decimal.precision);
            }
            case INTEGER: {
                IntType integer = type.getINTEGER();
                return LogicalTypeAnnotation.intType((int)integer.bitWidth, (boolean)integer.isSigned);
            }
            case UNKNOWN: {
                return null;
            }
            case TIMESTAMP: {
                TimestampType timestamp = type.getTIMESTAMP();
                return LogicalTypeAnnotation.timestampType((boolean)timestamp.isAdjustedToUTC, (LogicalTypeAnnotation.TimeUnit)ParquetFileReader.convertTimeUnit(timestamp.unit));
            }
        }
        throw new ParquetFileReaderException("Unknown logical type " + type);
    }

    private static Type.Repetition fromParquetRepetition(FieldRepetitionType repetition) {
        return Type.Repetition.valueOf((String)repetition.name());
    }

    private static PrimitiveType.PrimitiveTypeName getPrimitive(Type type) throws ParquetFileReaderException {
        switch (type) {
            case BYTE_ARRAY: {
                return PrimitiveType.PrimitiveTypeName.BINARY;
            }
            case INT64: {
                return PrimitiveType.PrimitiveTypeName.INT64;
            }
            case INT32: {
                return PrimitiveType.PrimitiveTypeName.INT32;
            }
            case BOOLEAN: {
                return PrimitiveType.PrimitiveTypeName.BOOLEAN;
            }
            case FLOAT: {
                return PrimitiveType.PrimitiveTypeName.FLOAT;
            }
            case DOUBLE: {
                return PrimitiveType.PrimitiveTypeName.DOUBLE;
            }
            case INT96: {
                return PrimitiveType.PrimitiveTypeName.INT96;
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY;
            }
        }
        throw new ParquetFileReaderException("Unknown type " + type);
    }

    private static org.apache.parquet.schema.ColumnOrder fromParquetColumnOrder(ColumnOrder columnOrder) {
        if (columnOrder.isSetTYPE_ORDER()) {
            return org.apache.parquet.schema.ColumnOrder.typeDefined();
        }
        return org.apache.parquet.schema.ColumnOrder.undefined();
    }

    private static LogicalTypeAnnotation getLogicalTypeAnnotation(ConvertedType convertedType, LogicalType logicalType, SchemaElement schemaElement) throws ParquetFileReaderException {
        switch (convertedType) {
            case UTF8: {
                return LogicalTypeAnnotation.stringType();
            }
            case MAP: {
                return LogicalTypeAnnotation.mapType();
            }
            case MAP_KEY_VALUE: {
                return LogicalTypeAnnotation.MapKeyValueTypeAnnotation.getInstance();
            }
            case LIST: {
                return LogicalTypeAnnotation.listType();
            }
            case ENUM: {
                return LogicalTypeAnnotation.enumType();
            }
            case DECIMAL: {
                int scale = schemaElement == null ? 0 : schemaElement.scale;
                int precision = schemaElement == null ? 0 : schemaElement.precision;
                return LogicalTypeAnnotation.decimalType((int)scale, (int)precision);
            }
            case DATE: {
                return LogicalTypeAnnotation.dateType();
            }
            case TIME_MILLIS: {
                return LogicalTypeAnnotation.timeType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS);
            }
            case TIME_MICROS: {
                return LogicalTypeAnnotation.timeType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS);
            }
            case TIMESTAMP_MILLIS: {
                return LogicalTypeAnnotation.timestampType((boolean)ParquetFileReader.isAdjustedToUTC(logicalType), (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS);
            }
            case TIMESTAMP_MICROS: {
                return LogicalTypeAnnotation.timestampType((boolean)ParquetFileReader.isAdjustedToUTC(logicalType), (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS);
            }
            case INTERVAL: {
                return LogicalTypeAnnotation.IntervalLogicalTypeAnnotation.getInstance();
            }
            case INT_8: {
                return LogicalTypeAnnotation.intType((int)8, (boolean)true);
            }
            case INT_16: {
                return LogicalTypeAnnotation.intType((int)16, (boolean)true);
            }
            case INT_32: {
                return LogicalTypeAnnotation.intType((int)32, (boolean)true);
            }
            case INT_64: {
                return LogicalTypeAnnotation.intType((int)64, (boolean)true);
            }
            case UINT_8: {
                return LogicalTypeAnnotation.intType((int)8, (boolean)false);
            }
            case UINT_16: {
                return LogicalTypeAnnotation.intType((int)16, (boolean)false);
            }
            case UINT_32: {
                return LogicalTypeAnnotation.intType((int)32, (boolean)false);
            }
            case UINT_64: {
                return LogicalTypeAnnotation.intType((int)64, (boolean)false);
            }
            case JSON: {
                return LogicalTypeAnnotation.jsonType();
            }
            case BSON: {
                return LogicalTypeAnnotation.bsonType();
            }
        }
        throw new ParquetFileReaderException("Can't convert converted type to logical type, unknown converted type " + convertedType);
    }

    private static boolean isAdjustedToUTC(LogicalType logicalType) {
        if (logicalType.getSetField() == LogicalType._Fields.TIMESTAMP) {
            return logicalType.getTIMESTAMP().isAdjustedToUTC;
        }
        return false;
    }

    public MessageType getSchema() {
        return this.type;
    }

    public int rowGroupCount() {
        return this.fileMetaData.getRow_groups().size();
    }
}

