/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base;

import io.deephaven.parquet.base.ParquetMetadataFileWriter;
import io.deephaven.parquet.base.ParquetUtils;
import io.deephaven.parquet.base.PositionedBufferedOutputStream;
import io.deephaven.parquet.base.RowGroupWriter;
import io.deephaven.parquet.base.RowGroupWriterImpl;
import io.deephaven.parquet.compress.CompressorAdapter;
import io.deephaven.parquet.compress.DeephavenCompressorAdapterFactory;
import io.deephaven.util.channel.SeekableChannelsProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.format.OffsetIndex;
import org.apache.parquet.format.Util;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.internal.hadoop.metadata.IndexReference;
import org.apache.parquet.schema.MessageType;
import org.jetbrains.annotations.NotNull;

public final class ParquetFileWriter {
    private static final ParquetMetadataConverter metadataConverter = new ParquetMetadataConverter();
    private static final int VERSION = 1;
    private final PositionedBufferedOutputStream bufferedOutput;
    private final MessageType type;
    private final int targetPageSize;
    private final ByteBufferAllocator allocator;
    private final CompressorAdapter compressorAdapter;
    private final Map<String, String> extraMetaData;
    private final List<BlockMetaData> blocks = new ArrayList<BlockMetaData>();
    private final List<List<org.apache.parquet.internal.column.columnindex.OffsetIndex>> offsetIndexes = new ArrayList<List<org.apache.parquet.internal.column.columnindex.OffsetIndex>>();
    private final String destFilePathForMetadata;
    private final ParquetMetadataFileWriter metadataFileWriter;

    public ParquetFileWriter(String destFilePath, String destFilePathForMetadata, SeekableChannelsProvider channelsProvider, int targetPageSize, ByteBufferAllocator allocator, MessageType type, String codecName, Map<String, String> extraMetaData, @NotNull ParquetMetadataFileWriter metadataFileWriter) throws IOException {
        this.targetPageSize = targetPageSize;
        this.allocator = allocator;
        this.extraMetaData = new HashMap<String, String>(extraMetaData);
        this.bufferedOutput = new PositionedBufferedOutputStream(channelsProvider.getWriteChannel(destFilePath, false), 262144);
        this.bufferedOutput.write(ParquetUtils.MAGIC);
        this.type = type;
        this.compressorAdapter = DeephavenCompressorAdapterFactory.getInstance().getByName(codecName);
        this.destFilePathForMetadata = destFilePathForMetadata;
        this.metadataFileWriter = metadataFileWriter;
    }

    public RowGroupWriter addRowGroup(long size) {
        RowGroupWriterImpl rowGroupWriter = new RowGroupWriterImpl(this.bufferedOutput, this.type, this.targetPageSize, this.allocator, this.compressorAdapter);
        rowGroupWriter.getBlock().setRowCount(size);
        this.blocks.add(rowGroupWriter.getBlock());
        this.offsetIndexes.add(rowGroupWriter.offsetIndexes());
        return rowGroupWriter;
    }

    public void close() throws IOException {
        this.serializeOffsetIndexes();
        ParquetMetadata footer = new ParquetMetadata(new FileMetaData(this.type, this.extraMetaData, "parquet-mr version 1.14.0 (build fe9179414906cc19b550d13d2819b4e16fddf8a1)"), this.blocks);
        ParquetFileWriter.serializeFooter(footer, this.bufferedOutput);
        this.metadataFileWriter.addParquetFileMetadata(this.destFilePathForMetadata, footer);
        this.bufferedOutput.close();
        this.compressorAdapter.close();
    }

    public static void serializeFooter(ParquetMetadata footer, PositionedBufferedOutputStream bufferedOutput) throws IOException {
        long footerIndex = bufferedOutput.position();
        org.apache.parquet.format.FileMetaData parquetMetadata = metadataConverter.toParquetMetadata(1, footer);
        Util.writeFileMetaData((org.apache.parquet.format.FileMetaData)parquetMetadata, (OutputStream)bufferedOutput);
        BytesUtils.writeIntLittleEndian((OutputStream)bufferedOutput, (int)((int)(bufferedOutput.position() - footerIndex)));
        bufferedOutput.write(ParquetUtils.MAGIC);
    }

    private void serializeOffsetIndexes() throws IOException {
        int bSize = this.blocks.size();
        for (int bIndex = 0; bIndex < bSize; ++bIndex) {
            List columns = this.blocks.get(bIndex).getColumns();
            List<org.apache.parquet.internal.column.columnindex.OffsetIndex> blockOffsetIndexes = this.offsetIndexes.get(bIndex);
            int cSize = columns.size();
            for (int cIndex = 0; cIndex < cSize; ++cIndex) {
                org.apache.parquet.internal.column.columnindex.OffsetIndex offsetIndex = blockOffsetIndexes.get(cIndex);
                if (offsetIndex == null) continue;
                ColumnChunkMetaData column = (ColumnChunkMetaData)columns.get(cIndex);
                long offset = this.bufferedOutput.position();
                Util.writeOffsetIndex((OffsetIndex)ParquetMetadataConverter.toParquetOffsetIndex((org.apache.parquet.internal.column.columnindex.OffsetIndex)offsetIndex), (OutputStream)this.bufferedOutput);
                column.setOffsetIndexReference(new IndexReference(offset, (int)(this.bufferedOutput.position() - offset)));
            }
        }
    }
}

