/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base;

import io.deephaven.time.DateTimeUtils;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.jetbrains.annotations.Nullable;

public class ParquetTimeUtils {
    public static long epochNanosUTC(@Nullable LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return Long.MIN_VALUE;
        }
        return DateTimeUtils.secondsToNanos((long)localDateTime.toEpochSecond(ZoneOffset.UTC)) + (long)localDateTime.toLocalTime().getNano();
    }

    @Nullable
    public static LocalDateTime epochNanosToLocalDateTimeUTC(long nanos) {
        return nanos == Long.MIN_VALUE ? null : LocalDateTime.ofEpochSecond(nanos / 1000000000L, (int)(nanos % 1000000000L), ZoneOffset.UTC);
    }

    @Nullable
    public static LocalDateTime epochMicrosToLocalDateTimeUTC(long micros) {
        return micros == Long.MIN_VALUE ? null : LocalDateTime.ofEpochSecond(micros / 1000000L, (int)(micros % 1000000L * 1000L), ZoneOffset.UTC);
    }

    @Nullable
    public static LocalDateTime epochMillisToLocalDateTimeUTC(long millis) {
        return millis == Long.MIN_VALUE ? null : LocalDateTime.ofEpochSecond(millis / 1000L, (int)(millis % 1000L * 1000000L), ZoneOffset.UTC);
    }
}

