/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public final class ParquetUtils {
    public static final String METADATA_FILE_NAME = "_metadata";
    public static final String COMMON_METADATA_FILE_NAME = "_common_metadata";
    public static final String PARQUET_FILE_EXTENSION = ".parquet";
    public static final String METADATA_FILE_URI_SUFFIX = "/_metadata";
    public static final String COMMON_METADATA_FILE_URI_SUFFIX = "/_common_metadata";
    public static final String METADATA_FILE_SUFFIX = File.separatorChar + "_metadata";
    public static final String COMMON_METADATA_FILE_SUFFIX = File.separatorChar + "_common_metadata";
    private static final String MAGIC_STR = "PAR1";
    public static final byte[] MAGIC = "PAR1".getBytes(StandardCharsets.US_ASCII);
    public static final int PARQUET_OUTPUT_BUFFER_SIZE = 262144;
    public static final String METADATA_KEY = "deephaven";

    public static String getPerFileMetadataKey(String filePath) {
        return "deephaven_per_file_" + filePath.replace(File.separatorChar, '_');
    }

    public static boolean isParquetFile(@NotNull String source) {
        boolean ret;
        boolean bl = ret = source.endsWith(PARQUET_FILE_EXTENSION) || source.endsWith(METADATA_FILE_URI_SUFFIX) || source.endsWith(COMMON_METADATA_FILE_URI_SUFFIX);
        if (File.separatorChar != '/') {
            ret = ret || source.endsWith(METADATA_FILE_SUFFIX) || source.endsWith(COMMON_METADATA_FILE_SUFFIX);
        }
        return ret;
    }

    public static boolean isVisibleParquetFile(@NotNull Path rootDir, @NotNull Path filePath) {
        String fileName = filePath.getFileName().toString();
        if (!fileName.endsWith(PARQUET_FILE_EXTENSION) || fileName.charAt(0) == '.') {
            return false;
        }
        for (Path parent = filePath.getParent(); parent != null && !parent.equals(rootDir); parent = parent.getParent()) {
            String parentName = parent.getFileName().toString();
            if (parentName.isEmpty() || parentName.charAt(0) != '.') continue;
            return false;
        }
        return true;
    }
}

