/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base;

import io.deephaven.parquet.base.AbstractBulkValuesWriter;
import io.deephaven.parquet.base.BulkWriter;
import io.deephaven.parquet.base.Helpers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridEncoder;
import org.apache.parquet.io.api.Binary;
import org.jetbrains.annotations.NotNull;

final class PlainBinaryChunkedWriter
extends AbstractBulkValuesWriter<Binary[]> {
    private static final int MAXIMUM_TOTAL_CAPACITY = 0x7FFFFFF7;
    private final ByteBufferAllocator allocator;
    private ByteBuffer innerBuffer;
    private IntBuffer nullOffsets;

    PlainBinaryChunkedWriter(int pageSize, @NotNull ByteBufferAllocator allocator) {
        this.innerBuffer = allocator.allocate(pageSize);
        this.innerBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.allocator = allocator;
        this.innerBuffer.mark();
        this.nullOffsets = IntBuffer.allocate(4);
    }

    public final void writeBytes(Binary v) {
        this.ensureCapacityFor(v);
        this.innerBuffer.putInt(v.length());
        this.innerBuffer.put(v.toByteBuffer());
    }

    public long getBufferedSize() {
        return this.innerBuffer.remaining();
    }

    public BytesInput getBytes() {
        return BytesInput.from((ByteBuffer[])new ByteBuffer[]{this.innerBuffer});
    }

    @Override
    public void reset() {
        this.innerBuffer.reset();
        this.innerBuffer.limit(this.innerBuffer.capacity());
    }

    @Override
    public ByteBuffer getByteBufferView() {
        this.innerBuffer.limit(this.innerBuffer.position());
        this.innerBuffer.reset();
        return this.innerBuffer;
    }

    public void close() {
        this.allocator.release(this.innerBuffer);
    }

    public long getAllocatedSize() {
        return this.innerBuffer.capacity();
    }

    public Encoding getEncoding() {
        return Encoding.PLAIN;
    }

    public String memUsageString(String prefix) {
        return String.format("%s %s, %,d bytes", prefix, this.getClass().getSimpleName(), this.innerBuffer.capacity());
    }

    @Override
    public void writeBulk(@NotNull Binary[] bulkValues, int rowCount, @NotNull Statistics<?> statistics) {
        for (int i = 0; i < rowCount; ++i) {
            Binary v = bulkValues[i];
            this.writeBytes(v);
            statistics.updateStats(v);
        }
    }

    @Override
    @NotNull
    public BulkWriter.WriteResult writeBulkFilterNulls(@NotNull Binary[] bulkValues, @NotNull RunLengthBitPackingHybridEncoder dlEncoder, int rowCount, @NotNull Statistics<?> statistics) throws IOException {
        for (int i = 0; i < rowCount; ++i) {
            if (bulkValues[i] != null) {
                Binary v = bulkValues[i];
                this.writeBytes(v);
                statistics.updateStats(v);
                dlEncoder.writeInt(1);
                continue;
            }
            statistics.incrementNumNulls();
            dlEncoder.writeInt(0);
        }
        return new BulkWriter.WriteResult(rowCount);
    }

    @Override
    @NotNull
    public BulkWriter.WriteResult writeBulkVectorFilterNulls(@NotNull Binary[] bulkValues, int nonNullLeafCount, @NotNull Statistics<?> statistics) {
        this.nullOffsets.clear();
        for (int i = 0; i < nonNullLeafCount; ++i) {
            if (bulkValues[i] != null) {
                Binary v = bulkValues[i];
                this.writeBytes(v);
                statistics.updateStats(v);
                continue;
            }
            this.nullOffsets = Helpers.ensureCapacity(this.nullOffsets);
            this.nullOffsets.put(i);
            statistics.incrementNumNulls();
        }
        return new BulkWriter.WriteResult(nonNullLeafCount, this.nullOffsets);
    }

    private void ensureCapacityFor(@NotNull Binary v) {
        if (v.length() == 0 || this.innerBuffer.remaining() >= v.length() + 4) {
            return;
        }
        int currentCapacity = this.innerBuffer.capacity();
        int currentPosition = this.innerBuffer.position();
        long requiredCapacity = (long)currentPosition + (long)v.length() + 4L;
        if (requiredCapacity > 0x7FFFFFF7L) {
            throw new IllegalStateException("Unable to write " + requiredCapacity + " values. (Maximum capacity: 2147483639.)");
        }
        int newCapacity = currentCapacity;
        while ((long)newCapacity < requiredCapacity) {
            newCapacity = (int)Math.min(0x7FFFFFF7L, (long)newCapacity * 2L);
        }
        ByteBuffer newBuf = this.allocator.allocate(newCapacity);
        newBuf.order(ByteOrder.LITTLE_ENDIAN);
        newBuf.mark();
        this.innerBuffer.limit(this.innerBuffer.position());
        this.innerBuffer.reset();
        newBuf.put(this.innerBuffer);
        this.allocator.release(this.innerBuffer);
        this.innerBuffer = newBuf;
    }
}

