/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base;

import io.deephaven.parquet.base.AbstractBulkValuesWriter;
import io.deephaven.parquet.base.BulkWriter;
import io.deephaven.parquet.base.Helpers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.column.values.plain.BooleanPlainValuesWriter;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridEncoder;
import org.jetbrains.annotations.NotNull;

final class PlainBooleanChunkedWriter
extends AbstractBulkValuesWriter<ByteBuffer> {
    private final BooleanPlainValuesWriter writer = new BooleanPlainValuesWriter();
    private IntBuffer nullOffsets = IntBuffer.allocate(4);

    PlainBooleanChunkedWriter() {
    }

    public final void writeBoolean(boolean v) {
        this.writer.writeBoolean(v);
    }

    public long getBufferedSize() {
        return this.writer.getBufferedSize();
    }

    public BytesInput getBytes() {
        return this.writer.getBytes();
    }

    @Override
    public void reset() {
        this.writer.reset();
    }

    @Override
    public ByteBuffer getByteBufferView() throws IOException {
        return this.writer.getBytes().toByteBuffer();
    }

    public void close() {
        this.writer.close();
    }

    public long getAllocatedSize() {
        return this.writer.getAllocatedSize();
    }

    public Encoding getEncoding() {
        return Encoding.PLAIN;
    }

    public String memUsageString(String prefix) {
        return String.format("%s %s, %,d bytes", prefix, this.getClass().getSimpleName(), this.writer.getAllocatedSize());
    }

    @Override
    public void writeBulk(@NotNull ByteBuffer bulkValues, int rowCount, @NotNull Statistics<?> statistics) {
        while (bulkValues.hasRemaining()) {
            boolean v = bulkValues.get() == 1;
            this.writeBoolean(v);
            statistics.updateStats(v);
        }
    }

    @Override
    @NotNull
    public BulkWriter.WriteResult writeBulkFilterNulls(@NotNull ByteBuffer bulkValues, @NotNull RunLengthBitPackingHybridEncoder dlEncoder, int rowCount, @NotNull Statistics<?> statistics) throws IOException {
        while (bulkValues.hasRemaining()) {
            byte next = bulkValues.get();
            if (next != -128) {
                boolean v = next == 1;
                this.writeBoolean(v);
                statistics.updateStats(v);
                dlEncoder.writeInt(1);
                continue;
            }
            statistics.incrementNumNulls();
            dlEncoder.writeInt(0);
        }
        return new BulkWriter.WriteResult(rowCount);
    }

    @Override
    @NotNull
    public BulkWriter.WriteResult writeBulkVectorFilterNulls(@NotNull ByteBuffer bulkValues, int rowCount, @NotNull Statistics<?> statistics) {
        this.nullOffsets.clear();
        int i = 0;
        while (bulkValues.hasRemaining()) {
            byte next = bulkValues.get();
            if (next != -128) {
                boolean v = next == 1;
                this.writeBoolean(v);
                statistics.updateStats(v);
            } else {
                this.nullOffsets = Helpers.ensureCapacity(this.nullOffsets);
                this.nullOffsets.put(i);
                statistics.incrementNumNulls();
            }
            ++i;
        }
        return new BulkWriter.WriteResult(rowCount, this.nullOffsets);
    }
}

