/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base;

import io.deephaven.parquet.base.AbstractBulkValuesWriter;
import io.deephaven.parquet.base.BulkWriter;
import io.deephaven.parquet.base.Helpers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridEncoder;
import org.jetbrains.annotations.NotNull;

final class PlainDoubleChunkedWriter
extends AbstractBulkValuesWriter<DoubleBuffer> {
    private static final int MAXIMUM_TOTAL_CAPACITY = 0xFFFFFFF;
    private final ByteBufferAllocator allocator;
    private DoubleBuffer targetBuffer;
    private ByteBuffer innerBuffer;
    private IntBuffer nullOffsets;

    PlainDoubleChunkedWriter(int targetPageSize, @NotNull ByteBufferAllocator allocator) {
        this.allocator = allocator;
        this.realloc(targetPageSize);
        this.nullOffsets = IntBuffer.allocate(4);
    }

    public final void writeDouble(double v) {
        this.targetBuffer.put(v);
    }

    public long getBufferedSize() {
        return (long)this.targetBuffer.remaining() * 8L;
    }

    public BytesInput getBytes() {
        this.innerBuffer.limit(this.innerBuffer.position() + this.targetBuffer.position() * 8);
        return BytesInput.from((ByteBuffer[])new ByteBuffer[]{this.innerBuffer});
    }

    @Override
    public void reset() {
        this.innerBuffer.reset();
        this.innerBuffer.limit(this.innerBuffer.capacity());
        this.targetBuffer.reset();
    }

    @Override
    public ByteBuffer getByteBufferView() {
        this.innerBuffer.limit(this.innerBuffer.position() + this.targetBuffer.position() * 8);
        return this.innerBuffer;
    }

    public void close() {
        this.allocator.release(this.innerBuffer);
    }

    public long getAllocatedSize() {
        return this.innerBuffer.capacity();
    }

    public Encoding getEncoding() {
        return Encoding.PLAIN;
    }

    public String memUsageString(String prefix) {
        return String.format("%s %s, %,d bytes", prefix, this.getClass().getSimpleName(), this.innerBuffer.capacity());
    }

    @Override
    public void writeBulk(@NotNull DoubleBuffer bulkValues, int rowCount, @NotNull Statistics<?> statistics) {
        this.ensureCapacityFor(bulkValues);
        for (int i = 0; i < rowCount; ++i) {
            statistics.updateStats(bulkValues.get(i));
        }
        this.targetBuffer.put(bulkValues);
    }

    @Override
    @NotNull
    public BulkWriter.WriteResult writeBulkFilterNulls(@NotNull DoubleBuffer bulkValues, @NotNull RunLengthBitPackingHybridEncoder dlEncoder, int rowCount, @NotNull Statistics<?> statistics) throws IOException {
        this.ensureCapacityFor(bulkValues);
        while (bulkValues.hasRemaining()) {
            double v = bulkValues.get();
            if (v != -1.7976931348623157E308) {
                this.writeDouble(v);
                statistics.updateStats(v);
                dlEncoder.writeInt(1);
                continue;
            }
            statistics.incrementNumNulls();
            dlEncoder.writeInt(0);
        }
        return new BulkWriter.WriteResult(rowCount);
    }

    @Override
    @NotNull
    public BulkWriter.WriteResult writeBulkVectorFilterNulls(@NotNull DoubleBuffer bulkValues, int rowCount, @NotNull Statistics<?> statistics) {
        this.ensureCapacityFor(bulkValues);
        int i = 0;
        this.nullOffsets.clear();
        while (bulkValues.hasRemaining()) {
            double v = bulkValues.get();
            if (v != -1.7976931348623157E308) {
                this.writeDouble(v);
                statistics.updateStats(v);
            } else {
                this.nullOffsets = Helpers.ensureCapacity(this.nullOffsets);
                this.nullOffsets.put(i);
                statistics.incrementNumNulls();
            }
            ++i;
        }
        return new BulkWriter.WriteResult(rowCount, this.nullOffsets);
    }

    private void ensureCapacityFor(@NotNull DoubleBuffer valuesToAdd) {
        if (!valuesToAdd.hasRemaining()) {
            return;
        }
        int currentCapacity = this.targetBuffer.capacity();
        int currentPosition = this.targetBuffer.position();
        long requiredCapacity = (long)currentPosition + (long)valuesToAdd.remaining();
        if (requiredCapacity < (long)currentCapacity) {
            return;
        }
        if (requiredCapacity > 0xFFFFFFFL) {
            throw new IllegalStateException("Unable to write " + requiredCapacity + " values. (Maximum capacity: 268435455.)");
        }
        int newCapacity = currentCapacity;
        while ((long)newCapacity < requiredCapacity) {
            newCapacity = Math.min(0xFFFFFFF, newCapacity * 2);
        }
        this.realloc(newCapacity * 8);
    }

    private void realloc(int newCapacity) {
        ByteBuffer newBuf = this.allocator.allocate(newCapacity);
        newBuf.order(ByteOrder.LITTLE_ENDIAN);
        DoubleBuffer newDoubleBuf = newBuf.asDoubleBuffer();
        newBuf.mark();
        newDoubleBuf.mark();
        if (this.innerBuffer != null) {
            this.targetBuffer.limit(this.targetBuffer.position());
            this.targetBuffer.reset();
            newDoubleBuf.put(this.targetBuffer);
            this.allocator.release(this.innerBuffer);
        }
        this.innerBuffer = newBuf;
        this.targetBuffer = newDoubleBuf;
    }
}

