/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base;

import io.deephaven.parquet.base.AbstractBulkValuesWriter;
import io.deephaven.parquet.base.BulkWriter;
import io.deephaven.parquet.base.Helpers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.column.values.plain.PlainValuesWriter;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridEncoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RleIntChunkedWriter
extends AbstractBulkValuesWriter<IntBuffer> {
    private static final Logger LOG = LoggerFactory.getLogger(PlainValuesWriter.class);
    private final RunLengthBitPackingHybridEncoder encoder;
    private final byte bitWidth;
    private IntBuffer nullOffsets;

    RleIntChunkedWriter(int pageSize, ByteBufferAllocator allocator, byte bitWidth) {
        this.encoder = new RunLengthBitPackingHybridEncoder((int)bitWidth, pageSize, pageSize, allocator);
        this.bitWidth = bitWidth;
        this.nullOffsets = IntBuffer.allocate(4);
    }

    public final void writeInteger(int v) {
        try {
            this.encoder.writeInt(v);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long getBufferedSize() {
        return this.encoder.getBufferedSize();
    }

    public BytesInput getBytes() {
        try {
            byte[] bytesHeader = new byte[]{this.bitWidth};
            BytesInput rleEncodedBytes = this.encoder.toBytes();
            LOG.debug("rle encoded bytes {}", (Object)rleEncodedBytes.size());
            return BytesInput.concat((BytesInput[])new BytesInput[]{BytesInput.from((byte[])bytesHeader), rleEncodedBytes});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void reset() {
        this.encoder.reset();
    }

    @Override
    public ByteBuffer getByteBufferView() {
        try {
            return this.getBytes().toByteBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        this.encoder.close();
    }

    public long getAllocatedSize() {
        return this.encoder.getAllocatedSize();
    }

    public Encoding getEncoding() {
        return Encoding.PLAIN;
    }

    public String memUsageString(String prefix) {
        return String.format("%s %s, %,d bytes", prefix, this.getClass().getSimpleName(), this.encoder.getAllocatedSize());
    }

    @Override
    public void writeBulk(@NotNull IntBuffer bulkValues, int rowCount, @Nullable Statistics<?> statistics) {
        for (int i = 0; i < rowCount; ++i) {
            int v = bulkValues.get();
            this.writeInteger(v);
            statistics.updateStats(v);
        }
    }

    @Override
    @NotNull
    public BulkWriter.WriteResult writeBulkFilterNulls(@NotNull IntBuffer bulkValues, @NotNull RunLengthBitPackingHybridEncoder dlEncoder, int rowCount, @NotNull Statistics<?> statistics) throws IOException {
        while (bulkValues.hasRemaining()) {
            int v = bulkValues.get();
            if (v != Integer.MIN_VALUE) {
                this.writeInteger(v);
                statistics.updateStats(v);
                dlEncoder.writeInt(1);
                continue;
            }
            statistics.incrementNumNulls();
            dlEncoder.writeInt(0);
        }
        return new BulkWriter.WriteResult(rowCount);
    }

    @Override
    @NotNull
    public BulkWriter.WriteResult writeBulkVectorFilterNulls(@NotNull IntBuffer bulkValues, int rowCount, @NotNull Statistics<?> statistics) {
        this.nullOffsets.clear();
        int i = 0;
        while (bulkValues.hasRemaining()) {
            int v = bulkValues.get();
            if (v != Integer.MIN_VALUE) {
                this.writeInteger(v);
                statistics.updateStats(v);
            } else {
                this.nullOffsets = Helpers.ensureCapacity(this.nullOffsets);
                this.nullOffsets.put(i);
                statistics.incrementNumNulls();
            }
            ++i;
        }
        return new BulkWriter.WriteResult(rowCount, this.nullOffsets);
    }
}

