/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base;

import io.deephaven.parquet.base.ColumnChunkReaderImpl;
import io.deephaven.parquet.base.RowGroupReader;
import io.deephaven.util.channel.SeekableChannelsProvider;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.parquet.format.ColumnChunk;
import org.apache.parquet.format.RowGroup;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RowGroupReaderImpl
implements RowGroupReader {
    private final RowGroup rowGroup;
    private final SeekableChannelsProvider channelsProvider;
    private final MessageType type;
    private final Map<String, List<Type>> schemaMap = new HashMap<String, List<Type>>();
    private final Map<String, ColumnChunk> chunkMap = new HashMap<String, ColumnChunk>();
    private final URI rootURI;
    private final String version;

    RowGroupReaderImpl(@NotNull RowGroup rowGroup, @NotNull SeekableChannelsProvider channelsProvider, @NotNull URI rootURI, @NotNull MessageType type, @NotNull MessageType schema, @Nullable String version) {
        this.channelsProvider = channelsProvider;
        this.rowGroup = rowGroup;
        this.rootURI = rootURI;
        this.type = type;
        for (ColumnChunk column : rowGroup.columns) {
            List path_in_schema = column.getMeta_data().path_in_schema;
            String key = path_in_schema.toString();
            this.chunkMap.put(key, column);
            ArrayList<Type> nonRequiredFields = new ArrayList<Type>();
            for (int indexInPath = 0; indexInPath < path_in_schema.size(); ++indexInPath) {
                Type fieldType = schema.getType(path_in_schema.subList(0, indexInPath + 1).toArray(new String[0]));
                if (fieldType.getRepetition() == Type.Repetition.REQUIRED) continue;
                nonRequiredFields.add(fieldType);
            }
            this.schemaMap.put(key, nonRequiredFields);
        }
        this.version = version;
    }

    @Override
    @Nullable
    public ColumnChunkReaderImpl getColumnChunk(@NotNull String columnName, @NotNull List<String> path) {
        String key = path.toString();
        ColumnChunk columnChunk = this.chunkMap.get(key);
        List<Type> fieldTypes = this.schemaMap.get(key);
        if (columnChunk == null) {
            return null;
        }
        return new ColumnChunkReaderImpl(columnName, columnChunk, this.channelsProvider, this.rootURI, this.type, fieldTypes, this.numRows(), this.version);
    }

    @Override
    public long numRows() {
        return this.rowGroup.num_rows;
    }

    @Override
    public RowGroup getRowGroup() {
        return this.rowGroup;
    }
}

