/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base;

import io.deephaven.parquet.base.ColumnWriter;
import io.deephaven.parquet.base.ColumnWriterImpl;
import io.deephaven.parquet.base.PositionedBufferedOutputStream;
import io.deephaven.parquet.base.RowGroupWriter;
import io.deephaven.parquet.compress.CompressorAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;

final class RowGroupWriterImpl
implements RowGroupWriter {
    private final PositionedBufferedOutputStream bufferedOutput;
    private final MessageType type;
    private final int targetPageSize;
    private final ByteBufferAllocator allocator;
    private ColumnWriterImpl activeWriter;
    private final BlockMetaData blockMetaData;
    private final List<OffsetIndex> currentOffsetIndexes = new ArrayList<OffsetIndex>();
    private final CompressorAdapter compressorAdapter;

    RowGroupWriterImpl(PositionedBufferedOutputStream bufferedOutput, MessageType type, int targetPageSize, ByteBufferAllocator allocator, CompressorAdapter compressorAdapter) {
        this(bufferedOutput, type, targetPageSize, allocator, new BlockMetaData(), compressorAdapter);
    }

    private RowGroupWriterImpl(PositionedBufferedOutputStream bufferedOutput, MessageType type, int targetPageSize, ByteBufferAllocator allocator, BlockMetaData blockMetaData, CompressorAdapter compressorAdapter) {
        this.bufferedOutput = bufferedOutput;
        this.type = type;
        this.targetPageSize = targetPageSize;
        this.allocator = allocator;
        this.blockMetaData = blockMetaData;
        this.compressorAdapter = compressorAdapter;
    }

    String[] getPrimitivePath(String columnName) {
        Type rollingType;
        Object[] result = new String[]{columnName};
        while (!(rollingType = this.type.getType((String[])result)).isPrimitive()) {
            GroupType groupType = rollingType.asGroupType();
            if (groupType.getFieldCount() != 1) {
                throw new UnsupportedOperationException("Encountered struct at:" + Arrays.toString(result));
            }
            result = (String[])Arrays.copyOf(result, result.length + 1);
            result[result.length - 1] = groupType.getFieldName(0);
        }
        return result;
    }

    @Override
    public ColumnWriter addColumn(String columnName) {
        if (this.activeWriter != null) {
            throw new IllegalStateException("There is already an active column writer for " + this.activeWriter.getColumn().getPath()[0] + " need to close that before opening a writer for " + columnName);
        }
        this.activeWriter = new ColumnWriterImpl(this, this.bufferedOutput, this.type.getColumnDescription(this.getPrimitivePath(columnName)), this.compressorAdapter, this.targetPageSize, this.allocator);
        return this.activeWriter;
    }

    @Override
    public BlockMetaData getBlock() {
        return this.blockMetaData;
    }

    void releaseWriter(ColumnWriterImpl columnWriter, ColumnChunkMetaData columnChunkMetaData) {
        if (this.activeWriter != columnWriter) {
            throw new RuntimeException(columnWriter.getColumn().getPath()[0] + " is not the active column");
        }
        this.currentOffsetIndexes.add(columnWriter.getOffsetIndex());
        this.blockMetaData.addColumn(columnChunkMetaData);
        this.blockMetaData.setTotalByteSize(columnChunkMetaData.getTotalSize() + this.blockMetaData.getTotalByteSize());
        this.activeWriter = null;
    }

    List<OffsetIndex> offsetIndexes() {
        return this.currentOffsetIndexes;
    }
}

