/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base;

import io.deephaven.parquet.base.Helpers;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.parquet.Preconditions;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.values.bitpacking.BytePacker;
import org.apache.parquet.column.values.bitpacking.Packer;
import org.apache.parquet.io.ParquetDecodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RunLengthBitPackingHybridBufferDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(RunLengthBitPackingHybridBufferDecoder.class);
    private int rangeCount;
    private final int maxLevel;
    private int rleCandidateValue;
    private final int bitWidth;
    private final BytePacker packer;
    private final ByteBuffer in;
    private MODE mode;
    private int currentCount;
    private int currentValue;
    private int[] currentBuffer;

    public RunLengthBitPackingHybridBufferDecoder(int maxLevel, ByteBuffer in) {
        this.bitWidth = BytesUtils.getWidthFromMaxInt((int)maxLevel);
        this.maxLevel = maxLevel;
        LOG.debug("decoding bitWidth {}", (Object)this.bitWidth);
        Preconditions.checkArgument((this.bitWidth >= 0 && this.bitWidth <= 32 ? 1 : 0) != 0, (String)"bitWidth must be >= 0 and <= 32");
        this.packer = Packer.LITTLE_ENDIAN.newBytePacker(this.bitWidth);
        this.in = in;
    }

    public int readInt() throws IOException {
        int result;
        if (this.currentCount == 0) {
            this.readNext();
        }
        --this.currentCount;
        switch (this.mode) {
            case RLE: {
                result = this.currentValue;
                break;
            }
            case PACKED: {
                result = this.currentBuffer[this.currentBuffer.length - 1 - this.currentCount];
                break;
            }
            default: {
                throw new ParquetDecodingException("not a valid mode " + this.mode);
            }
        }
        return result;
    }

    public void readNextRange() throws IOException {
        if (this.currentCount == 0) {
            this.readNext();
        }
        this.rangeCount = 1;
        --this.currentCount;
        switch (this.mode) {
            case RLE: {
                this.currentValue = this.rleCandidateValue;
                break;
            }
            case PACKED: {
                this.currentValue = this.currentBuffer[this.currentBuffer.length - 1 - this.currentCount];
                break;
            }
            default: {
                throw new ParquetDecodingException("not a valid mode " + this.mode);
            }
        }
        if (this.currentCount == 0) {
            if (!this.hasNext()) {
                return;
            }
            this.readNext();
        }
        while (true) {
            switch (this.mode) {
                case RLE: {
                    if (this.rleCandidateValue != this.currentValue) {
                        return;
                    }
                    this.rangeCount += this.currentCount;
                    this.currentCount = 0;
                    break;
                }
                case PACKED: {
                    while (this.currentCount > 0 && this.currentBuffer[this.currentBuffer.length - this.currentCount] == this.currentValue) {
                        --this.currentCount;
                        ++this.rangeCount;
                    }
                    if (this.currentCount <= 0) break;
                    return;
                }
                default: {
                    throw new ParquetDecodingException("not a valid mode " + this.mode);
                }
            }
            if (!this.hasNext()) {
                return;
            }
            this.readNext();
        }
    }

    public boolean hasNext() {
        return this.in.hasRemaining() || this.currentCount != 0;
    }

    public int currentRangeCount() {
        return this.rangeCount;
    }

    public boolean isNullRange() {
        return this.currentValue < this.maxLevel;
    }

    public int currentValue() {
        return this.currentValue;
    }

    private void readNext() throws IOException {
        int header = Helpers.readUnsignedVarInt(this.in);
        this.mode = (header & 1) == 0 ? MODE.RLE : MODE.PACKED;
        switch (this.mode) {
            case RLE: {
                this.currentCount = header >>> 1;
                LOG.debug("reading {} values RLE", (Object)this.currentCount);
                this.rleCandidateValue = Helpers.readIntLittleEndianPaddedOnBitWidth(this.in, this.bitWidth);
                break;
            }
            case PACKED: {
                int numGroups = header >>> 1;
                this.currentCount = numGroups * 8;
                LOG.debug("reading {} values BIT PACKED", (Object)this.currentCount);
                this.currentBuffer = new int[this.currentCount];
                int bytesToRead = (int)Math.ceil((double)(this.currentCount * this.bitWidth) / 8.0);
                bytesToRead = Math.min(bytesToRead, this.in.remaining());
                int newPos = this.in.position() + bytesToRead;
                int valueIndex = 0;
                int byteIndex = 0;
                while (valueIndex < this.currentCount) {
                    this.packer.unpack8Values(this.in, byteIndex + this.in.position(), this.currentBuffer, valueIndex);
                    valueIndex += 8;
                    byteIndex += this.bitWidth;
                }
                this.in.position(newPos);
                break;
            }
            default: {
                throw new ParquetDecodingException("not a valid mode " + this.mode);
            }
        }
    }

    private static enum MODE {
        RLE,
        PACKED;

    }
}

