/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base.materializers;

import io.deephaven.parquet.base.PageMaterializer;
import io.deephaven.parquet.base.PageMaterializerFactory;
import io.deephaven.parquet.base.materializers.ObjectMaterializerBase;
import java.math.BigDecimal;
import org.apache.parquet.column.values.ValuesReader;

public class BigDecimalFromLongMaterializer
extends ObjectMaterializerBase<BigDecimal>
implements PageMaterializer {
    private final ValuesReader dataReader;
    private final int scale;

    private BigDecimalFromLongMaterializer(ValuesReader dataReader, int numValues, int scale) {
        this(dataReader, null, numValues, scale);
    }

    private BigDecimalFromLongMaterializer(ValuesReader dataReader, BigDecimal nullValue, int numValues, int scale) {
        super(nullValue, new BigDecimal[numValues]);
        this.dataReader = dataReader;
        this.scale = scale;
    }

    @Override
    public void fillValues(int startIndex, int endIndex) {
        for (int ii = startIndex; ii < endIndex; ++ii) {
            ((BigDecimal[])this.data)[ii] = BigDecimal.valueOf(this.dataReader.readLong(), this.scale);
        }
    }

    public static final class Factory
    implements PageMaterializerFactory {
        final int scale;

        public Factory(int scale) {
            this.scale = scale;
        }

        @Override
        public PageMaterializer makeMaterializerWithNulls(ValuesReader dataReader, Object nullValue, int numValues) {
            return new BigDecimalFromLongMaterializer(dataReader, (BigDecimal)nullValue, numValues, this.scale);
        }

        @Override
        public PageMaterializer makeMaterializerNonNull(ValuesReader dataReader, int numValues) {
            return new BigDecimalFromLongMaterializer(dataReader, numValues, this.scale);
        }
    }
}

