/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base.materializers;

import io.deephaven.parquet.base.PageMaterializer;
import io.deephaven.parquet.base.PageMaterializerFactory;
import io.deephaven.parquet.base.materializers.ObjectMaterializerBase;
import io.deephaven.util.codec.ObjectCodec;
import java.math.BigInteger;
import org.apache.parquet.column.values.ValuesReader;

public class BigIntegerMaterializer
extends ObjectMaterializerBase<BigInteger>
implements PageMaterializer {
    private final ValuesReader dataReader;
    private final ObjectCodec<BigInteger> codec;

    private BigIntegerMaterializer(ValuesReader dataReader, int numValues, ObjectCodec<BigInteger> codec) {
        this(dataReader, null, numValues, codec);
    }

    private BigIntegerMaterializer(ValuesReader dataReader, BigInteger nullValue, int numValues, ObjectCodec<BigInteger> codec) {
        super(nullValue, new BigInteger[numValues]);
        this.dataReader = dataReader;
        this.codec = codec;
    }

    @Override
    public void fillValues(int startIndex, int endIndex) {
        for (int ii = startIndex; ii < endIndex; ++ii) {
            ((BigInteger[])this.data)[ii] = (BigInteger)this.codec.decode(this.dataReader.readBytes().toByteBuffer());
        }
    }

    public static final class Factory
    implements PageMaterializerFactory {
        final ObjectCodec<BigInteger> codec;

        public Factory(ObjectCodec<BigInteger> codec) {
            this.codec = codec;
        }

        @Override
        public PageMaterializer makeMaterializerWithNulls(ValuesReader dataReader, Object nullValue, int numValues) {
            return new BigIntegerMaterializer(dataReader, (BigInteger)nullValue, numValues, this.codec);
        }

        @Override
        public PageMaterializer makeMaterializerNonNull(ValuesReader dataReader, int numValues) {
            return new BigIntegerMaterializer(dataReader, numValues, this.codec);
        }
    }
}

