/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base.materializers;

import io.deephaven.parquet.base.PageMaterializer;
import io.deephaven.parquet.base.PageMaterializerFactory;
import java.util.Arrays;
import org.apache.parquet.column.values.ValuesReader;

public class CharMaterializer
implements PageMaterializer {
    public static final PageMaterializerFactory FACTORY = new PageMaterializerFactory(){

        @Override
        public PageMaterializer makeMaterializerWithNulls(ValuesReader dataReader, Object nullValue, int numValues) {
            return new CharMaterializer(dataReader, ((Character)nullValue).charValue(), numValues);
        }

        @Override
        public PageMaterializer makeMaterializerNonNull(ValuesReader dataReader, int numValues) {
            return new CharMaterializer(dataReader, numValues);
        }
    };
    private final ValuesReader dataReader;
    private final char nullValue;
    private final char[] data;

    private CharMaterializer(ValuesReader dataReader, int numValues) {
        this(dataReader, '\u0000', numValues);
    }

    private CharMaterializer(ValuesReader dataReader, char nullValue, int numValues) {
        this.dataReader = dataReader;
        this.nullValue = nullValue;
        this.data = new char[numValues];
    }

    @Override
    public void fillNulls(int startIndex, int endIndex) {
        Arrays.fill(this.data, startIndex, endIndex, this.nullValue);
    }

    @Override
    public void fillValues(int startIndex, int endIndex) {
        for (int ii = startIndex; ii < endIndex; ++ii) {
            this.data[ii] = (char)this.dataReader.readInteger();
        }
    }

    @Override
    public Object fillAll() {
        this.fillValues(0, this.data.length);
        return this.data;
    }

    @Override
    public Object data() {
        return this.data;
    }
}

