/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base.materializers;

import io.deephaven.parquet.base.PageMaterializer;
import io.deephaven.parquet.base.PageMaterializerFactory;
import java.util.Arrays;
import org.apache.parquet.column.values.ValuesReader;

public class DoubleMaterializer
implements PageMaterializer {
    public static final PageMaterializerFactory FACTORY = new PageMaterializerFactory(){

        @Override
        public PageMaterializer makeMaterializerWithNulls(ValuesReader dataReader, Object nullValue, int numValues) {
            return new DoubleMaterializer(dataReader, (Double)nullValue, numValues);
        }

        @Override
        public PageMaterializer makeMaterializerNonNull(ValuesReader dataReader, int numValues) {
            return new DoubleMaterializer(dataReader, numValues);
        }
    };
    private final ValuesReader dataReader;
    private final double nullValue;
    private final double[] data;

    private DoubleMaterializer(ValuesReader dataReader, int numValues) {
        this(dataReader, 0.0, numValues);
    }

    private DoubleMaterializer(ValuesReader dataReader, double nullValue, int numValues) {
        this.dataReader = dataReader;
        this.nullValue = nullValue;
        this.data = new double[numValues];
    }

    @Override
    public void fillNulls(int startIndex, int endIndex) {
        Arrays.fill(this.data, startIndex, endIndex, this.nullValue);
    }

    @Override
    public void fillValues(int startIndex, int endIndex) {
        for (int ii = startIndex; ii < endIndex; ++ii) {
            this.data[ii] = this.dataReader.readDouble();
        }
    }

    @Override
    public Object fillAll() {
        this.fillValues(0, this.data.length);
        return this.data;
    }

    @Override
    public Object data() {
        return this.data;
    }
}

