/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base.materializers;

import io.deephaven.configuration.Configuration;
import io.deephaven.parquet.base.PageMaterializer;
import io.deephaven.parquet.base.PageMaterializerFactory;
import io.deephaven.parquet.base.materializers.LongMaterializerBase;
import io.deephaven.time.DateTimeUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Instant;
import java.time.ZoneId;
import org.apache.parquet.column.values.ValuesReader;
import org.jetbrains.annotations.NotNull;

public class InstantNanosFromInt96Materializer
extends LongMaterializerBase
implements PageMaterializer {
    public static final PageMaterializerFactory FACTORY = new PageMaterializerFactory(){

        @Override
        public PageMaterializer makeMaterializerWithNulls(ValuesReader dataReader, Object nullValue, int numValues) {
            return new InstantNanosFromInt96Materializer(dataReader, (Long)nullValue, numValues);
        }

        @Override
        public PageMaterializer makeMaterializerNonNull(ValuesReader dataReader, int numValues) {
            return new InstantNanosFromInt96Materializer(dataReader, numValues);
        }
    };
    private static final long NANOS_PER_DAY = 86400000000000L;
    private static final int JULIAN_OFFSET_TO_UNIX_EPOCH_DAYS = 2440588;
    private static long offset;
    private final ValuesReader dataReader;

    private InstantNanosFromInt96Materializer(ValuesReader dataReader, int numValues) {
        this(dataReader, 0L, numValues);
    }

    private InstantNanosFromInt96Materializer(ValuesReader dataReader, long nullValue, int numValues) {
        super(nullValue, numValues);
        this.dataReader = dataReader;
    }

    private static void setReferenceTimeZone(@NotNull String timeZone) {
        offset = DateTimeUtils.nanosOfDay((Instant)DateTimeUtils.parseInstant((String)("1970-01-01T00:00:00 " + timeZone)), (ZoneId)ZoneId.of("UTC"), (boolean)false);
    }

    @Override
    public void fillValues(int startIndex, int endIndex) {
        for (int ii = startIndex; ii < endIndex; ++ii) {
            this.data[ii] = this.readInstantNanos();
        }
    }

    long readInstantNanos() {
        ByteBuffer resultBuffer = ByteBuffer.wrap(this.dataReader.readBytes().getBytesUnsafe());
        resultBuffer.order(ByteOrder.LITTLE_ENDIAN);
        long nanos = resultBuffer.getLong();
        int julianDate = resultBuffer.getInt();
        return (long)(julianDate - 2440588) * 86400000000000L + nanos + offset;
    }

    static {
        String referenceTimeZone = Configuration.getInstance().getStringWithDefault("deephaven.parquet.referenceTimeZone", "UTC");
        InstantNanosFromInt96Materializer.setReferenceTimeZone(referenceTimeZone);
    }
}

