/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base.materializers;

import io.deephaven.parquet.base.PageMaterializer;
import io.deephaven.parquet.base.PageMaterializerFactory;
import io.deephaven.parquet.base.materializers.LongMaterializerBase;
import io.deephaven.time.DateTimeUtils;
import org.apache.parquet.column.values.ValuesReader;

public class InstantNanosFromMicrosMaterializer
extends LongMaterializerBase
implements PageMaterializer {
    public static final PageMaterializerFactory FACTORY = new PageMaterializerFactory(){

        @Override
        public PageMaterializer makeMaterializerWithNulls(ValuesReader dataReader, Object nullValue, int numValues) {
            return new InstantNanosFromMicrosMaterializer(dataReader, (Long)nullValue, numValues);
        }

        @Override
        public PageMaterializer makeMaterializerNonNull(ValuesReader dataReader, int numValues) {
            return new InstantNanosFromMicrosMaterializer(dataReader, numValues);
        }
    };
    private final ValuesReader dataReader;

    private InstantNanosFromMicrosMaterializer(ValuesReader dataReader, int numValues) {
        this(dataReader, 0L, numValues);
    }

    private InstantNanosFromMicrosMaterializer(ValuesReader dataReader, long nullValue, int numValues) {
        super(nullValue, numValues);
        this.dataReader = dataReader;
    }

    @Override
    public void fillValues(int startIndex, int endIndex) {
        for (int ii = startIndex; ii < endIndex; ++ii) {
            this.data[ii] = DateTimeUtils.microsToNanos((long)this.dataReader.readLong());
        }
    }
}

