/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base.materializers;

import io.deephaven.parquet.base.PageMaterializer;
import io.deephaven.parquet.base.PageMaterializerFactory;
import java.util.Arrays;
import org.apache.parquet.column.values.ValuesReader;

public class IntMaterializer
implements PageMaterializer {
    public static final PageMaterializerFactory FACTORY = new PageMaterializerFactory(){

        @Override
        public PageMaterializer makeMaterializerWithNulls(ValuesReader dataReader, Object nullValue, int numValues) {
            return new IntMaterializer(dataReader, (Integer)nullValue, numValues);
        }

        @Override
        public PageMaterializer makeMaterializerNonNull(ValuesReader dataReader, int numValues) {
            return new IntMaterializer(dataReader, numValues);
        }
    };
    private final ValuesReader dataReader;
    private final int nullValue;
    private final int[] data;

    private IntMaterializer(ValuesReader dataReader, int numValues) {
        this(dataReader, 0, numValues);
    }

    private IntMaterializer(ValuesReader dataReader, int nullValue, int numValues) {
        this.dataReader = dataReader;
        this.nullValue = nullValue;
        this.data = new int[numValues];
    }

    @Override
    public void fillNulls(int startIndex, int endIndex) {
        Arrays.fill(this.data, startIndex, endIndex, this.nullValue);
    }

    @Override
    public void fillValues(int startIndex, int endIndex) {
        for (int ii = startIndex; ii < endIndex; ++ii) {
            this.data[ii] = this.dataReader.readInteger();
        }
    }

    @Override
    public Object fillAll() {
        this.fillValues(0, this.data.length);
        return this.data;
    }

    @Override
    public Object data() {
        return this.data;
    }
}

