/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base.materializers;

import io.deephaven.parquet.base.PageMaterializer;
import io.deephaven.parquet.base.PageMaterializerFactory;
import io.deephaven.parquet.base.ParquetTimeUtils;
import io.deephaven.parquet.base.materializers.ObjectMaterializerBase;
import java.time.LocalDateTime;
import org.apache.parquet.column.values.ValuesReader;

public class LocalDateTimeFromMicrosMaterializer
extends ObjectMaterializerBase<LocalDateTime>
implements PageMaterializer {
    public static final PageMaterializerFactory FACTORY = new PageMaterializerFactory(){

        @Override
        public PageMaterializer makeMaterializerWithNulls(ValuesReader dataReader, Object nullValue, int numValues) {
            return new LocalDateTimeFromMicrosMaterializer(dataReader, (LocalDateTime)nullValue, numValues);
        }

        @Override
        public PageMaterializer makeMaterializerNonNull(ValuesReader dataReader, int numValues) {
            return new LocalDateTimeFromMicrosMaterializer(dataReader, numValues);
        }
    };
    private final ValuesReader dataReader;

    private LocalDateTimeFromMicrosMaterializer(ValuesReader dataReader, int numValues) {
        this(dataReader, null, numValues);
    }

    private LocalDateTimeFromMicrosMaterializer(ValuesReader dataReader, LocalDateTime nullValue, int numValues) {
        super(nullValue, new LocalDateTime[numValues]);
        this.dataReader = dataReader;
    }

    @Override
    public void fillValues(int startIndex, int endIndex) {
        for (int ii = startIndex; ii < endIndex; ++ii) {
            ((LocalDateTime[])this.data)[ii] = ParquetTimeUtils.epochMicrosToLocalDateTimeUTC(this.dataReader.readLong());
        }
    }
}

