/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base.materializers;

import io.deephaven.parquet.base.PageMaterializer;
import io.deephaven.parquet.base.PageMaterializerFactory;
import io.deephaven.parquet.base.ParquetTimeUtils;
import io.deephaven.parquet.base.materializers.ObjectMaterializerBase;
import java.time.LocalDateTime;
import org.apache.parquet.column.values.ValuesReader;

public class LocalDateTimeFromNanosMaterializer
extends ObjectMaterializerBase<LocalDateTime>
implements PageMaterializer {
    public static final PageMaterializerFactory FACTORY = new PageMaterializerFactory(){

        @Override
        public PageMaterializer makeMaterializerWithNulls(ValuesReader dataReader, Object nullValue, int numValues) {
            return new LocalDateTimeFromNanosMaterializer(dataReader, (LocalDateTime)nullValue, numValues);
        }

        @Override
        public PageMaterializer makeMaterializerNonNull(ValuesReader dataReader, int numValues) {
            return new LocalDateTimeFromNanosMaterializer(dataReader, numValues);
        }
    };
    private final ValuesReader dataReader;

    private LocalDateTimeFromNanosMaterializer(ValuesReader dataReader, int numValues) {
        this(dataReader, null, numValues);
    }

    private LocalDateTimeFromNanosMaterializer(ValuesReader dataReader, LocalDateTime nullValue, int numValues) {
        super(nullValue, new LocalDateTime[numValues]);
        this.dataReader = dataReader;
    }

    @Override
    public void fillValues(int startIndex, int endIndex) {
        for (int ii = startIndex; ii < endIndex; ++ii) {
            ((LocalDateTime[])this.data)[ii] = ParquetTimeUtils.epochNanosToLocalDateTimeUTC(this.dataReader.readLong());
        }
    }
}

