/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base.materializers;

import io.deephaven.parquet.base.PageMaterializer;
import java.util.Arrays;

abstract class LongMaterializerBase
implements PageMaterializer {
    private final long nullValue;
    final long[] data;

    LongMaterializerBase(long nullValue, int numValues) {
        this.nullValue = nullValue;
        this.data = new long[numValues];
    }

    @Override
    public void fillNulls(int startIndex, int endIndex) {
        Arrays.fill(this.data, startIndex, endIndex, this.nullValue);
    }

    @Override
    public Object fillAll() {
        this.fillValues(0, this.data.length);
        return this.data;
    }

    @Override
    public Object data() {
        return this.data;
    }
}

