/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base.materializers;

import io.deephaven.parquet.base.PageMaterializer;
import io.deephaven.parquet.base.PageMaterializerFactory;
import io.deephaven.parquet.base.materializers.ObjectMaterializerBase;
import io.deephaven.util.codec.ObjectCodec;
import java.lang.reflect.Array;
import org.apache.parquet.column.values.ValuesReader;

public class ObjectMaterializer<TYPE>
extends ObjectMaterializerBase<TYPE>
implements PageMaterializer {
    private final ValuesReader dataReader;
    private final ObjectCodec<TYPE> codec;

    private ObjectMaterializer(ValuesReader dataReader, int numValues, ObjectCodec<TYPE> codec, Class<TYPE> nativeType) {
        this(dataReader, null, numValues, codec, nativeType);
    }

    private ObjectMaterializer(ValuesReader dataReader, TYPE nullValue, int numValues, ObjectCodec<TYPE> codec, Class<TYPE> nativeType) {
        super(nullValue, (Object[])Array.newInstance(nativeType, numValues));
        this.dataReader = dataReader;
        this.codec = codec;
    }

    @Override
    public void fillValues(int startIndex, int endIndex) {
        for (int ii = startIndex; ii < endIndex; ++ii) {
            this.data[ii] = this.codec.decode(this.dataReader.readBytes().toByteBuffer());
        }
    }

    public static final class Factory<TYPE>
    implements PageMaterializerFactory {
        final ObjectCodec<TYPE> codec;
        final Class<TYPE> nativeType;

        public Factory(ObjectCodec<TYPE> codec, Class<TYPE> nativeType) {
            this.codec = codec;
            this.nativeType = nativeType;
        }

        @Override
        public PageMaterializer makeMaterializerWithNulls(ValuesReader dataReader, Object nullValue, int numValues) {
            return new ObjectMaterializer<Object>(dataReader, nullValue, numValues, this.codec, this.nativeType);
        }

        @Override
        public PageMaterializer makeMaterializerNonNull(ValuesReader dataReader, int numValues) {
            return new ObjectMaterializer<TYPE>(dataReader, numValues, this.codec, this.nativeType);
        }
    }
}

