/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.base.materializers;

import io.deephaven.parquet.base.PageMaterializer;
import io.deephaven.parquet.base.PageMaterializerFactory;
import java.util.Arrays;
import org.apache.parquet.column.values.ValuesReader;

public class ShortMaterializer
implements PageMaterializer {
    public static final PageMaterializerFactory FACTORY = new PageMaterializerFactory(){

        @Override
        public PageMaterializer makeMaterializerWithNulls(ValuesReader dataReader, Object nullValue, int numValues) {
            return new ShortMaterializer(dataReader, (Short)nullValue, numValues);
        }

        @Override
        public PageMaterializer makeMaterializerNonNull(ValuesReader dataReader, int numValues) {
            return new ShortMaterializer(dataReader, numValues);
        }
    };
    private final ValuesReader dataReader;
    private final short nullValue;
    private final short[] data;

    private ShortMaterializer(ValuesReader dataReader, int numValues) {
        this(dataReader, 0, numValues);
    }

    private ShortMaterializer(ValuesReader dataReader, short nullValue, int numValues) {
        this.dataReader = dataReader;
        this.nullValue = nullValue;
        this.data = new short[numValues];
    }

    @Override
    public void fillNulls(int startIndex, int endIndex) {
        Arrays.fill(this.data, startIndex, endIndex, this.nullValue);
    }

    @Override
    public void fillValues(int startIndex, int endIndex) {
        for (int ii = startIndex; ii < endIndex; ++ii) {
            this.data[ii] = (short)this.dataReader.readInteger();
        }
    }

    @Override
    public Object fillAll() {
        this.fillValues(0, this.data.length);
        return this.data;
    }

    @Override
    public Object data() {
        return this.data;
    }
}

