/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table;

import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.table.ColumnDefinition;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.parquet.table.ParquetCacheTags;
import io.deephaven.parquet.table.ParquetInstructions;
import io.deephaven.parquet.table.TypeInfos;
import java.util.Map;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

class MappedSchema {
    private final TableDefinition tableDefinition;
    private final MessageType parquetSchema;

    static MappedSchema create(Map<String, Map<ParquetCacheTags, Object>> computedCache, TableDefinition definition, RowSet rowSet, Map<String, ? extends ColumnSource<?>> columnSourceMap, ParquetInstructions instructions, ColumnDefinition<?> ... extraColumns) {
        Types.MessageTypeBuilder builder = Types.buildMessage();
        for (ColumnDefinition columnDefinition : definition.getColumns()) {
            TypeInfos.TypeInfo typeInfo = TypeInfos.getTypeInfo(computedCache, columnDefinition, rowSet, columnSourceMap, instructions);
            Type schemaType = typeInfo.createSchemaType(columnDefinition, instructions);
            builder.addField(schemaType);
        }
        for (ColumnDefinition<?> extraColumn : extraColumns) {
            builder.addField(TypeInfos.getTypeInfo(computedCache, extraColumn, rowSet, columnSourceMap, instructions).createSchemaType(extraColumn, instructions));
        }
        MessageType schema = builder.named("root");
        return new MappedSchema(definition, schema);
    }

    private MappedSchema(TableDefinition tableDefinition, MessageType parquetSchema) {
        this.tableDefinition = tableDefinition;
        this.parquetSchema = parquetSchema;
    }

    TableDefinition getTableDefinition() {
        return this.tableDefinition;
    }

    MessageType getParquetSchema() {
        return this.parquetSchema;
    }
}

