/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table;

import io.deephaven.base.verify.Require;
import io.deephaven.configuration.Configuration;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.engine.table.impl.ColumnToCodecMappings;
import io.deephaven.hash.KeyedObjectHashMap;
import io.deephaven.hash.KeyedObjectKey;
import io.deephaven.util.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ParquetInstructions
implements ColumnToCodecMappings {
    private static volatile String defaultCompressionCodecName = CompressionCodecName.SNAPPY.toString();
    private static volatile int defaultMaximumDictionaryKeys = 0x100000;
    private static volatile int defaultMaximumDictionarySize = 0x100000;
    public static final int MIN_TARGET_PAGE_SIZE = Configuration.getInstance().getIntegerWithDefault("Parquet.minTargetPageSize", 2048);
    private static final int DEFAULT_TARGET_PAGE_SIZE;
    private static volatile int defaultTargetPageSize;
    private static final boolean DEFAULT_IS_REFRESHING = false;
    private static final boolean DEFAULT_GENERATE_METADATA_FILES = false;
    static final String UUID_TOKEN = "{uuid}";
    static final String PARTITIONS_TOKEN = "{partitions}";
    static final String FILE_INDEX_TOKEN = "{i}";
    private static final String DEFAULT_BASE_NAME_FOR_PARTITIONED_PARQUET_DATA = "{uuid}";
    public static final ParquetInstructions EMPTY;

    @Deprecated
    public static void setDefaultCompressionCodecName(String name) {
        defaultCompressionCodecName = name;
    }

    public static String getDefaultCompressionCodecName() {
        return defaultCompressionCodecName;
    }

    public static void setDefaultMaximumDictionaryKeys(int maximumDictionaryKeys) {
        defaultMaximumDictionaryKeys = Require.geqZero((int)maximumDictionaryKeys, (String)"maximumDictionaryKeys");
    }

    public static int getDefaultMaximumDictionaryKeys() {
        return defaultMaximumDictionaryKeys;
    }

    public static void setDefaultMaximumDictionarySize(int maximumDictionarySize) {
        defaultMaximumDictionarySize = Require.geqZero((int)maximumDictionarySize, (String)"maximumDictionarySize");
    }

    public static int getDefaultMaximumDictionarySize() {
        return defaultMaximumDictionarySize;
    }

    public static void setDefaultTargetPageSize(int newDefaultSizeBytes) {
        if (newDefaultSizeBytes < MIN_TARGET_PAGE_SIZE) {
            throw new IllegalArgumentException("Default target page size should be larger than " + MIN_TARGET_PAGE_SIZE + " bytes");
        }
        defaultTargetPageSize = newDefaultSizeBytes;
    }

    public static int getDefaultTargetPageSize() {
        return defaultTargetPageSize;
    }

    public final String getColumnNameFromParquetColumnNameOrDefault(String parquetColumnName) {
        String mapped = this.getColumnNameFromParquetColumnName(parquetColumnName);
        return mapped != null ? mapped : parquetColumnName;
    }

    public abstract String getParquetColumnNameFromColumnNameOrDefault(String var1);

    public abstract String getColumnNameFromParquetColumnName(String var1);

    public abstract String getCodecName(String var1);

    public abstract String getCodecArgs(String var1);

    public abstract boolean useDictionary(String var1);

    public abstract Object getSpecialInstructions();

    public abstract String getCompressionCodecName();

    public abstract int getMaximumDictionaryKeys();

    public abstract int getMaximumDictionarySize();

    public abstract boolean isLegacyParquet();

    public abstract int getTargetPageSize();

    public abstract boolean isRefreshing();

    public abstract boolean generateMetadataFiles();

    public abstract Optional<ParquetFileLayout> getFileLayout();

    public abstract Optional<TableDefinition> getTableDefinition();

    public abstract Optional<Collection<List<String>>> getIndexColumns();

    public abstract ParquetInstructions withTableDefinition(TableDefinition var1);

    public abstract ParquetInstructions withLayout(ParquetFileLayout var1);

    public abstract ParquetInstructions withTableDefinitionAndLayout(TableDefinition var1, ParquetFileLayout var2);

    @VisibleForTesting
    abstract ParquetInstructions withIndexColumns(Collection<List<String>> var1);

    public abstract String baseNameForPartitionedParquetData();

    @VisibleForTesting
    public static boolean sameColumnNamesAndCodecMappings(ParquetInstructions i1, ParquetInstructions i2) {
        if (i1 == EMPTY) {
            if (i2 == EMPTY) {
                return true;
            }
            return ((ReadOnly)i2).columnNameToInstructions.isEmpty();
        }
        if (i2 == EMPTY) {
            return ((ReadOnly)i1).columnNameToInstructions.isEmpty();
        }
        return ReadOnly.sameCodecMappings((ReadOnly)i1, (ReadOnly)i2);
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        defaultTargetPageSize = DEFAULT_TARGET_PAGE_SIZE = Configuration.getInstance().getIntegerWithDefault("Parquet.defaultTargetPageSize", 65536);
        EMPTY = new ParquetInstructions(){

            @Override
            public String getParquetColumnNameFromColumnNameOrDefault(String columnName) {
                return columnName;
            }

            @Override
            @Nullable
            public String getColumnNameFromParquetColumnName(String parquetColumnName) {
                return null;
            }

            @Override
            @Nullable
            public String getCodecName(String columnName) {
                return null;
            }

            @Override
            @Nullable
            public String getCodecArgs(String columnName) {
                return null;
            }

            @Override
            public boolean useDictionary(String columnName) {
                return false;
            }

            @Override
            @Nullable
            public Object getSpecialInstructions() {
                return null;
            }

            @Override
            public String getCompressionCodecName() {
                return defaultCompressionCodecName;
            }

            @Override
            public int getMaximumDictionaryKeys() {
                return defaultMaximumDictionaryKeys;
            }

            @Override
            public int getMaximumDictionarySize() {
                return defaultMaximumDictionarySize;
            }

            @Override
            public boolean isLegacyParquet() {
                return false;
            }

            @Override
            public int getTargetPageSize() {
                return defaultTargetPageSize;
            }

            @Override
            public boolean isRefreshing() {
                return false;
            }

            @Override
            public boolean generateMetadataFiles() {
                return false;
            }

            @Override
            public String baseNameForPartitionedParquetData() {
                return "{uuid}";
            }

            @Override
            public Optional<ParquetFileLayout> getFileLayout() {
                return Optional.empty();
            }

            @Override
            public Optional<TableDefinition> getTableDefinition() {
                return Optional.empty();
            }

            @Override
            public Optional<Collection<List<String>>> getIndexColumns() {
                return Optional.empty();
            }

            @Override
            public ParquetInstructions withTableDefinition(@Nullable TableDefinition useDefinition) {
                return this.withTableDefinitionAndLayout(useDefinition, null);
            }

            @Override
            public ParquetInstructions withLayout(@Nullable ParquetFileLayout useLayout) {
                return this.withTableDefinitionAndLayout(null, useLayout);
            }

            @Override
            public ParquetInstructions withTableDefinitionAndLayout(@Nullable TableDefinition useDefinition, @Nullable ParquetFileLayout useLayout) {
                return new ReadOnly(null, null, this.getCompressionCodecName(), this.getMaximumDictionaryKeys(), this.getMaximumDictionarySize(), this.isLegacyParquet(), this.getTargetPageSize(), this.isRefreshing(), this.getSpecialInstructions(), this.generateMetadataFiles(), this.baseNameForPartitionedParquetData(), useLayout, useDefinition, null);
            }

            @Override
            ParquetInstructions withIndexColumns(Collection<List<String>> indexColumns) {
                return new ReadOnly(null, null, this.getCompressionCodecName(), this.getMaximumDictionaryKeys(), this.getMaximumDictionarySize(), this.isLegacyParquet(), this.getTargetPageSize(), this.isRefreshing(), this.getSpecialInstructions(), this.generateMetadataFiles(), this.baseNameForPartitionedParquetData(), null, null, indexColumns);
            }
        };
    }

    public static class Builder {
        private KeyedObjectHashMap<String, ColumnInstructions> columnNameToInstructions;
        private KeyedObjectHashMap<String, ColumnInstructions> parquetColumnNameToInstructions;
        private String compressionCodecName = defaultCompressionCodecName;
        private int maximumDictionaryKeys = defaultMaximumDictionaryKeys;
        private int maximumDictionarySize = defaultMaximumDictionarySize;
        private boolean isLegacyParquet;
        private int targetPageSize = defaultTargetPageSize;
        private boolean isRefreshing = false;
        private Object specialInstructions;
        private boolean generateMetadataFiles = false;
        private String baseNameForPartitionedParquetData = "{uuid}";
        private ParquetFileLayout fileLayout;
        private TableDefinition tableDefinition;
        private Collection<List<String>> indexColumns;

        public Builder() {
        }

        public Builder(ParquetInstructions parquetInstructions) {
            if (parquetInstructions == EMPTY) {
                return;
            }
            ReadOnly readOnlyParquetInstructions = (ReadOnly)parquetInstructions;
            this.columnNameToInstructions = readOnlyParquetInstructions.copyColumnNameToInstructions();
            this.parquetColumnNameToInstructions = readOnlyParquetInstructions.copyParquetColumnNameToInstructions();
            this.compressionCodecName = readOnlyParquetInstructions.getCompressionCodecName();
            this.maximumDictionaryKeys = readOnlyParquetInstructions.getMaximumDictionaryKeys();
            this.maximumDictionarySize = readOnlyParquetInstructions.getMaximumDictionarySize();
            this.isLegacyParquet = readOnlyParquetInstructions.isLegacyParquet();
            this.targetPageSize = readOnlyParquetInstructions.getTargetPageSize();
            this.isRefreshing = readOnlyParquetInstructions.isRefreshing();
            this.specialInstructions = readOnlyParquetInstructions.getSpecialInstructions();
            this.generateMetadataFiles = readOnlyParquetInstructions.generateMetadataFiles();
            this.baseNameForPartitionedParquetData = readOnlyParquetInstructions.baseNameForPartitionedParquetData();
            this.fileLayout = readOnlyParquetInstructions.getFileLayout().orElse(null);
            this.tableDefinition = readOnlyParquetInstructions.getTableDefinition().orElse(null);
            this.indexColumns = readOnlyParquetInstructions.getIndexColumns().orElse(null);
        }

        private void newColumnNameToInstructionsMap() {
            this.columnNameToInstructions = new KeyedObjectHashMap((KeyedObjectKey)new KeyedObjectKey.Basic<String, ColumnInstructions>(){

                public String getKey(@NotNull ColumnInstructions value) {
                    return value.getColumnName();
                }
            });
        }

        private void newParquetColumnNameToInstructionsMap() {
            this.parquetColumnNameToInstructions = new KeyedObjectHashMap((KeyedObjectKey)new KeyedObjectKey.Basic<String, ColumnInstructions>(){

                public String getKey(@NotNull ColumnInstructions value) {
                    return value.getParquetColumnName();
                }
            });
        }

        public Builder addColumnNameMapping(String parquetColumnName, String columnName) {
            if (parquetColumnName.equals(columnName)) {
                return this;
            }
            if (this.columnNameToInstructions == null) {
                this.newColumnNameToInstructionsMap();
                ColumnInstructions ci = new ColumnInstructions(columnName);
                ci.setParquetColumnName(parquetColumnName);
                this.columnNameToInstructions.put((Object)columnName, (Object)ci);
                this.newParquetColumnNameToInstructionsMap();
                this.parquetColumnNameToInstructions.put((Object)parquetColumnName, (Object)ci);
                return this;
            }
            ColumnInstructions ci = (ColumnInstructions)this.columnNameToInstructions.get((Object)columnName);
            if (ci != null) {
                if (ci.parquetColumnName != null) {
                    if (ci.parquetColumnName.equals(parquetColumnName)) {
                        return this;
                    }
                    throw new IllegalArgumentException("Cannot add a mapping from parquetColumnName=" + parquetColumnName + ": columnName=" + columnName + " already mapped to parquetColumnName=" + ci.parquetColumnName);
                }
            } else {
                ci = new ColumnInstructions(columnName);
                this.columnNameToInstructions.put((Object)columnName, (Object)ci);
            }
            if (this.parquetColumnNameToInstructions == null) {
                this.newParquetColumnNameToInstructionsMap();
                this.parquetColumnNameToInstructions.put((Object)parquetColumnName, (Object)ci);
                return this;
            }
            ColumnInstructions fromParquetColumnNameInstructions = (ColumnInstructions)this.parquetColumnNameToInstructions.get((Object)parquetColumnName);
            if (fromParquetColumnNameInstructions != null) {
                if (fromParquetColumnNameInstructions == ci) {
                    return this;
                }
                throw new IllegalArgumentException("Cannot add new mapping from parquetColumnName=" + parquetColumnName + " to columnName=" + columnName + ": already mapped to columnName=" + fromParquetColumnNameInstructions.getColumnName());
            }
            ci.setParquetColumnName(parquetColumnName);
            this.parquetColumnNameToInstructions.put((Object)parquetColumnName, (Object)ci);
            return this;
        }

        public Set<String> getTakenNames() {
            return this.columnNameToInstructions == null ? Collections.emptySet() : this.columnNameToInstructions.keySet();
        }

        public Builder addColumnCodec(String columnName, String codecName) {
            return this.addColumnCodec(columnName, codecName, null);
        }

        public Builder addColumnCodec(String columnName, String codecName, String codecArgs) {
            ColumnInstructions ci = this.getColumnInstructions(columnName);
            ci.setCodecName(codecName);
            ci.setCodecArgs(codecArgs);
            return this;
        }

        public Builder useDictionary(String columnName, boolean useDictionary) {
            ColumnInstructions ci = this.getColumnInstructions(columnName);
            ci.useDictionary(useDictionary);
            return this;
        }

        private ColumnInstructions getColumnInstructions(String columnName) {
            ColumnInstructions ci;
            if (this.columnNameToInstructions == null) {
                this.newColumnNameToInstructionsMap();
                ci = new ColumnInstructions(columnName);
                this.columnNameToInstructions.put((Object)columnName, (Object)ci);
            } else {
                ci = (ColumnInstructions)this.columnNameToInstructions.putIfAbsent((Object)columnName, ColumnInstructions::new);
            }
            return ci;
        }

        public Builder setCompressionCodecName(String compressionCodecName) {
            this.compressionCodecName = compressionCodecName;
            return this;
        }

        public Builder setMaximumDictionaryKeys(int maximumDictionaryKeys) {
            this.maximumDictionaryKeys = Require.geqZero((int)maximumDictionaryKeys, (String)"maximumDictionaryKeys");
            return this;
        }

        public Builder setMaximumDictionarySize(int maximumDictionarySize) {
            this.maximumDictionarySize = Require.geqZero((int)maximumDictionarySize, (String)"maximumDictionarySize");
            return this;
        }

        public Builder setIsLegacyParquet(boolean isLegacyParquet) {
            this.isLegacyParquet = isLegacyParquet;
            return this;
        }

        public Builder setTargetPageSize(int targetPageSize) {
            if (targetPageSize < MIN_TARGET_PAGE_SIZE) {
                throw new IllegalArgumentException("Target page size should be >= " + MIN_TARGET_PAGE_SIZE);
            }
            this.targetPageSize = targetPageSize;
            return this;
        }

        public Builder setIsRefreshing(boolean isRefreshing) {
            this.isRefreshing = isRefreshing;
            return this;
        }

        public Builder setSpecialInstructions(Object specialInstructions) {
            this.specialInstructions = specialInstructions;
            return this;
        }

        public Builder setGenerateMetadataFiles(boolean generateMetadataFiles) {
            this.generateMetadataFiles = generateMetadataFiles;
            return this;
        }

        public Builder setBaseNameForPartitionedParquetData(String baseNameForPartitionedParquetData) {
            this.baseNameForPartitionedParquetData = baseNameForPartitionedParquetData;
            return this;
        }

        public Builder setFileLayout(ParquetFileLayout fileLayout) {
            this.fileLayout = fileLayout;
            return this;
        }

        public Builder setTableDefinition(TableDefinition tableDefinition) {
            this.tableDefinition = tableDefinition;
            return this;
        }

        private void initIndexColumns() {
            if (this.indexColumns == null) {
                this.indexColumns = new ArrayList<List<String>>();
            }
        }

        public Builder addIndexColumns(String ... indexColumns) {
            this.initIndexColumns();
            this.indexColumns.add(List.of(indexColumns));
            return this;
        }

        public Builder addAllIndexColumns(Iterable<List<String>> indexColumns) {
            this.initIndexColumns();
            for (List<String> indexColumnList : indexColumns) {
                this.indexColumns.add(List.copyOf(indexColumnList));
            }
            return this;
        }

        public ParquetInstructions build() {
            KeyedObjectHashMap<String, ColumnInstructions> columnNameToInstructionsOut = this.columnNameToInstructions;
            this.columnNameToInstructions = null;
            KeyedObjectHashMap<String, ColumnInstructions> parquetColumnNameToColumnNameOut = this.parquetColumnNameToInstructions;
            this.parquetColumnNameToInstructions = null;
            return new ReadOnly(columnNameToInstructionsOut, parquetColumnNameToColumnNameOut, this.compressionCodecName, this.maximumDictionaryKeys, this.maximumDictionarySize, this.isLegacyParquet, this.targetPageSize, this.isRefreshing, this.specialInstructions, this.generateMetadataFiles, this.baseNameForPartitionedParquetData, this.fileLayout, this.tableDefinition, this.indexColumns);
        }
    }

    private static final class ReadOnly
    extends ParquetInstructions {
        private final KeyedObjectHashMap<String, ColumnInstructions> columnNameToInstructions;
        private final KeyedObjectHashMap<String, ColumnInstructions> parquetColumnNameToInstructions;
        private final String compressionCodecName;
        private final int maximumDictionaryKeys;
        private final int maximumDictionarySize;
        private final boolean isLegacyParquet;
        private final int targetPageSize;
        private final boolean isRefreshing;
        private final Object specialInstructions;
        private final boolean generateMetadataFiles;
        private final String baseNameForPartitionedParquetData;
        private final ParquetFileLayout fileLayout;
        private final TableDefinition tableDefinition;
        private final Collection<List<String>> indexColumns;

        private ReadOnly(KeyedObjectHashMap<String, ColumnInstructions> columnNameToInstructions, KeyedObjectHashMap<String, ColumnInstructions> parquetColumnNameToColumnName, String compressionCodecName, int maximumDictionaryKeys, int maximumDictionarySize, boolean isLegacyParquet, int targetPageSize, boolean isRefreshing, Object specialInstructions, boolean generateMetadataFiles, String baseNameForPartitionedParquetData, ParquetFileLayout fileLayout, TableDefinition tableDefinition, Collection<List<String>> indexColumns) {
            this.columnNameToInstructions = columnNameToInstructions;
            this.parquetColumnNameToInstructions = parquetColumnNameToColumnName;
            this.compressionCodecName = compressionCodecName;
            this.maximumDictionaryKeys = maximumDictionaryKeys;
            this.maximumDictionarySize = maximumDictionarySize;
            this.isLegacyParquet = isLegacyParquet;
            this.targetPageSize = targetPageSize;
            this.isRefreshing = isRefreshing;
            this.specialInstructions = specialInstructions;
            this.generateMetadataFiles = generateMetadataFiles;
            this.baseNameForPartitionedParquetData = baseNameForPartitionedParquetData;
            this.fileLayout = fileLayout;
            this.tableDefinition = tableDefinition;
            this.indexColumns = indexColumns == null ? null : (Collection)indexColumns.stream().map(List::copyOf).collect(Collectors.toUnmodifiableList());
        }

        private String getOrDefault(String columnName, String defaultValue, Function<ColumnInstructions, String> fun) {
            if (this.columnNameToInstructions == null) {
                return defaultValue;
            }
            ColumnInstructions ci = (ColumnInstructions)this.columnNameToInstructions.get((Object)columnName);
            if (ci == null) {
                return defaultValue;
            }
            return fun.apply(ci);
        }

        private boolean getOrDefault(String columnName, boolean defaultValue, Predicate<ColumnInstructions> fun) {
            if (this.columnNameToInstructions == null) {
                return defaultValue;
            }
            ColumnInstructions ci = (ColumnInstructions)this.columnNameToInstructions.get((Object)columnName);
            if (ci == null) {
                return defaultValue;
            }
            return fun.test(ci);
        }

        @Override
        public String getParquetColumnNameFromColumnNameOrDefault(String columnName) {
            return this.getOrDefault(columnName, columnName, ColumnInstructions::getParquetColumnName);
        }

        @Override
        public String getColumnNameFromParquetColumnName(String parquetColumnName) {
            if (this.parquetColumnNameToInstructions == null) {
                return null;
            }
            ColumnInstructions ci = (ColumnInstructions)this.parquetColumnNameToInstructions.get((Object)parquetColumnName);
            if (ci == null) {
                return null;
            }
            return ci.getColumnName();
        }

        @Override
        public String getCodecName(String columnName) {
            return this.getOrDefault(columnName, null, ColumnInstructions::getCodecName);
        }

        @Override
        public String getCodecArgs(String columnName) {
            return this.getOrDefault(columnName, null, ColumnInstructions::getCodecArgs);
        }

        @Override
        public boolean useDictionary(String columnName) {
            return this.getOrDefault(columnName, false, ColumnInstructions::useDictionary);
        }

        @Override
        public String getCompressionCodecName() {
            return this.compressionCodecName;
        }

        @Override
        public int getMaximumDictionaryKeys() {
            return this.maximumDictionaryKeys;
        }

        @Override
        public int getMaximumDictionarySize() {
            return this.maximumDictionarySize;
        }

        @Override
        public boolean isLegacyParquet() {
            return this.isLegacyParquet;
        }

        @Override
        public int getTargetPageSize() {
            return this.targetPageSize;
        }

        @Override
        public boolean isRefreshing() {
            return this.isRefreshing;
        }

        @Override
        @Nullable
        public Object getSpecialInstructions() {
            return this.specialInstructions;
        }

        @Override
        public boolean generateMetadataFiles() {
            return this.generateMetadataFiles;
        }

        @Override
        public String baseNameForPartitionedParquetData() {
            return this.baseNameForPartitionedParquetData;
        }

        @Override
        public Optional<ParquetFileLayout> getFileLayout() {
            return Optional.ofNullable(this.fileLayout);
        }

        @Override
        public Optional<TableDefinition> getTableDefinition() {
            return Optional.ofNullable(this.tableDefinition);
        }

        @Override
        public Optional<Collection<List<String>>> getIndexColumns() {
            return Optional.ofNullable(this.indexColumns);
        }

        @Override
        public ParquetInstructions withTableDefinition(@Nullable TableDefinition useDefinition) {
            return this.withTableDefinitionAndLayout(useDefinition, this.fileLayout);
        }

        @Override
        public ParquetInstructions withLayout(@Nullable ParquetFileLayout useLayout) {
            return this.withTableDefinitionAndLayout(this.tableDefinition, useLayout);
        }

        @Override
        public ParquetInstructions withTableDefinitionAndLayout(@Nullable TableDefinition useDefinition, @Nullable ParquetFileLayout useLayout) {
            return new ReadOnly(this.columnNameToInstructions, this.parquetColumnNameToInstructions, this.getCompressionCodecName(), this.getMaximumDictionaryKeys(), this.getMaximumDictionarySize(), this.isLegacyParquet(), this.getTargetPageSize(), this.isRefreshing(), this.getSpecialInstructions(), this.generateMetadataFiles(), this.baseNameForPartitionedParquetData(), useLayout, useDefinition, this.indexColumns);
        }

        @Override
        ParquetInstructions withIndexColumns(Collection<List<String>> useIndexColumns) {
            return new ReadOnly(this.columnNameToInstructions, this.parquetColumnNameToInstructions, this.getCompressionCodecName(), this.getMaximumDictionaryKeys(), this.getMaximumDictionarySize(), this.isLegacyParquet(), this.getTargetPageSize(), this.isRefreshing(), this.getSpecialInstructions(), this.generateMetadataFiles(), this.baseNameForPartitionedParquetData(), this.fileLayout, this.tableDefinition, useIndexColumns);
        }

        KeyedObjectHashMap<String, ColumnInstructions> copyColumnNameToInstructions() {
            return this.columnNameToInstructions == null ? null : (KeyedObjectHashMap)this.columnNameToInstructions.clone();
        }

        KeyedObjectHashMap<String, ColumnInstructions> copyParquetColumnNameToInstructions() {
            return this.parquetColumnNameToInstructions == null ? null : (KeyedObjectHashMap)this.parquetColumnNameToInstructions.clone();
        }

        private static boolean sameCodecMappings(ReadOnly r1, ReadOnly r2) {
            Set r1ColumnNames = r1.columnNameToInstructions.keySet();
            if (r2.columnNameToInstructions.size() != r1ColumnNames.size()) {
                return false;
            }
            for (String colName : r1ColumnNames) {
                String r2CodecArgs;
                String r2CodecName;
                if (!r2.columnNameToInstructions.containsKey((Object)colName)) {
                    return false;
                }
                String r1CodecName = r1.getCodecName(colName);
                if (!Objects.equals(r1CodecName, r2CodecName = r2.getCodecName(colName))) {
                    return false;
                }
                String r1CodecArgs = r1.getCodecArgs(colName);
                if (Objects.equals(r1CodecArgs, r2CodecArgs = r2.getCodecArgs(colName))) continue;
                return false;
            }
            return true;
        }
    }

    private static class ColumnInstructions {
        private final String columnName;
        private String parquetColumnName;
        private String codecName;
        private String codecArgs;
        private boolean useDictionary;

        public ColumnInstructions(String columnName) {
            this.columnName = columnName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getParquetColumnName() {
            return this.parquetColumnName != null ? this.parquetColumnName : this.columnName;
        }

        public ColumnInstructions setParquetColumnName(String parquetColumnName) {
            this.parquetColumnName = parquetColumnName;
            return this;
        }

        public String getCodecName() {
            return this.codecName;
        }

        public ColumnInstructions setCodecName(String codecName) {
            this.codecName = codecName;
            return this;
        }

        public String getCodecArgs() {
            return this.codecArgs;
        }

        public ColumnInstructions setCodecArgs(String codecArgs) {
            this.codecArgs = codecArgs;
            return this;
        }

        public boolean useDictionary() {
            return this.useDictionary;
        }

        public void useDictionary(boolean useDictionary) {
            this.useDictionary = useDictionary;
        }
    }

    public static enum ParquetFileLayout {
        SINGLE_FILE,
        FLAT_PARTITIONED,
        KV_PARTITIONED,
        METADATA_PARTITIONED;

    }
}

