/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table;

import io.deephaven.UncheckedDeephavenException;
import io.deephaven.base.FileUtils;
import io.deephaven.parquet.base.ParquetFileWriter;
import io.deephaven.parquet.base.ParquetMetadataFileWriter;
import io.deephaven.parquet.base.ParquetUtils;
import io.deephaven.parquet.base.PositionedBufferedOutputStream;
import io.deephaven.parquet.table.metadata.ColumnTypeInfo;
import io.deephaven.parquet.table.metadata.TableInfo;
import io.deephaven.util.channel.SeekableChannelsProvider;
import io.deephaven.util.channel.SeekableChannelsProviderLoader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ParquetMetadataFileWriterImpl
implements ParquetMetadataFileWriter {
    private final Path metadataRootDirAbsPath;
    private final List<ParquetFileMetadata> parquetFileMetadataList;
    private final SeekableChannelsProvider channelsProvider;
    private final MessageType partitioningColumnsSchema;
    private MessageType mergedSchema;
    private String mergedCreatedByString;
    private final Map<String, String> mergedKeyValueMetaData;
    private final List<BlockMetaData> mergedBlocks;
    private List<ColumnTypeInfo> mergedColumnTypes;
    private String mergedVersion;

    ParquetMetadataFileWriterImpl(@NotNull File metadataRootDir, @NotNull File[] destinations, @Nullable MessageType partitioningColumnsSchema) {
        if (destinations.length == 0) {
            throw new IllegalArgumentException("No destinations provided");
        }
        this.metadataRootDirAbsPath = metadataRootDir.getAbsoluteFile().toPath();
        String metadataRootDirAbsPathString = this.metadataRootDirAbsPath.toString();
        for (File destination : destinations) {
            if (destination.getAbsolutePath().startsWith(metadataRootDirAbsPathString)) continue;
            throw new UncheckedDeephavenException("All destinations must be nested under the provided metadata root directory, provided destination " + destination.getAbsolutePath() + " is not under " + metadataRootDirAbsPathString);
        }
        this.parquetFileMetadataList = new ArrayList<ParquetFileMetadata>(destinations.length);
        this.channelsProvider = SeekableChannelsProviderLoader.getInstance().fromServiceLoader(FileUtils.convertToURI((String)metadataRootDirAbsPathString, (boolean)true), null);
        this.partitioningColumnsSchema = partitioningColumnsSchema;
        this.mergedSchema = null;
        this.mergedCreatedByString = null;
        this.mergedKeyValueMetaData = new HashMap<String, String>();
        this.mergedBlocks = new ArrayList<BlockMetaData>();
        this.mergedColumnTypes = null;
        this.mergedVersion = null;
    }

    public void addParquetFileMetadata(String parquetFilePath, ParquetMetadata metadata) {
        this.parquetFileMetadataList.add(new ParquetFileMetadata(parquetFilePath, metadata));
    }

    public void writeMetadataFiles(String metadataFilePath, String commonMetadataFilePath) throws IOException {
        if (this.parquetFileMetadataList.isEmpty()) {
            throw new UncheckedDeephavenException("No parquet files to write metadata for");
        }
        this.mergeMetadata();
        ParquetMetadata metadataFooter = new ParquetMetadata(new FileMetaData(this.mergedSchema, this.mergedKeyValueMetaData, this.mergedCreatedByString), this.mergedBlocks);
        this.writeMetadataFile(metadataFooter, metadataFilePath);
        this.mergedSchema = ParquetMetadataFileWriterImpl.mergeSchemaInto(this.mergedSchema, this.partitioningColumnsSchema);
        ParquetMetadata commonMetadataFooter = new ParquetMetadata(new FileMetaData(this.mergedSchema, this.mergedKeyValueMetaData, this.mergedCreatedByString), new ArrayList());
        this.writeMetadataFile(commonMetadataFooter, commonMetadataFilePath);
        this.clear();
    }

    private void mergeMetadata() throws IOException {
        HashSet<String> mergedCreatedBy = new HashSet<String>();
        for (ParquetFileMetadata parquetFileMetadata : this.parquetFileMetadataList) {
            FileMetaData fileMetaData = parquetFileMetadata.metadata.getFileMetaData();
            this.mergedSchema = ParquetMetadataFileWriterImpl.mergeSchemaInto(fileMetaData.getSchema(), this.mergedSchema);
            String relativePath = ParquetMetadataFileWriterImpl.getRelativePath(parquetFileMetadata.filePath, this.metadataRootDirAbsPath);
            this.mergeKeyValueMetaData(parquetFileMetadata, relativePath);
            ParquetMetadataFileWriterImpl.mergeBlocksInto(parquetFileMetadata, relativePath, this.mergedBlocks);
            mergedCreatedBy.add(fileMetaData.getCreatedBy());
        }
        if (this.mergedKeyValueMetaData.size() != this.parquetFileMetadataList.size()) {
            throw new IllegalStateException("We should have one entry for each file in the merged key-value metadata, but we have " + this.mergedKeyValueMetaData.size() + " entries for " + this.parquetFileMetadataList.size() + " files.");
        }
        TableInfo.Builder tableInfoBuilder = TableInfo.builder().addAllColumnTypes(this.mergedColumnTypes);
        if (this.mergedVersion != null) {
            tableInfoBuilder.version(this.mergedVersion);
        }
        this.mergedKeyValueMetaData.put("deephaven", tableInfoBuilder.build().serializeToJSON());
        this.mergedCreatedByString = mergedCreatedBy.size() == 1 ? (String)mergedCreatedBy.iterator().next() : ((Object)mergedCreatedBy).toString();
    }

    private static MessageType mergeSchemaInto(MessageType schema, MessageType mergedSchema) {
        if (mergedSchema == null) {
            return schema;
        }
        if (mergedSchema.equals((Object)schema)) {
            return mergedSchema;
        }
        return mergedSchema.union(schema, true);
    }

    private void mergeKeyValueMetaData(@NotNull ParquetFileMetadata parquetFileMetadata, @NotNull String relativePath) throws IOException {
        Map keyValueMetaData = parquetFileMetadata.metadata.getFileMetaData().getKeyValueMetaData();
        for (Map.Entry entry : keyValueMetaData.entrySet()) {
            if (!((String)entry.getKey()).equals("deephaven")) {
                this.mergedKeyValueMetaData.compute((String)entry.getKey(), (k, v) -> {
                    if (v == null) {
                        return (String)entry.getValue();
                    }
                    if (!v.equals(entry.getValue())) {
                        throw new UncheckedDeephavenException("Could not merge metadata for key " + (String)entry.getKey() + ", has conflicting values: " + (String)entry.getValue() + " and " + v);
                    }
                    return v;
                });
                continue;
            }
            String fileKey = ParquetUtils.getPerFileMetadataKey((String)relativePath);
            if (this.mergedKeyValueMetaData.containsKey(fileKey)) {
                throw new IllegalStateException("Could not merge metadata for file " + parquetFileMetadata.filePath + " because it has conflicting file key: " + fileKey);
            }
            this.mergedKeyValueMetaData.put(fileKey, (String)entry.getValue());
            TableInfo tableInfo = TableInfo.deserializeFromJSON((String)entry.getValue());
            if (this.mergedColumnTypes == null) {
                this.mergedColumnTypes = tableInfo.columnTypes();
                this.mergedVersion = tableInfo.version();
                continue;
            }
            if (!this.mergedColumnTypes.equals(tableInfo.columnTypes())) {
                throw new UncheckedDeephavenException("Could not merge metadata for key deephaven, has conflicting values for columnTypes: " + tableInfo.columnTypes() + " and " + this.mergedColumnTypes);
            }
            if (tableInfo.version().equals(this.mergedVersion)) continue;
            this.mergedVersion = null;
        }
    }

    private static void mergeBlocksInto(ParquetFileMetadata parquetFileMetadata, String fileRelativePathString, Collection<BlockMetaData> mergedBlocks) {
        for (BlockMetaData block : parquetFileMetadata.metadata.getBlocks()) {
            block.setPath(fileRelativePathString);
            mergedBlocks.add(block);
        }
    }

    private static String getRelativePath(String parquetFilePath, Path metadataRootDirAbsPath) {
        Path parquetFileAbsPath = new File(parquetFilePath).getAbsoluteFile().toPath();
        return metadataRootDirAbsPath.relativize(parquetFileAbsPath).toString();
    }

    private void writeMetadataFile(ParquetMetadata metadataFooter, String outputPath) throws IOException {
        PositionedBufferedOutputStream metadataOutputStream = new PositionedBufferedOutputStream(this.channelsProvider.getWriteChannel(outputPath, false), 262144);
        metadataOutputStream.write(ParquetUtils.MAGIC);
        ParquetFileWriter.serializeFooter((ParquetMetadata)metadataFooter, (PositionedBufferedOutputStream)metadataOutputStream);
        metadataOutputStream.close();
    }

    public void clear() {
        this.parquetFileMetadataList.clear();
        this.mergedKeyValueMetaData.clear();
        this.mergedBlocks.clear();
        this.mergedColumnTypes = null;
        this.mergedSchema = null;
        this.mergedCreatedByString = null;
    }

    private static class ParquetFileMetadata {
        final String filePath;
        final ParquetMetadata metadata;

        ParquetFileMetadata(String filePath, ParquetMetadata metadata) {
            this.filePath = filePath;
            this.metadata = metadata;
        }
    }
}

