/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table;

import io.deephaven.UncheckedDeephavenException;
import io.deephaven.api.util.NameValidator;
import io.deephaven.base.ClassUtil;
import io.deephaven.base.Pair;
import io.deephaven.engine.table.ColumnDefinition;
import io.deephaven.engine.table.impl.locations.TableDataException;
import io.deephaven.parquet.table.ParquetInstructions;
import io.deephaven.parquet.table.metadata.CodecInfo;
import io.deephaven.parquet.table.metadata.ColumnTypeInfo;
import io.deephaven.parquet.table.metadata.TableInfo;
import io.deephaven.stringset.StringSet;
import io.deephaven.util.SimpleTypeMap;
import io.deephaven.util.codec.SimpleByteArrayCodec;
import io.deephaven.util.codec.UTF8StringAsByteArrayCodec;
import io.deephaven.vector.ByteVector;
import io.deephaven.vector.CharVector;
import io.deephaven.vector.DoubleVector;
import io.deephaven.vector.FloatVector;
import io.deephaven.vector.IntVector;
import io.deephaven.vector.LongVector;
import io.deephaven.vector.ObjectVector;
import io.deephaven.vector.ShortVector;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.jetbrains.annotations.NotNull;

public class ParquetSchemaReader {
    private static final SimpleTypeMap<Class<?>> VECTOR_TYPE_MAP = SimpleTypeMap.create(null, CharVector.class, ByteVector.class, ShortVector.class, IntVector.class, LongVector.class, FloatVector.class, DoubleVector.class, ObjectVector.class);

    public static Optional<TableInfo> parseMetadata(@NotNull Map<String, String> keyValueMetadata) {
        String tableInfoRaw = keyValueMetadata.get("deephaven");
        if (tableInfoRaw == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(TableInfo.deserializeFromJSON(tableInfoRaw));
        }
        catch (IOException e) {
            throw new TableDataException("Failed to parse deephaven metadata", (Throwable)e);
        }
    }

    public static ParquetInstructions readParquetSchema(@NotNull MessageType schema, @NotNull Map<String, String> keyValueMetadata, @NotNull ParquetInstructions readInstructions, @NotNull ColumnDefinitionConsumer consumer, @NotNull BiFunction<String, Set<String>, String> legalizeColumnNameFunc) {
        MutableObject errorString = new MutableObject();
        MutableObject currentColumn = new MutableObject();
        Optional<TableInfo> tableInfo = ParquetSchemaReader.parseMetadata(keyValueMetadata);
        Map<String, ColumnTypeInfo> nonDefaultTypeColumns = tableInfo.map(TableInfo::columnTypeMap).orElse(Collections.emptyMap());
        LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<Class<?>> visitor = ParquetSchemaReader.getVisitor(nonDefaultTypeColumns, (MutableObject<String>)errorString, (MutableObject<ColumnDescriptor>)currentColumn);
        MutableObject instructionsBuilder = new MutableObject();
        Supplier<ParquetInstructions.Builder> builderSupplier = () -> {
            if (instructionsBuilder.getValue() == null) {
                instructionsBuilder.setValue((Object)new ParquetInstructions.Builder(readInstructions));
            }
            return (ParquetInstructions.Builder)instructionsBuilder.getValue();
        };
        ParquetMessageDefinition colDef = new ParquetMessageDefinition();
        HashMap<String, String[]> parquetColumnNameToFirstPath = new HashMap<String, String[]>();
        for (ColumnDescriptor column : schema.getColumns()) {
            block23: {
                LogicalTypeAnnotation logicalTypeAnnotation;
                block22: {
                    String colName;
                    if (column.getMaxRepetitionLevel() > 1) {
                        throw new UnsupportedOperationException("Unsupported maximum repetition level " + column.getMaxRepetitionLevel() + " in column " + String.join((CharSequence)"/", column.getPath()));
                    }
                    colDef.reset();
                    currentColumn.setValue((Object)column);
                    PrimitiveType primitiveType = column.getPrimitiveType();
                    logicalTypeAnnotation = primitiveType.getLogicalTypeAnnotation();
                    String parquetColumnName = column.getPath()[0];
                    parquetColumnNameToFirstPath.compute(parquetColumnName, (pcn, oldPath) -> {
                        if (oldPath != null) {
                            throw new UnsupportedOperationException("Encountered unsupported multi-column field " + parquetColumnName + ": found columns " + String.join((CharSequence)"/", oldPath) + " and " + String.join((CharSequence)"/", column.getPath()));
                        }
                        return column.getPath();
                    });
                    String mappedName = readInstructions.getColumnNameFromParquetColumnName(parquetColumnName);
                    if (mappedName != null) {
                        colName = mappedName;
                    } else {
                        String legalized = legalizeColumnNameFunc.apply(parquetColumnName, instructionsBuilder.getValue() == null ? Collections.emptySet() : ((ParquetInstructions.Builder)instructionsBuilder.getValue()).getTakenNames());
                        if (!legalized.equals(parquetColumnName)) {
                            colName = legalized;
                            builderSupplier.get().addColumnNameMapping(parquetColumnName, colName);
                        } else {
                            colName = parquetColumnName;
                        }
                    }
                    Optional<ColumnTypeInfo> columnTypeInfo = Optional.ofNullable(nonDefaultTypeColumns.get(colName));
                    colDef.name = colName;
                    colDef.dhSpecialType = columnTypeInfo.flatMap(ColumnTypeInfo::specialType).orElse(null);
                    Optional<String> codecInfo = columnTypeInfo.flatMap(ColumnTypeInfo::codec);
                    String codecName = codecInfo.map(CodecInfo::codecName).orElse(null);
                    String codecArgs = codecInfo.flatMap(CodecInfo::codecArg).orElse(null);
                    colDef.codecType = codecInfo.map(CodecInfo::dataType).orElse(null);
                    if (codecName != null && !codecName.isEmpty()) {
                        builderSupplier.get().addColumnCodec(colName, codecName, codecArgs);
                    }
                    boolean bl = colDef.isArray = column.getMaxRepetitionLevel() > 0;
                    if (colDef.codecType != null && !colDef.codecType.isEmpty()) {
                        colDef.codecComponentType = codecInfo.flatMap(CodecInfo::componentType).orElse(null);
                        consumer.accept(colDef);
                        continue;
                    }
                    if (logicalTypeAnnotation != null) break block22;
                    colDef.noLogicalType = true;
                    PrimitiveType.PrimitiveTypeName typeName = primitiveType.getPrimitiveTypeName();
                    switch (typeName) {
                        case BOOLEAN: {
                            colDef.baseType = Boolean.TYPE;
                            break;
                        }
                        case INT32: {
                            colDef.baseType = Integer.TYPE;
                            break;
                        }
                        case INT64: {
                            colDef.baseType = Long.TYPE;
                            break;
                        }
                        case INT96: {
                            colDef.baseType = Instant.class;
                            break;
                        }
                        case DOUBLE: {
                            colDef.baseType = Double.TYPE;
                            break;
                        }
                        case FLOAT: {
                            colDef.baseType = Float.TYPE;
                            break;
                        }
                        case BINARY: 
                        case FIXED_LEN_BYTE_ARRAY: {
                            if (colDef.dhSpecialType != null) {
                                if (colDef.dhSpecialType == ColumnTypeInfo.SpecialType.StringSet) {
                                    colDef.baseType = null;
                                    colDef.isArray = true;
                                    break;
                                }
                                throw new UncheckedDeephavenException("BINARY or FIXED_LEN_BYTE_ARRAY type " + column.getPrimitiveType() + " for column " + Arrays.toString(column.getPath()) + " with unknown special type " + colDef.dhSpecialType);
                            }
                            if (codecName == null || codecName.isEmpty()) {
                                String string = codecArgs = typeName == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY ? Integer.toString(primitiveType.getTypeLength()) : null;
                                if (readInstructions.isLegacyParquet()) {
                                    colDef.baseType = String.class;
                                    codecName = UTF8StringAsByteArrayCodec.class.getName();
                                } else {
                                    colDef.baseType = Byte.TYPE;
                                    colDef.isArray = true;
                                    codecName = SimpleByteArrayCodec.class.getName();
                                }
                                builderSupplier.get().addColumnCodec(colName, codecName, codecArgs);
                                break;
                            }
                            break block23;
                        }
                        default: {
                            throw new UncheckedDeephavenException("Unhandled type " + column.getPrimitiveType() + " for column " + Arrays.toString(column.getPath()));
                        }
                    }
                    break block23;
                }
                colDef.baseType = (Class)logicalTypeAnnotation.accept(visitor).orElseThrow(() -> {
                    String logicalTypeString = (String)errorString.getValue();
                    String msg = "Unable to read column " + Arrays.toString(column.getPath()) + ": ";
                    msg = msg + (String)(logicalTypeString != null ? logicalTypeString + " not supported" : "no mappable logical type annotation found");
                    return new UncheckedDeephavenException(msg);
                });
            }
            consumer.accept(colDef);
        }
        return instructionsBuilder.getValue() == null ? readInstructions : ((ParquetInstructions.Builder)instructionsBuilder.getValue()).build();
    }

    public static Pair<List<ColumnDefinition<?>>, ParquetInstructions> convertSchema(@NotNull MessageType schema, @NotNull Map<String, String> keyValueMetadata, @NotNull ParquetInstructions readInstructionsIn) {
        ArrayList cols = new ArrayList();
        ColumnDefinitionConsumer colConsumer = ParquetSchemaReader.makeSchemaReaderConsumer(cols);
        return new Pair(cols, (Object)ParquetSchemaReader.readParquetSchema(schema, keyValueMetadata, readInstructionsIn, colConsumer, (colName, takenNames) -> NameValidator.legalizeColumnName((String)colName, s -> s.replace(" ", "_"), (Set)takenNames)));
    }

    private static ColumnDefinitionConsumer makeSchemaReaderConsumer(ArrayList<ColumnDefinition<?>> colsOut) {
        return parquetColDef -> {
            void var2_4;
            ColumnDefinition colDef;
            if (parquetColDef.baseType == Boolean.TYPE) {
                Class<Boolean> clazz = Boolean.class;
            } else {
                Class<?> clazz = parquetColDef.baseType;
            }
            if (parquetColDef.codecType != null && !parquetColDef.codecType.isEmpty()) {
                Class<?> clazz = parquetColDef.codecComponentType != null && !parquetColDef.codecComponentType.isEmpty() ? ParquetSchemaReader.loadClass(parquetColDef.name, "codecComponentType", parquetColDef.codecComponentType) : null;
                Class<?> dataType = ParquetSchemaReader.loadClass(parquetColDef.name, "codecType", parquetColDef.codecType);
                colDef = ColumnDefinition.fromGenericType((String)parquetColDef.name, dataType, clazz);
            } else if (parquetColDef.dhSpecialType != null) {
                if (parquetColDef.dhSpecialType == ColumnTypeInfo.SpecialType.StringSet) {
                    colDef = ColumnDefinition.fromGenericType((String)parquetColDef.name, StringSet.class, null);
                } else {
                    if (parquetColDef.dhSpecialType != ColumnTypeInfo.SpecialType.Vector) throw new UncheckedDeephavenException("Unhandled dbSpecialType=" + parquetColDef.dhSpecialType);
                    Class clazz = (Class)VECTOR_TYPE_MAP.get((Class)var2_4);
                    colDef = clazz != null ? ColumnDefinition.fromGenericType((String)parquetColDef.name, (Class)clazz, (Class)var2_4) : ColumnDefinition.fromGenericType((String)parquetColDef.name, ObjectVector.class, (Class)var2_4);
                }
            } else if (parquetColDef.isArray) {
                if (var2_4 == Byte.TYPE && parquetColDef.noLogicalType) {
                    colDef = ColumnDefinition.fromGenericType((String)parquetColDef.name, byte[].class, Byte.TYPE);
                } else {
                    void var4_7 = var2_4;
                    Class<?> dataType = Array.newInstance(var4_7, 0).getClass();
                    colDef = ColumnDefinition.fromGenericType((String)parquetColDef.name, dataType, (Class)var4_7);
                }
            } else {
                colDef = ColumnDefinition.fromGenericType((String)parquetColDef.name, (Class)var2_4, null);
            }
            colsOut.add(colDef);
        };
    }

    private static Class<?> loadClass(String colName, String desc, String className) {
        try {
            return ClassUtil.lookupClass((String)className);
        }
        catch (ClassNotFoundException e) {
            throw new UncheckedDeephavenException("Column " + colName + " with " + desc + "=" + className + " that can't be found in classloader");
        }
    }

    private static LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<Class<?>> getVisitor(final Map<String, ColumnTypeInfo> nonDefaultTypeColumns, final MutableObject<String> errorString, final MutableObject<ColumnDescriptor> currentColumn) {
        return new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<Class<?>>(){

            public Optional<Class<?>> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation stringLogicalType) {
                ColumnTypeInfo.SpecialType specialType;
                ColumnDescriptor column = (ColumnDescriptor)currentColumn.getValue();
                String columnName = column.getPath()[0];
                ColumnTypeInfo columnTypeInfo = (ColumnTypeInfo)nonDefaultTypeColumns.get(columnName);
                ColumnTypeInfo.SpecialType specialType2 = specialType = columnTypeInfo == null ? null : (ColumnTypeInfo.SpecialType)columnTypeInfo.specialType().orElse(null);
                if (specialType != null) {
                    if (specialType == ColumnTypeInfo.SpecialType.StringSet) {
                        return Optional.of(StringSet.class);
                    }
                    if (specialType != ColumnTypeInfo.SpecialType.Vector) {
                        throw new UncheckedDeephavenException("Type " + column.getPrimitiveType() + " for column " + Arrays.toString(column.getPath()) + " with unknown or incompatible special type " + specialType);
                    }
                }
                return Optional.of(String.class);
            }

            public Optional<Class<?>> visit(LogicalTypeAnnotation.MapLogicalTypeAnnotation mapLogicalType) {
                errorString.setValue((Object)"MapLogicalType");
                return Optional.empty();
            }

            public Optional<Class<?>> visit(LogicalTypeAnnotation.ListLogicalTypeAnnotation listLogicalType) {
                errorString.setValue((Object)"ListLogicalType");
                return Optional.empty();
            }

            public Optional<Class<?>> visit(LogicalTypeAnnotation.EnumLogicalTypeAnnotation enumLogicalType) {
                errorString.setValue((Object)"EnumLogicalType");
                return Optional.empty();
            }

            public Optional<Class<?>> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType) {
                if (decimalLogicalType.getPrecision() == 1 && decimalLogicalType.getScale() == 0) {
                    return Optional.of(BigInteger.class);
                }
                return Optional.of(BigDecimal.class);
            }

            public Optional<Class<?>> visit(LogicalTypeAnnotation.DateLogicalTypeAnnotation dateLogicalType) {
                return Optional.of(LocalDate.class);
            }

            public Optional<Class<?>> visit(LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeLogicalType) {
                return Optional.of(LocalTime.class);
            }

            public Optional<Class<?>> visit(LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalType) {
                switch (timestampLogicalType.getUnit()) {
                    case MILLIS: 
                    case MICROS: 
                    case NANOS: {
                        return timestampLogicalType.isAdjustedToUTC() ? Optional.of(Instant.class) : Optional.of(LocalDateTime.class);
                    }
                }
                errorString.setValue((Object)("TimestampLogicalType, isAdjustedToUTC=" + timestampLogicalType.isAdjustedToUTC() + ", unit=" + timestampLogicalType.getUnit()));
                return Optional.empty();
            }

            public Optional<Class<?>> visit(LogicalTypeAnnotation.IntLogicalTypeAnnotation intLogicalType) {
                if (intLogicalType.isSigned()) {
                    switch (intLogicalType.getBitWidth()) {
                        case 64: {
                            return Optional.of(Long.TYPE);
                        }
                        case 32: {
                            return Optional.of(Integer.TYPE);
                        }
                        case 16: {
                            return Optional.of(Short.TYPE);
                        }
                        case 8: {
                            return Optional.of(Byte.TYPE);
                        }
                    }
                } else {
                    switch (intLogicalType.getBitWidth()) {
                        case 8: 
                        case 16: {
                            return Optional.of(Character.TYPE);
                        }
                        case 32: {
                            return Optional.of(Long.TYPE);
                        }
                    }
                }
                errorString.setValue((Object)("IntLogicalType, isSigned=" + intLogicalType.isSigned() + ", bitWidth=" + intLogicalType.getBitWidth()));
                return Optional.empty();
            }

            public Optional<Class<?>> visit(LogicalTypeAnnotation.JsonLogicalTypeAnnotation jsonLogicalType) {
                errorString.setValue((Object)"JsonLogicalType");
                return Optional.empty();
            }

            public Optional<Class<?>> visit(LogicalTypeAnnotation.BsonLogicalTypeAnnotation bsonLogicalType) {
                errorString.setValue((Object)"BsonLogicalType");
                return Optional.empty();
            }

            public Optional<Class<?>> visit(LogicalTypeAnnotation.UUIDLogicalTypeAnnotation uuidLogicalType) {
                errorString.setValue((Object)"UUIDLogicalType");
                return Optional.empty();
            }

            public Optional<Class<?>> visit(LogicalTypeAnnotation.IntervalLogicalTypeAnnotation intervalLogicalType) {
                errorString.setValue((Object)"IntervalLogicalType");
                return Optional.empty();
            }

            public Optional<Class<?>> visit(LogicalTypeAnnotation.MapKeyValueTypeAnnotation mapKeyValueLogicalType) {
                errorString.setValue((Object)"MapKeyValueType");
                return Optional.empty();
            }
        };
    }

    public static final class ParquetMessageDefinition {
        public String name;
        public Class<?> baseType;
        public ColumnTypeInfo.SpecialType dhSpecialType;
        public boolean noLogicalType;
        public boolean isArray;
        public String codecType;
        public String codecComponentType;

        void reset() {
            this.name = null;
            this.baseType = null;
            this.dhSpecialType = null;
            this.noLogicalType = false;
            this.isArray = false;
            this.codecType = null;
            this.codecComponentType = null;
        }
    }

    @FunctionalInterface
    public static interface ColumnDefinitionConsumer {
        public void accept(ParquetMessageDefinition var1);
    }
}

