/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table;

import io.deephaven.api.SortColumn;
import io.deephaven.base.FileUtils;
import io.deephaven.engine.liveness.LivenessScopeStack;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.TrackingRowSet;
import io.deephaven.engine.table.BasicDataIndex;
import io.deephaven.engine.table.ColumnDefinition;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.DataIndexTransformer;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.engine.table.impl.SortedColumnsAttribute;
import io.deephaven.engine.table.impl.indexer.DataIndexer;
import io.deephaven.engine.table.impl.select.FormulaColumn;
import io.deephaven.engine.table.impl.select.NullSelectColumn;
import io.deephaven.engine.table.impl.select.SourceColumn;
import io.deephaven.parquet.base.ColumnWriter;
import io.deephaven.parquet.base.NullParquetMetadataFileWriter;
import io.deephaven.parquet.base.ParquetFileWriter;
import io.deephaven.parquet.base.ParquetMetadataFileWriter;
import io.deephaven.parquet.base.RowGroupWriter;
import io.deephaven.parquet.table.DictionarySizeExceededException;
import io.deephaven.parquet.table.MappedSchema;
import io.deephaven.parquet.table.ParquetCacheTags;
import io.deephaven.parquet.table.ParquetInstructions;
import io.deephaven.parquet.table.TypeInfos;
import io.deephaven.parquet.table.metadata.CodecInfo;
import io.deephaven.parquet.table.metadata.ColumnTypeInfo;
import io.deephaven.parquet.table.metadata.DataIndexInfo;
import io.deephaven.parquet.table.metadata.SortColumnInfo;
import io.deephaven.parquet.table.metadata.TableInfo;
import io.deephaven.parquet.table.transfer.ArrayAndVectorTransfer;
import io.deephaven.parquet.table.transfer.StringDictionary;
import io.deephaven.parquet.table.transfer.TransferObject;
import io.deephaven.stringset.StringSet;
import io.deephaven.util.SafeCloseable;
import io.deephaven.util.annotations.VisibleForTesting;
import io.deephaven.util.channel.SeekableChannelsProviderLoader;
import io.deephaven.vector.Vector;
import java.io.File;
import java.io.IOException;
import java.nio.IntBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.HeapByteBufferAllocator;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParquetTableWriter {
    public static final String GROUPING_KEY_COLUMN_NAME = "dh_key";
    public static final String GROUPING_BEGIN_POS_COLUMN_NAME = "dh_begin_pos";
    public static final String GROUPING_END_POS_COLUMN_NAME = "dh_end_pos";
    public static final String INDEX_ROW_SET_COLUMN_NAME = "dh_row_set";

    static void write(@NotNull Table t, @NotNull TableDefinition definition, @NotNull ParquetInstructions writeInstructions, @NotNull String destFilePath, @NotNull String destFilePathForMetadata, @NotNull Map<String, String> incomingMeta, @Nullable List<IndexWritingInfo> indexInfoList, @NotNull ParquetMetadataFileWriter metadataFileWriter, @NotNull Map<String, Map<ParquetCacheTags, Object>> computedCache) throws IOException {
        if (t.isRefreshing()) {
            t.getUpdateGraph().checkInitiateSerialTableOperation();
        }
        TableInfo.Builder tableInfoBuilder = TableInfo.builder();
        ArrayList<File> cleanupFiles = null;
        try {
            List sortedColumns;
            if (indexInfoList != null) {
                cleanupFiles = new ArrayList<File>(indexInfoList.size());
                Path destDirPath = new File(destFilePath).getAbsoluteFile().getParentFile().toPath();
                for (IndexWritingInfo info : indexInfoList) {
                    try (SafeCloseable ignored = t.isRefreshing() ? LivenessScopeStack.open() : null;){
                        BasicDataIndex dataIndex = Optional.ofNullable(DataIndexer.getDataIndex((Table)t, info.indexColumnNames)).or(() -> Optional.of(DataIndexer.getOrCreateDataIndex((Table)t, info.indexColumnNames))).get().transform(DataIndexTransformer.builder().invertRowSet((RowSet)t.getRowSet()).build());
                        Table indexTable = (Table)dataIndex.table().sort(info.indexColumnNames.toArray(new String[0]));
                        TableInfo.Builder indexTableInfoBuilder = TableInfo.builder().addSortingColumns((SortColumnInfo[])info.indexColumnNames.stream().map(cn -> SortColumnInfo.of(cn, SortColumnInfo.SortDirection.Ascending)).toArray(SortColumnInfo[]::new));
                        cleanupFiles.add(info.destFile);
                        tableInfoBuilder.addDataIndexes(DataIndexInfo.of(destDirPath.relativize(info.destFileForMetadata.toPath()).toString(), info.parquetColumnNames));
                        ParquetInstructions writeInstructionsToUse = INDEX_ROW_SET_COLUMN_NAME.equals(dataIndex.rowSetColumnName()) ? writeInstructions : new ParquetInstructions.Builder(writeInstructions).addColumnNameMapping(INDEX_ROW_SET_COLUMN_NAME, dataIndex.rowSetColumnName()).build();
                        ParquetTableWriter.write(indexTable, indexTable.getDefinition(), writeInstructionsToUse, info.destFile.getAbsolutePath(), info.destFileForMetadata.getAbsolutePath(), Collections.emptyMap(), indexTableInfoBuilder, (ParquetMetadataFileWriter)NullParquetMetadataFileWriter.INSTANCE, computedCache);
                    }
                }
            }
            if (!(sortedColumns = SortedColumnsAttribute.getSortedColumns((Table)t)).isEmpty()) {
                tableInfoBuilder.addSortingColumns(SortColumnInfo.of((SortColumn)sortedColumns.get(0)));
            }
            ParquetTableWriter.write(t, definition, writeInstructions, destFilePath, destFilePathForMetadata, incomingMeta, tableInfoBuilder, metadataFileWriter, computedCache);
        }
        catch (Exception e) {
            if (cleanupFiles != null) {
                for (File cleanupFile : cleanupFiles) {
                    try {
                        cleanupFile.delete();
                    }
                    catch (Exception exception) {}
                }
            }
            throw e;
        }
    }

    static void write(@NotNull Table table, @NotNull TableDefinition definition, @NotNull ParquetInstructions writeInstructions, @NotNull String destFilePath, @NotNull String destFilePathForMetadata, @NotNull Map<String, String> tableMeta, @NotNull TableInfo.Builder tableInfoBuilder, @NotNull ParquetMetadataFileWriter metadataFileWriter, @NotNull Map<String, Map<ParquetCacheTags, Object>> computedCache) throws IOException {
        try (SafeCloseable ignored = LivenessScopeStack.open();){
            Table t = ParquetTableWriter.pretransformTable(table, definition);
            TrackingRowSet tableRowSet = t.getRowSet();
            Map columnSourceMap = t.getColumnSourceMap();
            ParquetFileWriter parquetFileWriter = ParquetTableWriter.getParquetFileWriter(computedCache, definition, (RowSet)tableRowSet, columnSourceMap, destFilePath, destFilePathForMetadata, writeInstructions, tableMeta, tableInfoBuilder, metadataFileWriter);
            ParquetTableWriter.write(t, writeInstructions, parquetFileWriter, computedCache);
        }
    }

    private static void write(@NotNull Table table, @NotNull ParquetInstructions writeInstructions, @NotNull ParquetFileWriter parquetFileWriter, @NotNull Map<String, Map<ParquetCacheTags, Object>> computedCache) throws IOException {
        TrackingRowSet tableRowSet = table.getRowSet();
        Map columnSourceMap = table.getColumnSourceMap();
        long nRows = table.size();
        if (nRows > 0L) {
            RowGroupWriter rowGroupWriter = parquetFileWriter.addRowGroup(nRows);
            for (Map.Entry nameToSource : columnSourceMap.entrySet()) {
                String columnName = (String)nameToSource.getKey();
                ColumnSource columnSource = (ColumnSource)nameToSource.getValue();
                try {
                    ParquetTableWriter.writeColumnSource((RowSet)tableRowSet, writeInstructions, rowGroupWriter, computedCache, columnName, columnSource);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Failed to write column " + columnName, e);
                }
            }
        }
        parquetFileWriter.close();
    }

    static MessageType getSchemaForTable(@NotNull Table table, @NotNull TableDefinition definition, @NotNull ParquetInstructions instructions) {
        if (definition.numColumns() == 0) {
            throw new IllegalArgumentException("Table definition must have at least one column");
        }
        Table pretransformTable = ParquetTableWriter.pretransformTable(table, definition);
        return MappedSchema.create(new HashMap<String, Map<ParquetCacheTags, Object>>(), definition, (RowSet)pretransformTable.getRowSet(), pretransformTable.getColumnSourceMap(), instructions, new ColumnDefinition[0]).getParquetSchema();
    }

    @NotNull
    private static Table pretransformTable(@NotNull Table table, @NotNull TableDefinition definition) {
        ArrayList<FormulaColumn> updateViewColumnsTransform = new ArrayList<FormulaColumn>();
        ArrayList<Object> viewColumnsTransform = new ArrayList<Object>();
        for (ColumnDefinition column : definition.getColumns()) {
            String colName = column.getName();
            if (table.hasColumns(new String[]{colName})) {
                if (StringSet.class.isAssignableFrom(column.getDataType())) {
                    updateViewColumnsTransform.add(FormulaColumn.createFormulaColumn((String)colName, (String)("isNull(" + colName + ") ? null : " + colName + ".values()")));
                }
                viewColumnsTransform.add(new SourceColumn(colName));
                continue;
            }
            viewColumnsTransform.add(new NullSelectColumn(column.getDataType(), column.getComponentType(), colName));
        }
        Table transformed = table;
        if (!viewColumnsTransform.isEmpty()) {
            transformed = (Table)transformed.view(viewColumnsTransform);
        }
        if (!updateViewColumnsTransform.isEmpty()) {
            transformed = (Table)transformed.updateView(updateViewColumnsTransform);
        }
        return transformed;
    }

    @NotNull
    private static ParquetFileWriter getParquetFileWriter(@NotNull Map<String, Map<ParquetCacheTags, Object>> computedCache, @NotNull TableDefinition definition, @NotNull RowSet tableRowSet, @NotNull Map<String, ? extends ColumnSource<?>> columnSourceMap, @NotNull String destFilePath, @NotNull String destFilePathForMetadata, @NotNull ParquetInstructions writeInstructions, @NotNull Map<String, String> tableMeta, @NotNull TableInfo.Builder tableInfoBuilder, @NotNull ParquetMetadataFileWriter metadataFileWriter) throws IOException {
        MappedSchema mappedSchema = MappedSchema.create(computedCache, definition, tableRowSet, columnSourceMap, writeInstructions, new ColumnDefinition[0]);
        for (ColumnDefinition column : definition.getColumns()) {
            String colName = column.getName();
            ColumnTypeInfo.Builder columnInfoBuilder = ColumnTypeInfo.builder().columnName(writeInstructions.getParquetColumnNameFromColumnNameOrDefault(colName));
            boolean usedColumnInfo = false;
            Pair<String, String> codecData = TypeInfos.getCodecAndArgs(column, writeInstructions);
            if (codecData != null) {
                CodecInfo.Builder codecInfoBuilder = CodecInfo.builder();
                codecInfoBuilder.codecName((String)codecData.getLeft());
                String codecArg = (String)codecData.getRight();
                if (codecArg != null) {
                    codecInfoBuilder.codecArg(codecArg);
                }
                codecInfoBuilder.dataType(column.getDataType().getName());
                Class componentType = column.getComponentType();
                if (componentType != null) {
                    codecInfoBuilder.componentType(componentType.getName());
                }
                columnInfoBuilder.codec(codecInfoBuilder.build());
                usedColumnInfo = true;
            }
            if (StringSet.class.isAssignableFrom(column.getDataType())) {
                columnInfoBuilder.specialType(ColumnTypeInfo.SpecialType.StringSet);
                usedColumnInfo = true;
            } else if (Vector.class.isAssignableFrom(column.getDataType())) {
                columnInfoBuilder.specialType(ColumnTypeInfo.SpecialType.Vector);
                usedColumnInfo = true;
            }
            if (!usedColumnInfo) continue;
            tableInfoBuilder.addColumnTypes(columnInfoBuilder.build());
        }
        HashMap<String, String> extraMetaData = new HashMap<String, String>(tableMeta);
        extraMetaData.put("deephaven", tableInfoBuilder.build().serializeToJSON());
        return new ParquetFileWriter(destFilePath, destFilePathForMetadata, SeekableChannelsProviderLoader.getInstance().fromServiceLoader(FileUtils.convertToURI((String)destFilePath, (boolean)false), null), writeInstructions.getTargetPageSize(), (ByteBufferAllocator)new HeapByteBufferAllocator(), mappedSchema.getParquetSchema(), writeInstructions.getCompressionCodecName(), extraMetaData, metadataFileWriter);
    }

    @VisibleForTesting
    static <DATA_TYPE> void writeColumnSource(@NotNull RowSet tableRowSet, @NotNull ParquetInstructions writeInstructions, @NotNull RowGroupWriter rowGroupWriter, @NotNull Map<String, Map<ParquetCacheTags, Object>> computedCache, @NotNull String columnName, @NotNull ColumnSource<DATA_TYPE> columnSource) throws IllegalAccessException, IOException {
        try (ColumnWriter columnWriter = rowGroupWriter.addColumn(writeInstructions.getParquetColumnNameFromColumnNameOrDefault(columnName));){
            boolean usedDictionary = false;
            if (String.class.equals((Object)columnSource.getType()) || String.class.equals((Object)columnSource.getComponentType())) {
                usedDictionary = ParquetTableWriter.tryEncodeDictionary(tableRowSet, writeInstructions, columnWriter, columnName, columnSource);
            }
            if (!usedDictionary) {
                ParquetTableWriter.encodePlain(tableRowSet, writeInstructions, columnWriter, computedCache, columnName, columnSource);
            }
        }
    }

    private static IntBuffer makeCopy(IntBuffer orig) {
        IntBuffer copy = IntBuffer.allocate(orig.capacity());
        copy.put(orig).flip();
        return copy;
    }

    private static <DATA_TYPE> boolean tryEncodeDictionary(@NotNull RowSet tableRowSet, @NotNull ParquetInstructions writeInstructions, @NotNull ColumnWriter columnWriter, @NotNull String columnName, @NotNull ColumnSource<DATA_TYPE> columnSource) throws IOException {
        boolean useDictionaryHint = writeInstructions.useDictionary(columnName);
        int maxKeys = useDictionaryHint ? Integer.MAX_VALUE : writeInstructions.getMaximumDictionaryKeys();
        int maxDictSize = useDictionaryHint ? Integer.MAX_VALUE : writeInstructions.getMaximumDictionarySize();
        int NULL_POS = Integer.MIN_VALUE;
        Statistics statistics = columnWriter.getStats();
        ArrayList<IntBuffer> pageBuffers = new ArrayList<IntBuffer>();
        ArrayList<IntBuffer> lengthsBuffers = new ArrayList<IntBuffer>();
        BitSet pageBufferHasNull = new BitSet();
        boolean isArrayOrVector = columnSource.getComponentType() != null;
        StringDictionary dictionary = new StringDictionary(maxKeys, maxDictSize, statistics, Integer.MIN_VALUE);
        int curPage = 0;
        try (TransferObject<IntBuffer> transferObject = TransferObject.createDictEncodedStringTransfer(tableRowSet, columnSource, writeInstructions.getTargetPageSize(), dictionary);){
            boolean done;
            do {
                transferObject.transferOnePageToBuffer();
                boolean bl = done = !transferObject.hasMoreDataToBuffer();
                if (done) {
                    pageBuffers.add(transferObject.getBuffer());
                    if (isArrayOrVector) {
                        lengthsBuffers.add(transferObject.getRepeatCount());
                    }
                } else {
                    pageBuffers.add(ParquetTableWriter.makeCopy(transferObject.getBuffer()));
                    if (isArrayOrVector) {
                        lengthsBuffers.add(ParquetTableWriter.makeCopy(transferObject.getRepeatCount()));
                    }
                }
                if (transferObject.pageHasNull()) {
                    pageBufferHasNull.set(curPage);
                }
                ++curPage;
            } while (!done);
        }
        catch (DictionarySizeExceededException ignored) {
            columnWriter.resetStats();
            return false;
        }
        if (dictionary.getKeyCount() == 0 && !pageBufferHasNull.isEmpty()) {
            columnWriter.resetStats();
            return false;
        }
        columnWriter.addDictionaryPage((Object)dictionary.getEncodedKeys(), dictionary.getKeyCount());
        PrimitiveType fakeObject = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("fake");
        Statistics tmpStats = Statistics.createStats((Type)fakeObject);
        int numPages = pageBuffers.size();
        for (int i = 0; i < numPages; ++i) {
            IntBuffer pageBuffer = (IntBuffer)pageBuffers.get(i);
            if (isArrayOrVector) {
                columnWriter.addVectorPage((Object)pageBuffer, (IntBuffer)lengthsBuffers.get(i), pageBuffer.remaining(), tmpStats);
                continue;
            }
            boolean pageHasNulls = pageBufferHasNull.get(i);
            if (pageHasNulls) {
                columnWriter.addPage((Object)pageBuffer, pageBuffer.remaining(), tmpStats);
                continue;
            }
            columnWriter.addPageNoNulls((Object)pageBuffer, pageBuffer.remaining(), tmpStats);
        }
        statistics.incrementNumNulls(tmpStats.getNumNulls());
        return true;
    }

    private static <DATA_TYPE> void encodePlain(@NotNull RowSet tableRowSet, @NotNull ParquetInstructions writeInstructions, @NotNull ColumnWriter columnWriter, @NotNull Map<String, Map<ParquetCacheTags, Object>> computedCache, @NotNull String columnName, @NotNull ColumnSource<DATA_TYPE> columnSource) throws IOException {
        try (TransferObject<?> transferObject = TransferObject.create(tableRowSet, writeInstructions, computedCache, columnName, columnSource);){
            Statistics statistics = columnWriter.getStats();
            boolean writeVectorPages = transferObject instanceof ArrayAndVectorTransfer;
            do {
                int numValuesBuffered = transferObject.transferOnePageToBuffer();
                if (writeVectorPages) {
                    columnWriter.addVectorPage(transferObject.getBuffer(), transferObject.getRepeatCount(), numValuesBuffered, statistics);
                    continue;
                }
                columnWriter.addPage(transferObject.getBuffer(), numValuesBuffered, statistics);
            } while (transferObject.hasMoreDataToBuffer());
        }
    }

    static class IndexWritingInfo {
        final List<String> indexColumnNames;
        final String[] parquetColumnNames;
        final File destFileForMetadata;
        final File destFile;

        IndexWritingInfo(List<String> indexColumnNames, String[] parquetColumnNames, File destFileForMetadata, File destFile) {
            this.indexColumnNames = indexColumnNames;
            this.parquetColumnNames = parquetColumnNames;
            this.destFileForMetadata = destFileForMetadata.getAbsoluteFile();
            this.destFile = destFile.getAbsoluteFile();
        }
    }
}

