/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table;

import io.deephaven.UncheckedDeephavenException;
import io.deephaven.base.FileUtils;
import io.deephaven.base.Pair;
import io.deephaven.base.verify.Require;
import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.engine.liveness.LivenessScopeStack;
import io.deephaven.engine.primitive.iterator.CloseableIterator;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.TrackingRowSet;
import io.deephaven.engine.table.ColumnDefinition;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.DataIndex;
import io.deephaven.engine.table.PartitionedTable;
import io.deephaven.engine.table.PartitionedTableFactory;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.engine.table.impl.PartitionAwareSourceTable;
import io.deephaven.engine.table.impl.SimpleSourceTable;
import io.deephaven.engine.table.impl.SourceTableComponentFactory;
import io.deephaven.engine.table.impl.indexer.DataIndexer;
import io.deephaven.engine.table.impl.locations.ImmutableTableLocationKey;
import io.deephaven.engine.table.impl.locations.TableDataException;
import io.deephaven.engine.table.impl.locations.TableLocationProvider;
import io.deephaven.engine.table.impl.locations.impl.KnownLocationKeyFinder;
import io.deephaven.engine.table.impl.locations.impl.PollingTableLocationProvider;
import io.deephaven.engine.table.impl.locations.impl.StandaloneTableKey;
import io.deephaven.engine.table.impl.locations.impl.TableLocationFactory;
import io.deephaven.engine.table.impl.locations.impl.TableLocationKeyFinder;
import io.deephaven.engine.table.impl.locations.util.PartitionFormatter;
import io.deephaven.engine.table.impl.locations.util.TableDataRefreshService;
import io.deephaven.engine.table.impl.sources.regioned.RegionedTableComponentFactoryImpl;
import io.deephaven.engine.updategraph.UpdateGraph;
import io.deephaven.engine.updategraph.UpdateSourceRegistrar;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.parquet.base.NullParquetMetadataFileWriter;
import io.deephaven.parquet.base.ParquetMetadataFileWriter;
import io.deephaven.parquet.base.ParquetUtils;
import io.deephaven.parquet.table.ParquetCacheTags;
import io.deephaven.parquet.table.ParquetInstructions;
import io.deephaven.parquet.table.ParquetMetadataFileWriterImpl;
import io.deephaven.parquet.table.ParquetSchemaReader;
import io.deephaven.parquet.table.ParquetTableWriter;
import io.deephaven.parquet.table.TypeInfos;
import io.deephaven.parquet.table.layout.ParquetFlatPartitionedLayout;
import io.deephaven.parquet.table.layout.ParquetKeyValuePartitionedLayout;
import io.deephaven.parquet.table.layout.ParquetMetadataFileLayout;
import io.deephaven.parquet.table.location.ParquetTableLocationFactory;
import io.deephaven.parquet.table.location.ParquetTableLocationKey;
import io.deephaven.util.SafeCloseable;
import io.deephaven.util.annotations.VisibleForTesting;
import io.deephaven.util.type.TypeUtils;
import io.deephaven.vector.ObjectVector;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.parquet.schema.MessageType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParquetTools {
    private static final int MAX_PARTITIONING_LEVELS_INFERENCE = 32;
    private static final Collection<List<String>> EMPTY_INDEXES = Collections.emptyList();
    private static final Logger log = LoggerFactory.getLogger(ParquetTools.class);
    public static final ParquetInstructions UNCOMPRESSED = ParquetInstructions.builder().setCompressionCodecName("UNCOMPRESSED").build();
    @Deprecated
    public static final ParquetInstructions LZ4 = ParquetInstructions.builder().setCompressionCodecName("LZ4").build();
    public static final ParquetInstructions LZ4_RAW = ParquetInstructions.builder().setCompressionCodecName("LZ4_RAW").build();
    public static final ParquetInstructions LZO = ParquetInstructions.builder().setCompressionCodecName("LZO").build();
    public static final ParquetInstructions GZIP = ParquetInstructions.builder().setCompressionCodecName("GZIP").build();
    public static final ParquetInstructions ZSTD = ParquetInstructions.builder().setCompressionCodecName("ZSTD").build();
    public static final ParquetInstructions SNAPPY = ParquetInstructions.builder().setCompressionCodecName("SNAPPY").build();
    public static final ParquetInstructions BROTLI = ParquetInstructions.builder().setCompressionCodecName("BROTLI").build();
    public static final ParquetInstructions LEGACY = ParquetInstructions.builder().setIsLegacyParquet(true).build();

    private ParquetTools() {
    }

    public static Table readTable(@NotNull String source) {
        return ParquetTools.readTable(source, ParquetInstructions.EMPTY);
    }

    public static Table readTable(@NotNull String source, @NotNull ParquetInstructions readInstructions) {
        boolean isDirectory = !ParquetUtils.isParquetFile((String)source);
        URI sourceURI = FileUtils.convertToURI((String)source, (boolean)isDirectory);
        if (readInstructions.getFileLayout().isPresent()) {
            switch (readInstructions.getFileLayout().get()) {
                case SINGLE_FILE: {
                    return ParquetTools.readSingleFileTable(sourceURI, readInstructions);
                }
                case FLAT_PARTITIONED: {
                    return ParquetTools.readFlatPartitionedTable(sourceURI, readInstructions);
                }
                case KV_PARTITIONED: {
                    return ParquetTools.readKeyValuePartitionedTable(sourceURI, readInstructions);
                }
                case METADATA_PARTITIONED: {
                    return ParquetTools.readPartitionedTableWithMetadata(sourceURI, readInstructions);
                }
            }
        }
        if ("file".equals(sourceURI.getScheme())) {
            return ParquetTools.readTableFromFileUri(sourceURI, readInstructions);
        }
        if (source.endsWith("/_metadata") || source.endsWith("/_common_metadata")) {
            throw new UnsupportedOperationException("We currently do not support reading parquet metadata files from non local storage");
        }
        if (!isDirectory) {
            return ParquetTools.readSingleFileTable(sourceURI, readInstructions);
        }
        return ParquetTools.readKeyValuePartitionedTable(sourceURI, readInstructions);
    }

    public static void writeTable(@NotNull Table sourceTable, @NotNull String destination) {
        ParquetTools.writeTables(new Table[]{sourceTable}, new String[]{destination}, ParquetInstructions.EMPTY.withTableDefinition(sourceTable.getDefinition()));
    }

    public static void writeTable(@NotNull Table sourceTable, @NotNull String destination, @NotNull ParquetInstructions writeInstructions) {
        ParquetTools.writeTables(new Table[]{sourceTable}, new String[]{destination}, ParquetTools.ensureTableDefinition(writeInstructions, sourceTable.getDefinition(), false));
    }

    private static ParquetInstructions ensureTableDefinition(@NotNull ParquetInstructions instructions, @NotNull TableDefinition definition, boolean validateExisting) {
        if (instructions.getTableDefinition().isEmpty()) {
            return instructions.withTableDefinition(definition);
        }
        if (validateExisting && !instructions.getTableDefinition().get().equals((Object)definition)) {
            throw new IllegalArgumentException("Table definition provided in instructions does not match the one provided in the method call");
        }
        return instructions;
    }

    private static File getShadowFile(File destFile) {
        return new File(destFile.getParent(), ".NEW_" + destFile.getName());
    }

    @VisibleForTesting
    static File getBackupFile(File destFile) {
        return new File(destFile.getParent(), ".OLD_" + destFile.getName());
    }

    private static String minusParquetSuffix(@NotNull String s) {
        if (s.endsWith(".parquet")) {
            return s.substring(0, s.length() - ".parquet".length());
        }
        return s;
    }

    @VisibleForTesting
    static String getRelativeIndexFilePath(@NotNull File tableDest, String ... columnNames) {
        String columns = String.join((CharSequence)",", columnNames);
        return String.format(".dh_metadata%sindexes%s%s%sindex_%s_%s", File.separator, File.separator, columns, File.separator, columns, tableDest.getName());
    }

    @VisibleForTesting
    public static String legacyGroupingFileName(@NotNull File tableDest, @NotNull String columnName) {
        String prefix = ParquetTools.minusParquetSuffix(tableDest.getName());
        return prefix + "_" + columnName + "_grouping.parquet";
    }

    private static void deleteBackupFile(@NotNull File destFile) {
        if (!ParquetTools.deleteBackupFileNoExcept(destFile)) {
            throw new UncheckedDeephavenException(String.format("Failed to delete backup file at %s", ParquetTools.getBackupFile(destFile).getAbsolutePath()));
        }
    }

    private static boolean deleteBackupFileNoExcept(@NotNull File destFile) {
        File backupDestFile = ParquetTools.getBackupFile(destFile);
        if (backupDestFile.exists() && !backupDestFile.delete()) {
            log.error().append((CharSequence)"Error in deleting backup file at path ").append((CharSequence)backupDestFile.getAbsolutePath()).endl();
            return false;
        }
        return true;
    }

    private static void installShadowFile(@NotNull File destFile, @NotNull File shadowDestFile) {
        File backupDestFile = ParquetTools.getBackupFile(destFile);
        if (destFile.exists() && !destFile.renameTo(backupDestFile)) {
            throw new UncheckedDeephavenException(String.format("Failed to install shadow file at %s because a file already exists at the path which couldn't be renamed to %s", destFile.getAbsolutePath(), backupDestFile.getAbsolutePath()));
        }
        if (!shadowDestFile.renameTo(destFile)) {
            throw new UncheckedDeephavenException(String.format("Failed to install shadow file at %s because couldn't rename temporary shadow file from %s to %s", destFile.getAbsolutePath(), shadowDestFile.getAbsolutePath(), destFile.getAbsolutePath()));
        }
    }

    private static void rollbackFile(@NotNull File destFile) {
        File backupDestFile = ParquetTools.getBackupFile(destFile);
        File shadowDestFile = ParquetTools.getShadowFile(destFile);
        destFile.renameTo(shadowDestFile);
        backupDestFile.renameTo(destFile);
    }

    private static File prepareDestinationFileLocation(@NotNull File destination) {
        File parent;
        if (!(destination = destination.getAbsoluteFile()).getPath().endsWith(".parquet")) {
            throw new UncheckedDeephavenException(String.format("Destination %s does not end in %s extension", destination, ".parquet"));
        }
        if (destination.exists()) {
            if (destination.isDirectory()) {
                throw new UncheckedDeephavenException(String.format("Destination %s exists and is a directory", destination));
            }
            if (!destination.canWrite()) {
                throw new UncheckedDeephavenException(String.format("Destination %s exists but is not writable", destination));
            }
            return null;
        }
        File firstParent = destination.getParentFile();
        if (firstParent.isDirectory()) {
            if (firstParent.canWrite()) {
                return null;
            }
            throw new UncheckedDeephavenException(String.format("Destination %s has non writable parent directory", destination));
        }
        File firstCreated = firstParent;
        for (parent = destination.getParentFile(); parent != null && !parent.exists(); parent = parent.getParentFile()) {
            firstCreated = parent;
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Can't find any existing parent directory for destination path: %s", destination));
        }
        if (!parent.isDirectory()) {
            throw new IllegalArgumentException(String.format("Existing parent file %s of %s is not a directory", parent, destination));
        }
        if (!firstParent.mkdirs()) {
            throw new UncheckedDeephavenException("Couldn't (re)create destination directory " + firstParent);
        }
        return firstCreated;
    }

    private static List<ParquetTableWriter.IndexWritingInfo> indexInfoBuilderHelper(@NotNull Collection<List<String>> indexColumns, @NotNull String[][] parquetColumnNameArr, @NotNull File destFile) {
        Require.eq((int)indexColumns.size(), (String)"indexColumns.size", (int)parquetColumnNameArr.length, (String)"parquetColumnNameArr.length");
        int numIndexes = indexColumns.size();
        ArrayList<ParquetTableWriter.IndexWritingInfo> indexInfoList = new ArrayList<ParquetTableWriter.IndexWritingInfo>(numIndexes);
        int gci = 0;
        for (List<String> indexColumnNames : indexColumns) {
            String[] parquetColumnNames = parquetColumnNameArr[gci];
            String indexFileRelativePath = ParquetTools.getRelativeIndexFilePath(destFile, parquetColumnNames);
            File indexFile = new File(destFile.getParent(), indexFileRelativePath);
            ParquetTools.prepareDestinationFileLocation(indexFile);
            ParquetTools.deleteBackupFile(indexFile);
            File shadowIndexFile = ParquetTools.getShadowFile(indexFile);
            ParquetTableWriter.IndexWritingInfo info = new ParquetTableWriter.IndexWritingInfo(indexColumnNames, parquetColumnNames, indexFile, shadowIndexFile);
            indexInfoList.add(info);
            ++gci;
        }
        return indexInfoList;
    }

    public static void writeKeyValuePartitionedTable(@NotNull Table sourceTable, @NotNull String destinationDir, @NotNull ParquetInstructions writeInstructions) {
        Collection indexColumns = writeInstructions.getIndexColumns().orElseGet(() -> ParquetTools.indexedColumnNames(sourceTable));
        TableDefinition definition = writeInstructions.getTableDefinition().orElse(sourceTable.getDefinition());
        List partitioningColumns = definition.getPartitioningColumns();
        if (partitioningColumns.isEmpty()) {
            throw new IllegalArgumentException("Table must have partitioning columns to write partitioned data");
        }
        String[] partitioningColNames = (String[])partitioningColumns.stream().map(ColumnDefinition::getName).toArray(String[]::new);
        PartitionedTable partitionedTable = sourceTable.partitionBy(partitioningColNames);
        TableDefinition keyTableDefinition = TableDefinition.of((Collection)partitioningColumns);
        TableDefinition leafDefinition = ParquetTools.getNonKeyTableDefinition(new HashSet<String>(Arrays.asList(partitioningColNames)), definition);
        ParquetTools.writeKeyValuePartitionedTableImpl(partitionedTable, keyTableDefinition, leafDefinition, destinationDir, writeInstructions, indexColumns, Optional.of(sourceTable));
    }

    public static void writeKeyValuePartitionedTable(@NotNull PartitionedTable partitionedTable, @NotNull String destinationDir, @NotNull ParquetInstructions writeInstructions) {
        TableDefinition leafDefinition;
        TableDefinition keyTableDefinition;
        Collection<List<String>> indexColumns = writeInstructions.getIndexColumns().orElse(EMPTY_INDEXES);
        if (writeInstructions.getTableDefinition().isEmpty()) {
            keyTableDefinition = ParquetTools.getKeyTableDefinition(partitionedTable.keyColumnNames(), partitionedTable.table().getDefinition());
            leafDefinition = ParquetTools.getNonKeyTableDefinition(partitionedTable.keyColumnNames(), partitionedTable.constituentDefinition());
        } else {
            TableDefinition definition = writeInstructions.getTableDefinition().get();
            keyTableDefinition = ParquetTools.getKeyTableDefinition(partitionedTable.keyColumnNames(), definition);
            leafDefinition = ParquetTools.getNonKeyTableDefinition(partitionedTable.keyColumnNames(), definition);
        }
        ParquetTools.writeKeyValuePartitionedTableImpl(partitionedTable, keyTableDefinition, leafDefinition, destinationDir, writeInstructions, indexColumns, Optional.empty());
    }

    private static void writeKeyValuePartitionedTableImpl(@NotNull PartitionedTable partitionedTable, @NotNull TableDefinition keyTableDefinition, @NotNull TableDefinition leafDefinition, @NotNull String destinationRoot, @NotNull ParquetInstructions writeInstructions, @NotNull Collection<List<String>> indexColumns, @NotNull Optional<Table> sourceTable) {
        if (leafDefinition.numColumns() == 0) {
            throw new IllegalArgumentException("Cannot write a partitioned parquet table without any non-partitioning columns");
        }
        String baseName = writeInstructions.baseNameForPartitionedParquetData();
        boolean hasPartitionInName = baseName.contains("{partitions}");
        boolean hasIndexInName = baseName.contains("{i}");
        boolean hasUUIDInName = baseName.contains("{uuid}");
        if (!(partitionedTable.uniqueKeys() || hasIndexInName || hasUUIDInName)) {
            throw new IllegalArgumentException("Cannot write a partitioned parquet table with non-unique keys without {i} or {uuid} in the base name because there can be multiple partitions with the same key values");
        }
        String[] partitioningColumnNames = (String[])partitionedTable.keyColumnNames().toArray(String[]::new);
        Table withGroupConstituents = (Table)partitionedTable.table().groupBy(partitioningColumnNames);
        ArrayList partitionStringsList = new ArrayList();
        long numRows = withGroupConstituents.size();
        for (long i = 0L; i < numRows; ++i) {
            partitionStringsList.add(new ArrayList(partitioningColumnNames.length));
        }
        Arrays.stream(partitioningColumnNames).forEach(columnName -> {
            PartitionFormatter partitionFormatter = PartitionFormatter.getFormatterForType((Class)withGroupConstituents.getColumnSource(columnName).getType());
            try (CloseableIterator valueIterator = withGroupConstituents.columnIterator(columnName);){
                int row = 0;
                while (valueIterator.hasNext()) {
                    String partitioningValue = partitionFormatter.format(valueIterator.next());
                    ((List)partitionStringsList.get(row)).add(columnName + "=" + partitioningValue);
                    ++row;
                }
            }
        });
        ArrayList<Table> partitionedData = new ArrayList<Table>();
        ArrayList<File> destinations = new ArrayList<File>();
        try (CloseableIterator constituentIterator = withGroupConstituents.objectColumnIterator(partitionedTable.constituentColumnName());){
            int row = 0;
            while (constituentIterator.hasNext()) {
                ObjectVector constituentVector = (ObjectVector)constituentIterator.next();
                List partitionStrings = (List)partitionStringsList.get(row);
                File relativePath = new File(destinationRoot, String.join((CharSequence)File.separator, partitionStrings));
                int count = 0;
                for (Table constituent : constituentVector) {
                    Object filename = baseName;
                    if (hasPartitionInName) {
                        filename = baseName.replace("{partitions}", String.join((CharSequence)"_", partitionStrings));
                    }
                    if (hasIndexInName) {
                        filename = ((String)filename).replace("{i}", Integer.toString(count));
                    }
                    if (hasUUIDInName) {
                        filename = ((String)filename).replace("{uuid}", UUID.randomUUID().toString());
                    }
                    filename = (String)filename + ".parquet";
                    destinations.add(new File(relativePath, (String)filename));
                    partitionedData.add(constituent);
                    ++count;
                }
                ++row;
            }
        }
        MessageType partitioningColumnsSchema = writeInstructions.generateMetadataFiles() ? ParquetTableWriter.getSchemaForTable(partitionedTable.table(), keyTableDefinition, writeInstructions) : null;
        Table[] partitionedDataArray = (Table[])partitionedData.toArray(Table[]::new);
        try (SafeCloseable ignored = LivenessScopeStack.open();){
            Map<String, Map<ParquetCacheTags, Object>> computedCache = ParquetTools.buildComputedCache(() -> sourceTable.orElseGet(() -> ((PartitionedTable)partitionedTable).merge()), leafDefinition);
            List<DataIndex> dataIndexes = ParquetTools.addIndexesToTables(partitionedDataArray, indexColumns);
            ParquetTools.writeTablesImpl(partitionedDataArray, leafDefinition, writeInstructions, (File[])destinations.toArray(File[]::new), indexColumns, partitioningColumnsSchema, new File(destinationRoot), computedCache);
            if (dataIndexes != null) {
                dataIndexes.clear();
            }
        }
    }

    @Nullable
    private static List<DataIndex> addIndexesToTables(@NotNull Table[] tables, @NotNull Collection<List<String>> indexColumns) {
        if (indexColumns.isEmpty()) {
            return null;
        }
        ArrayList<DataIndex> dataIndexes = new ArrayList<DataIndex>(indexColumns.size() * tables.length);
        for (Table table : tables) {
            for (List<String> indexCols : indexColumns) {
                dataIndexes.add(DataIndexer.getOrCreateDataIndex((Table)table, indexCols));
            }
        }
        return dataIndexes;
    }

    private static TableDefinition getKeyTableDefinition(@NotNull Collection<String> keyColumnNames, @NotNull TableDefinition definition) {
        ArrayList<ColumnDefinition> keyColumnDefinitions = new ArrayList<ColumnDefinition>(keyColumnNames.size());
        for (String keyColumnName : keyColumnNames) {
            ColumnDefinition keyColumnDef = definition.getColumn(keyColumnName);
            if (keyColumnDef == null) continue;
            keyColumnDefinitions.add(keyColumnDef);
        }
        return TableDefinition.of(keyColumnDefinitions);
    }

    private static TableDefinition getNonKeyTableDefinition(@NotNull Collection<String> keyColumnNames, @NotNull TableDefinition definition) {
        Collection nonKeyColumnDefinition = definition.getColumns().stream().filter(columnDefinition -> !keyColumnNames.contains(columnDefinition.getName())).collect(Collectors.toList());
        return TableDefinition.of((Collection)nonKeyColumnDefinition);
    }

    private static Map<String, Map<ParquetCacheTags, Object>> buildComputedCache(@NotNull Supplier<Table> mergedTableSupplier, @NotNull TableDefinition definition) {
        HashMap<String, Map<ParquetCacheTags, Object>> computedCache = new HashMap<String, Map<ParquetCacheTags, Object>>();
        Table mergedTable = null;
        List leafColumnDefinitions = definition.getColumns();
        for (ColumnDefinition columnDefinition : leafColumnDefinitions) {
            if (columnDefinition.getDataType() != BigDecimal.class) continue;
            if (mergedTable == null) {
                mergedTable = mergedTableSupplier.get();
            }
            String columnName = columnDefinition.getName();
            ColumnSource bigDecimalColumnSource = mergedTable.getColumnSource(columnName);
            TypeInfos.getPrecisionAndScale(computedCache, columnName, (RowSet)mergedTable.getRowSet(), () -> bigDecimalColumnSource);
        }
        return computedCache;
    }

    private static void writeTablesImpl(@NotNull Table[] sources, @NotNull TableDefinition definition, @NotNull ParquetInstructions writeInstructions, @NotNull File[] destinations, @NotNull Collection<List<String>> indexColumns, @Nullable MessageType partitioningColumnsSchema, @Nullable File metadataRootDir, @NotNull Map<String, Map<ParquetCacheTags, Object>> computedCache) {
        Object metadataFileWriter;
        Require.eq((int)sources.length, (String)"sources.length", (int)destinations.length, (String)"destinations.length");
        if (writeInstructions.getFileLayout().isPresent()) {
            throw new UnsupportedOperationException("File layout is not supported for writing parquet files, use the appropriate API");
        }
        if (definition.numColumns() == 0) {
            throw new TableDataException("Cannot write a parquet table with zero columns");
        }
        Arrays.stream(destinations).forEach(ParquetTools::deleteBackupFile);
        File[] shadowDestFiles = (File[])Arrays.stream(destinations).map(ParquetTools::getShadowFile).toArray(File[]::new);
        File[] firstCreatedDirs = (File[])Arrays.stream(shadowDestFiles).map(ParquetTools::prepareDestinationFileLocation).toArray(File[]::new);
        if (writeInstructions.generateMetadataFiles()) {
            if (metadataRootDir == null) {
                throw new IllegalArgumentException("Metadata root directory must be set when writing metadata files");
            }
            metadataFileWriter = new ParquetMetadataFileWriterImpl(metadataRootDir, destinations, partitioningColumnsSchema);
        } else {
            metadataFileWriter = NullParquetMetadataFileWriter.INSTANCE;
        }
        ArrayList<File> shadowFiles = new ArrayList<File>();
        ArrayList<File> destFiles = new ArrayList<File>();
        try {
            File shadowCommonMetadataFile;
            File commonMetadataDestFile;
            File shadowMetadataFile;
            File metadataDestFile;
            ArrayList<List<ParquetTableWriter.IndexWritingInfo>> indexInfoLists;
            if (indexColumns.isEmpty()) {
                indexInfoLists = null;
                for (int tableIdx = 0; tableIdx < sources.length; ++tableIdx) {
                    shadowFiles.add(shadowDestFiles[tableIdx]);
                    Table source = sources[tableIdx];
                    ParquetTableWriter.write(source, definition, writeInstructions, shadowDestFiles[tableIdx].getPath(), destinations[tableIdx].getPath(), Collections.emptyMap(), (List<ParquetTableWriter.IndexWritingInfo>)null, (ParquetMetadataFileWriter)metadataFileWriter, computedCache);
                }
            } else {
                indexInfoLists = new ArrayList<List<ParquetTableWriter.IndexWritingInfo>>(sources.length);
                String[][] parquetColumnNameArr = (String[][])indexColumns.stream().map(columns -> (String[])columns.stream().map(writeInstructions::getParquetColumnNameFromColumnNameOrDefault).toArray(String[]::new)).toArray(x$0 -> new String[x$0][]);
                for (int tableIdx = 0; tableIdx < sources.length; ++tableIdx) {
                    File tableDestination = destinations[tableIdx];
                    List<ParquetTableWriter.IndexWritingInfo> indexInfoList = ParquetTools.indexInfoBuilderHelper(indexColumns, parquetColumnNameArr, tableDestination);
                    indexInfoLists.add(indexInfoList);
                    shadowFiles.add(shadowDestFiles[tableIdx]);
                    indexInfoList.forEach(item -> shadowFiles.add(item.destFile));
                    Table sourceTable = sources[tableIdx];
                    ParquetTableWriter.write(sourceTable, definition, writeInstructions, shadowDestFiles[tableIdx].getPath(), tableDestination.getPath(), Collections.emptyMap(), indexInfoList, (ParquetMetadataFileWriter)metadataFileWriter, computedCache);
                }
            }
            if (writeInstructions.generateMetadataFiles()) {
                metadataDestFile = new File(metadataRootDir, "_metadata");
                shadowMetadataFile = ParquetTools.getShadowFile(metadataDestFile);
                shadowFiles.add(shadowMetadataFile);
                commonMetadataDestFile = new File(metadataRootDir, "_common_metadata");
                shadowCommonMetadataFile = ParquetTools.getShadowFile(commonMetadataDestFile);
                shadowFiles.add(shadowCommonMetadataFile);
                metadataFileWriter.writeMetadataFiles(shadowMetadataFile.getAbsolutePath(), shadowCommonMetadataFile.getAbsolutePath());
            } else {
                shadowCommonMetadataFile = null;
                commonMetadataDestFile = null;
                shadowMetadataFile = null;
                metadataDestFile = null;
            }
            for (int tableIdx = 0; tableIdx < sources.length; ++tableIdx) {
                destFiles.add(destinations[tableIdx]);
                ParquetTools.installShadowFile(destinations[tableIdx], shadowDestFiles[tableIdx]);
                if (indexInfoLists == null) continue;
                List indexInfoList = (List)indexInfoLists.get(tableIdx);
                for (ParquetTableWriter.IndexWritingInfo info : indexInfoList) {
                    File indexDestFile = info.destFileForMetadata;
                    File shadowIndexFile = info.destFile;
                    destFiles.add(indexDestFile);
                    ParquetTools.installShadowFile(indexDestFile, shadowIndexFile);
                }
            }
            if (writeInstructions.generateMetadataFiles()) {
                destFiles.add(metadataDestFile);
                ParquetTools.installShadowFile(metadataDestFile, shadowMetadataFile);
                destFiles.add(commonMetadataDestFile);
                ParquetTools.installShadowFile(commonMetadataDestFile, shadowCommonMetadataFile);
            }
        }
        catch (Exception e) {
            for (File file : destFiles) {
                ParquetTools.rollbackFile(file);
            }
            for (File file : shadowFiles) {
                file.delete();
            }
            for (File firstCreatedDir : firstCreatedDirs) {
                if (firstCreatedDir == null) continue;
                log.error().append((CharSequence)"Error in table writing, cleaning up potentially incomplete table destination path starting from ").append((CharSequence)firstCreatedDir.getAbsolutePath()).append((Throwable)e).endl();
                FileUtils.deleteRecursivelyOnNFS((File)firstCreatedDir);
            }
            throw new UncheckedDeephavenException("Error writing parquet tables", (Throwable)e);
        }
        destFiles.forEach(ParquetTools::deleteBackupFileNoExcept);
    }

    @NotNull
    private static Collection<List<String>> indexedColumnNames(@NotNull @NotNull Table @NotNull [] sources) {
        if (sources.length == 0) {
            return EMPTY_INDEXES;
        }
        return ParquetTools.indexedColumnNames(sources[0]);
    }

    @NotNull
    private static Collection<List<String>> indexedColumnNames(@NotNull Table source) {
        DataIndexer dataIndexer = DataIndexer.existingOf((TrackingRowSet)source.getRowSet());
        if (dataIndexer == null) {
            return EMPTY_INDEXES;
        }
        List dataIndexes = dataIndexer.dataIndexes(true);
        if (dataIndexes.isEmpty()) {
            return EMPTY_INDEXES;
        }
        Map nameToColumn = source.getColumnSourceMap();
        Map<ColumnSource, String> columnToName = nameToColumn.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        ArrayList indexesToWrite = new ArrayList();
        dataIndexes.forEach(di -> {
            Map keyColumnNamesByIndexedColumn = di.keyColumnNamesByIndexedColumn();
            List keyColumnNames = keyColumnNamesByIndexedColumn.keySet().stream().map(columnToName::get).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
            if (keyColumnNames.size() == keyColumnNamesByIndexedColumn.size()) {
                indexesToWrite.add(keyColumnNames);
            }
        });
        return Collections.unmodifiableCollection(indexesToWrite);
    }

    public static void writeTables(@NotNull Table[] sources, @NotNull String[] destinations, @NotNull ParquetInstructions writeInstructions) {
        File metadataRootDir;
        int idx;
        TableDefinition definition;
        if (sources.length == 0) {
            throw new IllegalArgumentException("No source tables provided for writing");
        }
        if (sources.length != destinations.length) {
            throw new IllegalArgumentException("Number of sources and destinations must match");
        }
        if (writeInstructions.getTableDefinition().isPresent()) {
            definition = writeInstructions.getTableDefinition().get();
        } else {
            TableDefinition firstDefinition = sources[0].getDefinition();
            for (idx = 1; idx < sources.length; ++idx) {
                if (firstDefinition.equals((Object)sources[idx].getDefinition())) continue;
                throw new IllegalArgumentException("Table definition must be provided when writing multiple tables with different definitions");
            }
            definition = firstDefinition;
        }
        File[] destinationFiles = new File[destinations.length];
        for (idx = 0; idx < destinations.length; ++idx) {
            URI destinationURI = FileUtils.convertToURI((String)destinations[idx], (boolean)false);
            if (!"file".equals(destinationURI.getScheme())) {
                throw new IllegalArgumentException("Only file URI scheme is supported for writing parquet files, foundnon-file URI: " + destinations[idx]);
            }
            destinationFiles[idx] = new File(destinationURI);
        }
        if (writeInstructions.generateMetadataFiles()) {
            String firstDestinationDir = destinationFiles[0].getAbsoluteFile().getParentFile().getAbsolutePath();
            for (int i = 1; i < destinations.length; ++i) {
                if (firstDestinationDir.equals(destinationFiles[i].getParentFile().getAbsolutePath())) continue;
                throw new IllegalArgumentException("All destination files must be in the same directory for  generating metadata files");
            }
            metadataRootDir = new File(firstDestinationDir);
        } else {
            metadataRootDir = null;
        }
        Collection indexColumns = writeInstructions.getIndexColumns().orElseGet(() -> ParquetTools.indexedColumnNames(sources));
        Map<String, Map<ParquetCacheTags, Object>> computedCache = ParquetTools.buildComputedCache(() -> PartitionedTableFactory.ofTables((TableDefinition)definition, (Table[])sources).merge(), definition);
        ParquetTools.writeTablesImpl(sources, definition, writeInstructions, destinationFiles, indexColumns, null, metadataRootDir, computedCache);
    }

    @VisibleForTesting
    public static void deleteTable(String path) {
        FileUtils.deleteRecursivelyOnNFS((File)new File(path));
    }

    private static Table readTableFromFileUri(@NotNull URI source, @NotNull ParquetInstructions instructions) {
        Path sourcePath = Path.of(source);
        if (!Files.exists(sourcePath, new LinkOption[0])) {
            throw new TableDataException("Source file " + source + " does not exist");
        }
        String sourceFileName = sourcePath.getFileName().toString();
        BasicFileAttributes sourceAttr = ParquetTools.readAttributes(sourcePath);
        if (sourceAttr.isRegularFile()) {
            if (sourceFileName.endsWith(".parquet")) {
                return ParquetTools.readSingleFileTable(source, instructions);
            }
            URI parentDirURI = FileUtils.convertToURI((Path)sourcePath.getParent(), (boolean)true);
            if (sourceFileName.equals("_metadata")) {
                return ParquetTools.readPartitionedTableWithMetadata(parentDirURI, instructions);
            }
            if (sourceFileName.equals("_common_metadata")) {
                return ParquetTools.readPartitionedTableWithMetadata(parentDirURI, instructions);
            }
            throw new TableDataException("Source file " + source + " does not appear to be a parquet file or metadata file");
        }
        if (sourceAttr.isDirectory()) {
            Path firstEntryPath;
            Path metadataPath = sourcePath.resolve("_metadata");
            if (Files.exists(metadataPath, new LinkOption[0])) {
                return ParquetTools.readPartitionedTableWithMetadata(source, instructions);
            }
            try (DirectoryStream<Path> sourceStream = Files.newDirectoryStream(sourcePath, ParquetTools::ignoreDotFiles);){
                Iterator<Path> entryIterator = sourceStream.iterator();
                if (!entryIterator.hasNext()) {
                    throw new TableDataException("Source directory " + source + " is empty");
                }
                firstEntryPath = entryIterator.next();
            }
            catch (IOException e) {
                throw new TableDataException("Error reading source directory " + source, (Throwable)e);
            }
            String firstEntryFileName = firstEntryPath.getFileName().toString();
            BasicFileAttributes firstEntryAttr = ParquetTools.readAttributes(firstEntryPath);
            if (firstEntryAttr.isDirectory() && firstEntryFileName.contains("=")) {
                return ParquetTools.readKeyValuePartitionedTable(source, instructions);
            }
            if (firstEntryAttr.isRegularFile() && firstEntryFileName.endsWith(".parquet")) {
                return ParquetTools.readFlatPartitionedTable(source, instructions);
            }
            throw new TableDataException("No recognized Parquet table layout found in " + source);
        }
        throw new TableDataException("Source " + source + " is neither a directory nor a regular file");
    }

    private static boolean ignoreDotFiles(Path path) {
        String filename = path.getFileName().toString();
        return !filename.isEmpty() && filename.charAt(0) != '.';
    }

    private static BasicFileAttributes readAttributes(@NotNull Path path) {
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException e) {
            throw new TableDataException("Failed to read " + path + " file attributes", (Throwable)e);
        }
    }

    private static Table readTable(@NotNull ParquetTableLocationKey tableLocationKey, @NotNull ParquetInstructions readInstructions) {
        if (readInstructions.isRefreshing()) {
            throw new IllegalArgumentException("Unable to have a refreshing single parquet file");
        }
        TableDefinition tableDefinition = readInstructions.getTableDefinition().orElseThrow(() -> new IllegalArgumentException("Table definition must be provided"));
        ParquetTools.verifyFileLayout(readInstructions, ParquetInstructions.ParquetFileLayout.SINGLE_FILE);
        PollingTableLocationProvider locationProvider = new PollingTableLocationProvider(StandaloneTableKey.getInstance(), (TableLocationKeyFinder)new KnownLocationKeyFinder((ImmutableTableLocationKey[])new ParquetTableLocationKey[]{tableLocationKey}), (TableLocationFactory)new ParquetTableLocationFactory(readInstructions), null);
        return new SimpleSourceTable(tableDefinition.getWritable(), "Read single parquet file from " + tableLocationKey.getURI(), (SourceTableComponentFactory)RegionedTableComponentFactoryImpl.INSTANCE, (TableLocationProvider)locationProvider, null);
    }

    public static Table readTable(@NotNull TableLocationKeyFinder<ParquetTableLocationKey> locationKeyFinder, @NotNull ParquetInstructions readInstructions) {
        UpdateGraph updateSourceRegistrar;
        TableDataRefreshService refreshService;
        String description;
        TableLocationKeyFinder<ParquetTableLocationKey> keyFinder;
        ParquetInstructions useInstructions;
        TableDefinition definition;
        TableLocationKeyFinder<ParquetTableLocationKey> useLocationKeyFinder;
        if (readInstructions.getTableDefinition().isEmpty()) {
            KnownLocationKeyFinder<ParquetTableLocationKey> inferenceKeys = ParquetTools.toKnownKeys(locationKeyFinder);
            Pair<TableDefinition, ParquetInstructions> inference = ParquetTools.infer(inferenceKeys, readInstructions);
            useLocationKeyFinder = readInstructions.isRefreshing() ? locationKeyFinder : inferenceKeys;
            definition = (TableDefinition)inference.getFirst();
            useInstructions = (ParquetInstructions)inference.getSecond();
        } else {
            definition = readInstructions.getTableDefinition().get();
            useInstructions = readInstructions;
            useLocationKeyFinder = locationKeyFinder;
        }
        if (useInstructions.isRefreshing()) {
            keyFinder = useLocationKeyFinder;
            description = "Read refreshing parquet files with " + keyFinder;
            refreshService = TableDataRefreshService.getSharedRefreshService();
            updateSourceRegistrar = ExecutionContext.getContext().getUpdateGraph();
        } else {
            keyFinder = ParquetTools.toKnownKeys(useLocationKeyFinder);
            description = "Read multiple parquet files with " + keyFinder;
            refreshService = null;
            updateSourceRegistrar = null;
        }
        return new PartitionAwareSourceTable(definition, description, (SourceTableComponentFactory)RegionedTableComponentFactoryImpl.INSTANCE, (TableLocationProvider)new PollingTableLocationProvider(StandaloneTableKey.getInstance(), keyFinder, (TableLocationFactory)new ParquetTableLocationFactory(useInstructions), refreshService), (UpdateSourceRegistrar)updateSourceRegistrar);
    }

    private static Pair<TableDefinition, ParquetInstructions> infer(KnownLocationKeyFinder<ParquetTableLocationKey> inferenceKeys, ParquetInstructions readInstructions) {
        ParquetTableLocationKey lastKey = inferenceKeys.getLastKey().orElse(null);
        if (lastKey == null) {
            throw new IllegalArgumentException("Unable to infer schema for a partitioned parquet table when there are no initial parquet files");
        }
        Pair<List<ColumnDefinition<?>>, ParquetInstructions> schemaInfo = ParquetSchemaReader.convertSchema(lastKey.getFileReader().getSchema(), lastKey.getMetadata().getFileMetaData().getKeyValueMetaData(), readInstructions);
        Set partitionKeys = lastKey.getPartitionKeys();
        ArrayList<ColumnDefinition> allColumns = new ArrayList<ColumnDefinition>(partitionKeys.size() + ((List)schemaInfo.getFirst()).size());
        for (String partitionKey : partitionKeys) {
            Comparable partitionValue = lastKey.getPartitionValue(partitionKey);
            if (partitionValue == null) {
                throw new IllegalArgumentException(String.format("Last location key %s has null partition value at partition key %s", new Object[]{lastKey, partitionKey}));
            }
            Class dataType = partitionValue.getClass();
            if (dataType != Boolean.class) {
                dataType = TypeUtils.getUnboxedTypeIfBoxed(partitionValue.getClass());
            }
            allColumns.add(ColumnDefinition.fromGenericType((String)partitionKey, (Class)dataType, null, (ColumnDefinition.ColumnType)ColumnDefinition.ColumnType.Partitioning));
        }
        List columnDefinitionsFromParquetFile = (List)schemaInfo.getFirst();
        columnDefinitionsFromParquetFile.stream().filter(columnDefinition -> !partitionKeys.contains(columnDefinition.getName())).forEach(allColumns::add);
        return new Pair((Object)TableDefinition.of(allColumns), (Object)((ParquetInstructions)schemaInfo.getSecond()));
    }

    private static KnownLocationKeyFinder<ParquetTableLocationKey> toKnownKeys(TableLocationKeyFinder<ParquetTableLocationKey> keyFinder) {
        return keyFinder instanceof KnownLocationKeyFinder ? (KnownLocationKeyFinder)keyFinder : KnownLocationKeyFinder.copyFrom(keyFinder, Comparator.naturalOrder());
    }

    private static Table readPartitionedTableWithMetadata(@NotNull URI sourceURI, @NotNull ParquetInstructions readInstructions) {
        if (!"file".equals(sourceURI.getScheme())) {
            throw new UnsupportedOperationException("Reading metadata files from non local storage is not supported");
        }
        ParquetTools.verifyFileLayout(readInstructions, ParquetInstructions.ParquetFileLayout.METADATA_PARTITIONED);
        if (readInstructions.getTableDefinition().isPresent()) {
            throw new UnsupportedOperationException("Detected table definition inside read instructions, reading metadata files with custom table definition is currently not supported");
        }
        File sourceFile = new File(sourceURI);
        String fileName = sourceFile.getName();
        File directory = fileName.equals("_metadata") || fileName.equals("_common_metadata") ? sourceFile.getParentFile() : sourceFile;
        ParquetMetadataFileLayout layout = new ParquetMetadataFileLayout(directory, readInstructions);
        return ParquetTools.readTable(layout, ParquetTools.ensureTableDefinition(layout.getInstructions(), layout.getTableDefinition(), true));
    }

    private static void verifyFileLayout(@NotNull ParquetInstructions readInstructions, @NotNull ParquetInstructions.ParquetFileLayout expectedLayout) {
        if (readInstructions.getFileLayout().isPresent() && readInstructions.getFileLayout().get() != expectedLayout) {
            throw new IllegalArgumentException("File layout provided in read instructions (=" + readInstructions.getFileLayout() + ") does not match with " + expectedLayout);
        }
    }

    private static Table readKeyValuePartitionedTable(@NotNull URI directoryUri, @NotNull ParquetInstructions readInstructions) {
        ParquetTools.verifyFileLayout(readInstructions, ParquetInstructions.ParquetFileLayout.KV_PARTITIONED);
        if (readInstructions.getTableDefinition().isEmpty()) {
            return ParquetTools.readTable(new ParquetKeyValuePartitionedLayout(directoryUri, 32, readInstructions), readInstructions);
        }
        TableDefinition tableDefinition = readInstructions.getTableDefinition().get();
        if (tableDefinition.getColumnStream().noneMatch(ColumnDefinition::isPartitioning)) {
            throw new IllegalArgumentException("No partitioning columns");
        }
        return ParquetTools.readTable(new ParquetKeyValuePartitionedLayout(directoryUri, tableDefinition, readInstructions), readInstructions);
    }

    private static Table readFlatPartitionedTable(@NotNull URI sourceURI, @NotNull ParquetInstructions readInstructions) {
        ParquetTools.verifyFileLayout(readInstructions, ParquetInstructions.ParquetFileLayout.FLAT_PARTITIONED);
        return ParquetTools.readTable(new ParquetFlatPartitionedLayout(sourceURI, readInstructions), readInstructions);
    }

    private static Table readSingleFileTable(@NotNull URI parquetFileURI, @NotNull ParquetInstructions readInstructions) {
        ParquetTools.verifyFileLayout(readInstructions, ParquetInstructions.ParquetFileLayout.SINGLE_FILE);
        ParquetTableLocationKey locationKey = new ParquetTableLocationKey(parquetFileURI, 0, null, readInstructions);
        if (readInstructions.getTableDefinition().isPresent()) {
            return ParquetTools.readTable(locationKey, readInstructions);
        }
        KnownLocationKeyFinder inferenceKeys = new KnownLocationKeyFinder((ImmutableTableLocationKey[])new ParquetTableLocationKey[]{locationKey});
        Pair<TableDefinition, ParquetInstructions> inference = ParquetTools.infer((KnownLocationKeyFinder<ParquetTableLocationKey>)inferenceKeys, readInstructions);
        TableDefinition inferredTableDefinition = (TableDefinition)inference.getFirst();
        ParquetInstructions inferredInstructions = (ParquetInstructions)inference.getSecond();
        return ParquetTools.readTable((ParquetTableLocationKey)((Object)inferenceKeys.getFirstKey().orElseThrow()), ParquetTools.ensureTableDefinition(inferredInstructions, inferredTableDefinition, true));
    }

    @VisibleForTesting
    public static Table readParquetSchemaAndTable(@NotNull File source, @NotNull ParquetInstructions readInstructionsIn, @Nullable MutableObject<ParquetInstructions> mutableInstructionsOut) {
        URI sourceURI = FileUtils.convertToURI((File)source, (boolean)false);
        ParquetTableLocationKey tableLocationKey = new ParquetTableLocationKey(sourceURI, 0, null, readInstructionsIn);
        Pair<List<ColumnDefinition<?>>, ParquetInstructions> schemaInfo = ParquetSchemaReader.convertSchema(tableLocationKey.getFileReader().getSchema(), tableLocationKey.getMetadata().getFileMetaData().getKeyValueMetaData(), readInstructionsIn);
        TableDefinition def = TableDefinition.of((Collection)((Collection)schemaInfo.getFirst()));
        ParquetInstructions instructionsOut = ParquetTools.ensureTableDefinition((ParquetInstructions)schemaInfo.getSecond(), def, true);
        if (mutableInstructionsOut != null) {
            mutableInstructionsOut.setValue((Object)instructionsOut);
        }
        return ParquetTools.readTable(tableLocationKey, instructionsOut);
    }
}

