/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table;

import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.table.ColumnDefinition;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.impl.CodecLookup;
import io.deephaven.engine.table.impl.dataindex.RowSetCodec;
import io.deephaven.engine.util.BigDecimalUtils;
import io.deephaven.parquet.table.ParquetCacheTags;
import io.deephaven.parquet.table.ParquetInstructions;
import io.deephaven.stringset.StringSet;
import io.deephaven.util.codec.ExternalizableCodec;
import io.deephaven.util.codec.SerializableCodec;
import java.io.Externalizable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.jetbrains.annotations.NotNull;

public class TypeInfos {
    private static final TypeInfo[] TYPE_INFOS = new TypeInfo[]{IntType.INSTANCE, LongType.INSTANCE, ShortType.INSTANCE, BooleanType.INSTANCE, FloatType.INSTANCE, DoubleType.INSTANCE, CharType.INSTANCE, ByteType.INSTANCE, StringType.INSTANCE, InstantType.INSTANCE, BigIntegerType.INSTANCE, LocalDateType.INSTANCE, LocalTimeType.INSTANCE, LocalDateTimeType.INSTANCE};
    private static final Map<Class<?>, TypeInfo> BY_CLASS;

    private static Optional<TypeInfo> lookupTypeInfo(@NotNull Class<?> clazz) {
        return Optional.ofNullable(BY_CLASS.get(clazz));
    }

    private static TypeInfo lookupTypeInfo(@NotNull ColumnDefinition<?> column, @NotNull ParquetInstructions instructions) {
        if (CodecLookup.codecRequired(column) || CodecLookup.explicitCodecPresent((String)instructions.getCodecName(column.getName()))) {
            return new CodecType();
        }
        Class componentType = column.getComponentType();
        if (componentType != null) {
            return TypeInfos.lookupTypeInfo(componentType).orElseThrow(IllegalStateException::new);
        }
        Class dataType = column.getDataType();
        if (StringSet.class.isAssignableFrom(dataType)) {
            return TypeInfos.lookupTypeInfo(String.class).orElseThrow(IllegalStateException::new);
        }
        return TypeInfos.lookupTypeInfo(dataType).orElseThrow(IllegalStateException::new);
    }

    static Pair<String, String> getCodecAndArgs(@NotNull ColumnDefinition<?> columnDefinition, @NotNull ParquetInstructions instructions) {
        String colName = columnDefinition.getName();
        String codecNameFromInstructions = instructions.getCodecName(colName);
        if (CodecLookup.explicitCodecPresent((String)codecNameFromInstructions)) {
            return new ImmutablePair((Object)codecNameFromInstructions, (Object)instructions.getCodecArgs(colName));
        }
        if (!CodecLookup.codecRequired(columnDefinition)) {
            return null;
        }
        Class dataType = columnDefinition.getDataType();
        if (dataType.equals(RowSet.class)) {
            return new ImmutablePair((Object)RowSetCodec.class.getName(), null);
        }
        if (Externalizable.class.isAssignableFrom(dataType)) {
            return new ImmutablePair((Object)ExternalizableCodec.class.getName(), (Object)dataType.getName());
        }
        return new ImmutablePair((Object)SerializableCodec.class.getName(), null);
    }

    public static BigDecimalUtils.PrecisionAndScale getPrecisionAndScale(@NotNull Map<String, Map<ParquetCacheTags, Object>> computedCache, @NotNull String columnName, @NotNull RowSet rowSet, @NotNull Supplier<ColumnSource<BigDecimal>> columnSourceSupplier) {
        return (BigDecimalUtils.PrecisionAndScale)computedCache.computeIfAbsent(columnName, unusedColumnName -> new HashMap()).computeIfAbsent(ParquetCacheTags.DECIMAL_ARGS, uct -> TypeInfos.parquetCompatible(BigDecimalUtils.computePrecisionAndScale((RowSet)rowSet, (ColumnSource)((ColumnSource)columnSourceSupplier.get()))));
    }

    private static BigDecimalUtils.PrecisionAndScale parquetCompatible(BigDecimalUtils.PrecisionAndScale pas) {
        if (pas.scale > pas.precision) {
            return new BigDecimalUtils.PrecisionAndScale(pas.scale, pas.scale);
        }
        return pas;
    }

    static TypeInfo bigDecimalTypeInfo(Map<String, Map<ParquetCacheTags, Object>> computedCache, @NotNull ColumnDefinition<?> column, RowSet rowSet, Map<String, ? extends ColumnSource<?>> columnSourceMap) {
        String columnName = column.getName();
        final BigDecimalUtils.PrecisionAndScale precisionAndScale = TypeInfos.getPrecisionAndScale(computedCache, columnName, rowSet, () -> (ColumnSource)columnSourceMap.get(columnName));
        final Set<Class<BigDecimal>> clazzes = Set.of(BigDecimal.class);
        return new TypeInfo(){

            @Override
            public Set<Class<?>> getTypes() {
                return clazzes;
            }

            @Override
            public Types.PrimitiveBuilder<PrimitiveType> getBuilderImpl(boolean required, boolean repeating, Class<?> dataType) {
                return (Types.PrimitiveBuilder)TypeInfos.type(PrimitiveType.PrimitiveTypeName.BINARY, required, repeating).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)precisionAndScale.scale, (int)precisionAndScale.precision));
            }
        };
    }

    static TypeInfo getTypeInfo(Map<String, Map<ParquetCacheTags, Object>> computedCache, @NotNull ColumnDefinition<?> column, RowSet rowSet, Map<String, ? extends ColumnSource<?>> columnSourceMap, @NotNull ParquetInstructions instructions) {
        Class dataType = column.getDataType();
        if (BigDecimal.class.equals((Object)dataType)) {
            return TypeInfos.bigDecimalTypeInfo(computedCache, column, rowSet, columnSourceMap);
        }
        return TypeInfos.lookupTypeInfo(column, instructions);
    }

    private static boolean isRequired(ColumnDefinition<?> columnDefinition) {
        return false;
    }

    private static Types.PrimitiveBuilder<PrimitiveType> type(PrimitiveType.PrimitiveTypeName type, boolean required, boolean repeating) {
        return repeating ? Types.repeated((PrimitiveType.PrimitiveTypeName)type) : (required ? Types.required((PrimitiveType.PrimitiveTypeName)type) : Types.optional((PrimitiveType.PrimitiveTypeName)type));
    }

    static {
        HashMap fa = new HashMap();
        for (TypeInfo typeInfo : TYPE_INFOS) {
            for (Class<?> type : typeInfo.getTypes()) {
                fa.put(type, typeInfo);
            }
        }
        BY_CLASS = Collections.unmodifiableMap(fa);
    }

    private static class CodecType<T>
    implements TypeInfo {
        CodecType() {
        }

        @Override
        public Set<Class<?>> getTypes() {
            throw new UnsupportedOperationException("Codec types are not being mapped");
        }

        @Override
        public Types.PrimitiveBuilder<PrimitiveType> getBuilder(boolean required, boolean repeating, Class<?> dataType) {
            return TypeInfos.type(PrimitiveType.PrimitiveTypeName.BINARY, required, repeating);
        }
    }

    static interface TypeInfo {
        public Set<Class<?>> getTypes();

        default public boolean isValidFor(Class<?> clazz) {
            return this.getTypes().contains(clazz);
        }

        default public Types.PrimitiveBuilder<PrimitiveType> getBuilderImpl(boolean required, boolean repeating, Class<?> dataType) {
            throw new UnsupportedOperationException("Implement this method if using the default getBuilder()");
        }

        default public Types.PrimitiveBuilder<PrimitiveType> getBuilder(boolean required, boolean repeating, Class<?> dataType) {
            if (!this.isValidFor(dataType)) {
                throw new IllegalArgumentException("Invalid data type " + dataType);
            }
            return this.getBuilderImpl(required, repeating, dataType);
        }

        default public Type createSchemaType(@NotNull ColumnDefinition<?> columnDefinition, @NotNull ParquetInstructions instructions) {
            boolean isRepeating;
            Types.PrimitiveBuilder<PrimitiveType> builder;
            Class dataType = columnDefinition.getDataType();
            Class componentType = columnDefinition.getComponentType();
            String parquetColumnName = instructions.getParquetColumnNameFromColumnNameOrDefault(columnDefinition.getName());
            if (CodecLookup.explicitCodecPresent((String)instructions.getCodecName(columnDefinition.getName())) || CodecLookup.codecRequired(columnDefinition)) {
                builder = this.getBuilder(TypeInfos.isRequired(columnDefinition), false, dataType);
                isRepeating = false;
            } else if (componentType != null) {
                builder = this.getBuilder(TypeInfos.isRequired(columnDefinition), false, componentType);
                isRepeating = true;
            } else if (StringSet.class.isAssignableFrom(dataType)) {
                builder = this.getBuilder(TypeInfos.isRequired(columnDefinition), false, String.class);
                isRepeating = true;
            } else {
                builder = this.getBuilder(TypeInfos.isRequired(columnDefinition), false, dataType);
                isRepeating = false;
            }
            if (!isRepeating) {
                return (Type)builder.named(parquetColumnName);
            }
            return (Type)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).addField((Type)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.REPEATED).addField((Type)builder.named("item"))).named(parquetColumnName))).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).named(parquetColumnName);
        }
    }

    private static enum BigIntegerType implements TypeInfo
    {
        INSTANCE;

        private static final Set<Class<?>> clazzes;

        @Override
        public Set<Class<?>> getTypes() {
            return clazzes;
        }

        @Override
        public Types.PrimitiveBuilder<PrimitiveType> getBuilderImpl(boolean required, boolean repeating, Class<?> dataType) {
            return (Types.PrimitiveBuilder)TypeInfos.type(PrimitiveType.PrimitiveTypeName.BINARY, required, repeating).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)0, (int)1));
        }

        static {
            clazzes = Set.of(BigInteger.class);
        }
    }

    private static enum LocalTimeType implements TypeInfo
    {
        INSTANCE;

        private static final Set<Class<?>> clazzes;

        @Override
        public Set<Class<?>> getTypes() {
            return clazzes;
        }

        @Override
        public Types.PrimitiveBuilder<PrimitiveType> getBuilderImpl(boolean required, boolean repeating, Class<?> dataType) {
            return (Types.PrimitiveBuilder)TypeInfos.type(PrimitiveType.PrimitiveTypeName.INT64, required, repeating).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS));
        }

        static {
            clazzes = Set.of(LocalTime.class);
        }
    }

    private static enum LocalDateType implements TypeInfo
    {
        INSTANCE;

        private static final Set<Class<?>> clazzes;

        @Override
        public Set<Class<?>> getTypes() {
            return clazzes;
        }

        @Override
        public Types.PrimitiveBuilder<PrimitiveType> getBuilderImpl(boolean required, boolean repeating, Class<?> dataType) {
            return (Types.PrimitiveBuilder)TypeInfos.type(PrimitiveType.PrimitiveTypeName.INT32, required, repeating).as((LogicalTypeAnnotation)LogicalTypeAnnotation.dateType());
        }

        static {
            clazzes = Set.of(LocalDate.class);
        }
    }

    private static enum LocalDateTimeType implements TypeInfo
    {
        INSTANCE;

        private static final Set<Class<?>> clazzes;

        @Override
        public Set<Class<?>> getTypes() {
            return clazzes;
        }

        @Override
        public Types.PrimitiveBuilder<PrimitiveType> getBuilderImpl(boolean required, boolean repeating, Class<?> dataType) {
            return (Types.PrimitiveBuilder)TypeInfos.type(PrimitiveType.PrimitiveTypeName.INT64, required, repeating).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS));
        }

        static {
            clazzes = Set.of(LocalDateTime.class);
        }
    }

    private static enum InstantType implements TypeInfo
    {
        INSTANCE;

        private static final Set<Class<?>> clazzes;

        @Override
        public Set<Class<?>> getTypes() {
            return clazzes;
        }

        @Override
        public Types.PrimitiveBuilder<PrimitiveType> getBuilderImpl(boolean required, boolean repeating, Class<?> dataType) {
            return (Types.PrimitiveBuilder)TypeInfos.type(PrimitiveType.PrimitiveTypeName.INT64, required, repeating).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS));
        }

        static {
            clazzes = Set.of(Instant.class);
        }
    }

    private static enum StringType implements TypeInfo
    {
        INSTANCE;

        private static final Set<Class<?>> clazzes;

        @Override
        public Set<Class<?>> getTypes() {
            return clazzes;
        }

        @Override
        public Types.PrimitiveBuilder<PrimitiveType> getBuilderImpl(boolean required, boolean repeating, Class<?> dataType) {
            return (Types.PrimitiveBuilder)TypeInfos.type(PrimitiveType.PrimitiveTypeName.BINARY, required, repeating).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType());
        }

        static {
            clazzes = Set.of(String.class);
        }
    }

    private static enum ByteType implements TypeInfo
    {
        INSTANCE;

        private static final Set<Class<?>> clazzes;

        @Override
        public Set<Class<?>> getTypes() {
            return clazzes;
        }

        @Override
        public Types.PrimitiveBuilder<PrimitiveType> getBuilderImpl(boolean required, boolean repeating, Class<?> dataType) {
            return (Types.PrimitiveBuilder)TypeInfos.type(PrimitiveType.PrimitiveTypeName.INT32, required, repeating).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)8, (boolean)true));
        }

        static {
            clazzes = Set.of(Byte.TYPE, Byte.class);
        }
    }

    private static enum CharType implements TypeInfo
    {
        INSTANCE;

        private static final Set<Class<?>> clazzes;

        @Override
        public Set<Class<?>> getTypes() {
            return clazzes;
        }

        @Override
        public Types.PrimitiveBuilder<PrimitiveType> getBuilderImpl(boolean required, boolean repeating, Class<?> dataType) {
            return (Types.PrimitiveBuilder)TypeInfos.type(PrimitiveType.PrimitiveTypeName.INT32, required, repeating).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)false));
        }

        static {
            clazzes = Set.of(Character.TYPE, Character.class);
        }
    }

    private static enum DoubleType implements TypeInfo
    {
        INSTANCE;

        private static final Set<Class<?>> clazzes;

        @Override
        public Set<Class<?>> getTypes() {
            return clazzes;
        }

        @Override
        public Types.PrimitiveBuilder<PrimitiveType> getBuilderImpl(boolean required, boolean repeating, Class<?> dataType) {
            return TypeInfos.type(PrimitiveType.PrimitiveTypeName.DOUBLE, required, repeating);
        }

        static {
            clazzes = Set.of(Double.TYPE, Double.class);
        }
    }

    private static enum FloatType implements TypeInfo
    {
        INSTANCE;

        private static final Set<Class<?>> clazzes;

        @Override
        public Set<Class<?>> getTypes() {
            return clazzes;
        }

        @Override
        public Types.PrimitiveBuilder<PrimitiveType> getBuilderImpl(boolean required, boolean repeating, Class<?> dataType) {
            return TypeInfos.type(PrimitiveType.PrimitiveTypeName.FLOAT, required, repeating);
        }

        static {
            clazzes = Set.of(Float.TYPE, Float.class);
        }
    }

    private static enum BooleanType implements TypeInfo
    {
        INSTANCE;

        private static final Set<Class<?>> clazzes;

        @Override
        public Set<Class<?>> getTypes() {
            return clazzes;
        }

        @Override
        public Types.PrimitiveBuilder<PrimitiveType> getBuilderImpl(boolean required, boolean repeating, Class<?> dataType) {
            return TypeInfos.type(PrimitiveType.PrimitiveTypeName.BOOLEAN, required, repeating);
        }

        static {
            clazzes = Set.of(Boolean.TYPE, Boolean.class);
        }
    }

    private static enum ShortType implements TypeInfo
    {
        INSTANCE;

        private static final Set<Class<?>> clazzes;

        @Override
        public Set<Class<?>> getTypes() {
            return clazzes;
        }

        @Override
        public Types.PrimitiveBuilder<PrimitiveType> getBuilderImpl(boolean required, boolean repeating, Class<?> dataType) {
            return (Types.PrimitiveBuilder)TypeInfos.type(PrimitiveType.PrimitiveTypeName.INT32, required, repeating).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)true));
        }

        static {
            clazzes = Set.of(Short.TYPE, Short.class);
        }
    }

    private static enum LongType implements TypeInfo
    {
        INSTANCE;

        private static final Set<Class<?>> clazzes;

        @Override
        public Set<Class<?>> getTypes() {
            return clazzes;
        }

        @Override
        public Types.PrimitiveBuilder<PrimitiveType> getBuilderImpl(boolean required, boolean repeating, Class<?> dataType) {
            return TypeInfos.type(PrimitiveType.PrimitiveTypeName.INT64, required, repeating);
        }

        static {
            clazzes = Set.of(Long.TYPE, Long.class);
        }
    }

    private static enum IntType implements TypeInfo
    {
        INSTANCE;

        private static final Set<Class<?>> clazzes;

        @Override
        public Set<Class<?>> getTypes() {
            return clazzes;
        }

        @Override
        public Types.PrimitiveBuilder<PrimitiveType> getBuilderImpl(boolean required, boolean repeating, Class<?> dataType) {
            return (Types.PrimitiveBuilder)TypeInfos.type(PrimitiveType.PrimitiveTypeName.INT32, required, repeating).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)32, (boolean)true));
        }

        static {
            clazzes = Set.of(Integer.TYPE, Integer.class);
        }
    }
}

