/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.layout;

import io.deephaven.base.FileUtils;
import io.deephaven.engine.table.impl.locations.TableDataException;
import io.deephaven.engine.table.impl.locations.impl.TableLocationKeyFinder;
import io.deephaven.engine.table.impl.locations.local.URITableLocationKey;
import io.deephaven.parquet.table.ParquetInstructions;
import io.deephaven.parquet.table.location.ParquetTableLocationKey;
import io.deephaven.util.annotations.VisibleForTesting;
import io.deephaven.util.channel.SeekableChannelsProvider;
import io.deephaven.util.channel.SeekableChannelsProviderLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeephavenNestedPartitionLayout<TLK extends URITableLocationKey>
implements TableLocationKeyFinder<TLK> {
    @VisibleForTesting
    public static final String PARQUET_FILE_NAME = "table.parquet";
    public static final String INTERNAL_PARTITION_KEY = "__INTERNAL_PARTITION__";
    private final File tableRootDirectory;
    private final String tableName;
    private final String columnPartitionKey;
    private final Predicate<String> internalPartitionValueFilter;

    public static DeephavenNestedPartitionLayout<ParquetTableLocationKey> forParquet(@NotNull File tableRootDirectory, @NotNull String tableName, @NotNull String columnPartitionKey, @Nullable Predicate<String> internalPartitionValueFilter, final @NotNull ParquetInstructions readInstructions) {
        final SeekableChannelsProvider channelsProvider = SeekableChannelsProviderLoader.getInstance().fromServiceLoader(FileUtils.convertToURI((File)tableRootDirectory, (boolean)true), readInstructions.getSpecialInstructions());
        return new DeephavenNestedPartitionLayout<ParquetTableLocationKey>(tableRootDirectory, tableName, columnPartitionKey, internalPartitionValueFilter){

            @Override
            protected ParquetTableLocationKey makeKey(@NotNull Path tableLeafDirectory, @NotNull Map<String, Comparable<?>> partitions) {
                URI fileURI = FileUtils.convertToURI((Path)tableLeafDirectory.resolve(DeephavenNestedPartitionLayout.PARQUET_FILE_NAME), (boolean)false);
                return new ParquetTableLocationKey(fileURI, 0, partitions, readInstructions, channelsProvider);
            }
        };
    }

    protected DeephavenNestedPartitionLayout(@NotNull File tableRootDirectory, @NotNull String tableName, @NotNull String columnPartitionKey, @Nullable Predicate<String> internalPartitionValueFilter) {
        this.tableRootDirectory = tableRootDirectory;
        this.tableName = tableName;
        this.columnPartitionKey = columnPartitionKey;
        this.internalPartitionValueFilter = internalPartitionValueFilter;
    }

    public String toString() {
        return DeephavenNestedPartitionLayout.class.getSimpleName() + "[" + this.tableRootDirectory + "," + this.tableName + "]";
    }

    public final void findKeys(@NotNull Consumer<TLK> locationKeyObserver) {
        LinkedHashMap partitions = new LinkedHashMap();
        try (DirectoryStream<Path> internalPartitionStream2 = Files.newDirectoryStream(this.tableRootDirectory.toPath(), x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
            for (Path internalPartition : internalPartitionStream2) {
                String internalPartitionValue = internalPartition.getFileName().toString();
                if (this.internalPartitionValueFilter != null && !this.internalPartitionValueFilter.test(internalPartitionValue)) continue;
                boolean needToUpdateInternalPartitionValue = true;
                DirectoryStream<Path> columnPartitionStream = Files.newDirectoryStream(internalPartition, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
                try {
                    for (Path columnPartition : columnPartitionStream) {
                        partitions.put(this.columnPartitionKey, (Comparable<?>)((Object)columnPartition.getFileName().toString()));
                        if (needToUpdateInternalPartitionValue) {
                            partitions.put(INTERNAL_PARTITION_KEY, (Comparable<?>)((Object)internalPartitionValue));
                            needToUpdateInternalPartitionValue = false;
                        }
                        locationKeyObserver.accept(this.makeKey(columnPartition.resolve(this.tableName), partitions));
                    }
                }
                finally {
                    if (columnPartitionStream == null) continue;
                    columnPartitionStream.close();
                }
            }
        }
        catch (FileNotFoundException | NoSuchFileException internalPartitionStream2) {
        }
        catch (IOException e) {
            throw new TableDataException("Error finding locations for " + this.tableName + " under " + this.tableRootDirectory, (Throwable)e);
        }
    }

    protected abstract TLK makeKey(@NotNull Path var1, @NotNull Map<String, Comparable<?>> var2);

    protected String getColumnPartitionKey() {
        return this.columnPartitionKey;
    }
}

