/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.layout;

import io.deephaven.base.FileUtils;
import io.deephaven.csv.CsvTools;
import io.deephaven.csv.util.CsvReaderException;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.locations.TableDataException;
import io.deephaven.engine.table.impl.locations.local.KeyValuePartitionLayout;
import io.deephaven.engine.util.TableTools;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;

public final class LocationTableBuilderCsv
implements KeyValuePartitionLayout.LocationTableBuilder {
    private static final String LS = System.lineSeparator();
    private final URI tableRootDirectory;
    private List<String> partitionKeys;
    private StringBuilder csvBuilder;
    private int locationCount;

    public LocationTableBuilderCsv(@NotNull File tableRootDirectory) {
        this(FileUtils.convertToURI((File)tableRootDirectory, (boolean)true));
    }

    LocationTableBuilderCsv(@NotNull URI tableRootDirectory) {
        this.tableRootDirectory = tableRootDirectory;
    }

    public void registerPartitionKeys(@NotNull Collection<String> partitionKeys) {
        if (this.partitionKeys != null) {
            throw new IllegalStateException("Partition keys already registered");
        }
        this.partitionKeys = List.copyOf(Objects.requireNonNull(partitionKeys));
        if (this.partitionKeys.isEmpty()) {
            return;
        }
        this.csvBuilder = new StringBuilder();
        this.maybeAppendToCsv(partitionKeys);
    }

    public void acceptLocation(@NotNull Collection<String> partitionValueStrings) {
        if (this.partitionKeys == null) {
            throw new IllegalStateException("Partition keys not registered");
        }
        ++this.locationCount;
        this.maybeAppendToCsv(partitionValueStrings);
    }

    private void maybeAppendToCsv(@NotNull Collection<String> values) {
        if (this.partitionKeys.isEmpty()) {
            return;
        }
        boolean first = true;
        for (String value : values) {
            if (first) {
                first = false;
            } else {
                this.csvBuilder.append(',');
            }
            this.csvBuilder.append(StringEscapeUtils.escapeCsv((String)value));
        }
        this.csvBuilder.append(LS);
    }

    public Table build() {
        try {
            return this.partitionKeys == null || this.partitionKeys.isEmpty() ? TableTools.emptyTable((long)this.locationCount) : CsvTools.readCsv((InputStream)new ByteArrayInputStream(this.csvBuilder.toString().getBytes()));
        }
        catch (CsvReaderException e) {
            throw new TableDataException("Failed converting partition CSV to table for " + this.tableRootDirectory, (Throwable)e);
        }
    }
}

