/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.layout;

import io.deephaven.engine.table.impl.locations.TableDataException;
import io.deephaven.engine.table.impl.locations.impl.TableLocationKeyFinder;
import io.deephaven.parquet.table.ParquetInstructions;
import io.deephaven.parquet.table.location.ParquetTableLocationKey;
import io.deephaven.util.channel.SeekableChannelsProvider;
import io.deephaven.util.channel.SeekableChannelsProviderLoader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class ParquetFlatPartitionedLayout
implements TableLocationKeyFinder<ParquetTableLocationKey> {
    private final URI tableRootDirectory;
    private final Map<URI, ParquetTableLocationKey> cache;
    private final ParquetInstructions readInstructions;
    private final SeekableChannelsProvider channelsProvider;

    public ParquetFlatPartitionedLayout(@NotNull URI tableRootDirectoryURI, @NotNull ParquetInstructions readInstructions) {
        this.tableRootDirectory = tableRootDirectoryURI;
        this.cache = Collections.synchronizedMap(new HashMap());
        this.readInstructions = readInstructions;
        this.channelsProvider = SeekableChannelsProviderLoader.getInstance().fromServiceLoader(this.tableRootDirectory, readInstructions.getSpecialInstructions());
    }

    public String toString() {
        return ParquetFlatPartitionedLayout.class.getSimpleName() + "[" + this.tableRootDirectory + "]";
    }

    public void findKeys(@NotNull Consumer<ParquetTableLocationKey> locationKeyObserver) {
        Predicate<URI> uriFilter = "file".equals(this.tableRootDirectory.getScheme()) ? uri -> {
            String filename = new File((URI)uri).getName();
            return filename.endsWith(".parquet") && filename.charAt(0) != '.';
        } : uri -> uri.getPath().endsWith(".parquet");
        try (Stream stream = this.channelsProvider.list(this.tableRootDirectory);){
            stream.filter(uriFilter).forEach(uri -> this.cache.compute((URI)uri, (key, existingLocationKey) -> {
                if (existingLocationKey != null) {
                    locationKeyObserver.accept((ParquetTableLocationKey)((Object)existingLocationKey));
                    return existingLocationKey;
                }
                ParquetTableLocationKey newLocationKey = this.locationKey((URI)uri);
                locationKeyObserver.accept(newLocationKey);
                return newLocationKey;
            }));
        }
        catch (IOException e) {
            throw new TableDataException("Error finding parquet locations under " + this.tableRootDirectory, (Throwable)e);
        }
    }

    private ParquetTableLocationKey locationKey(@NotNull URI uri) {
        return new ParquetTableLocationKey(uri, 0, null, this.readInstructions, this.channelsProvider);
    }
}

