/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.layout;

import io.deephaven.engine.table.ColumnDefinition;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.engine.table.impl.locations.TableDataException;
import io.deephaven.engine.table.impl.locations.impl.TableLocationKeyFinder;
import io.deephaven.engine.table.impl.locations.local.LocationTableBuilderDefinition;
import io.deephaven.engine.table.impl.locations.local.URIStreamKeyValuePartitionLayout;
import io.deephaven.parquet.base.ParquetUtils;
import io.deephaven.parquet.table.ParquetInstructions;
import io.deephaven.parquet.table.layout.LocationTableBuilderCsv;
import io.deephaven.parquet.table.location.ParquetTableLocationKey;
import io.deephaven.util.channel.SeekableChannelsProvider;
import io.deephaven.util.channel.SeekableChannelsProviderLoader;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class ParquetKeyValuePartitionedLayout
extends URIStreamKeyValuePartitionLayout<ParquetTableLocationKey>
implements TableLocationKeyFinder<ParquetTableLocationKey> {
    private final SeekableChannelsProvider channelsProvider;

    public ParquetKeyValuePartitionedLayout(@NotNull URI tableRootDirectory, @NotNull TableDefinition tableDefinition, @NotNull ParquetInstructions readInstructions) {
        this(tableRootDirectory, tableDefinition, readInstructions, SeekableChannelsProviderLoader.getInstance().fromServiceLoader(tableRootDirectory, readInstructions.getSpecialInstructions()));
    }

    private ParquetKeyValuePartitionedLayout(@NotNull URI tableRootDirectory, @NotNull TableDefinition tableDefinition, @NotNull ParquetInstructions readInstructions, @NotNull SeekableChannelsProvider channelsProvider) {
        super(tableRootDirectory, () -> new LocationTableBuilderDefinition(tableDefinition), (uri, partitions) -> new ParquetTableLocationKey((URI)uri, 0, (Map<String, Comparable<?>>)partitions, readInstructions, channelsProvider), Math.toIntExact(tableDefinition.getColumnStream().filter(ColumnDefinition::isPartitioning).count()));
        this.channelsProvider = channelsProvider;
    }

    public ParquetKeyValuePartitionedLayout(@NotNull URI tableRootDirectory, int maxPartitioningLevels, @NotNull ParquetInstructions readInstructions) {
        this(tableRootDirectory, maxPartitioningLevels, readInstructions, SeekableChannelsProviderLoader.getInstance().fromServiceLoader(tableRootDirectory, readInstructions.getSpecialInstructions()));
    }

    private ParquetKeyValuePartitionedLayout(@NotNull URI tableRootDirectory, int maxPartitioningLevels, @NotNull ParquetInstructions readInstructions, @NotNull SeekableChannelsProvider channelsProvider) {
        super(tableRootDirectory, () -> new LocationTableBuilderCsv(tableRootDirectory), (uri, partitions) -> new ParquetTableLocationKey((URI)uri, 0, (Map<String, Comparable<?>>)partitions, readInstructions, channelsProvider), maxPartitioningLevels);
        this.channelsProvider = channelsProvider;
    }

    public final void findKeys(@NotNull Consumer<ParquetTableLocationKey> locationKeyObserver) {
        Predicate<URI> uriFilter;
        if ("file".equals(this.tableRootDirectory.getScheme())) {
            Path rootDir = Path.of(this.tableRootDirectory);
            uriFilter = uri -> ParquetUtils.isVisibleParquetFile((Path)rootDir, (Path)Path.of(uri));
        } else {
            uriFilter = uri -> uri.getPath().endsWith(".parquet");
        }
        try (Stream<URI> filteredUriStream = this.channelsProvider.walk(this.tableRootDirectory).filter(uriFilter);){
            this.findKeys(filteredUriStream, locationKeyObserver);
        }
        catch (IOException e) {
            throw new TableDataException("Error finding parquet locations under " + this.tableRootDirectory, (Throwable)e);
        }
    }
}

