/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.layout;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import io.deephaven.base.FileUtils;
import io.deephaven.base.Pair;
import io.deephaven.engine.table.ColumnDefinition;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.engine.table.impl.locations.TableDataException;
import io.deephaven.engine.table.impl.locations.impl.TableLocationKeyFinder;
import io.deephaven.engine.table.impl.locations.util.PartitionParser;
import io.deephaven.parquet.base.ParquetFileReader;
import io.deephaven.parquet.base.ParquetUtils;
import io.deephaven.parquet.table.ParquetInstructions;
import io.deephaven.parquet.table.ParquetSchemaReader;
import io.deephaven.parquet.table.location.ParquetTableLocationKey;
import io.deephaven.util.channel.SeekableChannelsProvider;
import io.deephaven.util.channel.SeekableChannelsProviderLoader;
import io.deephaven.util.mutable.MutableInt;
import io.deephaven.util.type.TypeUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.parquet.format.ColumnChunk;
import org.apache.parquet.format.RowGroup;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParquetMetadataFileLayout
implements TableLocationKeyFinder<ParquetTableLocationKey> {
    private final File metadataFile;
    private final File commonMetadataFile;
    private final TableDefinition definition;
    private final ParquetInstructions instructions;
    private final List<ParquetTableLocationKey> keys;
    private final SeekableChannelsProvider channelsProvider;

    public ParquetMetadataFileLayout(@NotNull File directory) {
        this(directory, ParquetInstructions.EMPTY);
    }

    public ParquetMetadataFileLayout(@NotNull File directory, @NotNull ParquetInstructions inputInstructions) {
        this(new File(directory, "_metadata"), new File(directory, "_common_metadata"), inputInstructions);
    }

    public ParquetMetadataFileLayout(@NotNull File metadataFile, @Nullable File commonMetadataFile) {
        this(metadataFile, commonMetadataFile, ParquetInstructions.EMPTY);
    }

    public ParquetMetadataFileLayout(@NotNull File metadataFile, @Nullable File commonMetadataFile, @NotNull ParquetInstructions inputInstructions) {
        if (inputInstructions.isRefreshing()) {
            throw new IllegalArgumentException("ParquetMetadataFileLayout does not support refreshing");
        }
        this.metadataFile = metadataFile;
        this.commonMetadataFile = commonMetadataFile;
        this.channelsProvider = SeekableChannelsProviderLoader.getInstance().fromServiceLoader(FileUtils.convertToURI((File)metadataFile, (boolean)false), inputInstructions.getSpecialInstructions());
        if (!metadataFile.exists()) {
            throw new TableDataException(String.format("Parquet metadata file %s does not exist", metadataFile));
        }
        ParquetFileReader metadataFileReader = ParquetFileReader.create((File)metadataFile, (SeekableChannelsProvider)this.channelsProvider);
        ParquetMetadataConverter converter = new ParquetMetadataConverter();
        ParquetMetadata metadataFileMetadata = ParquetMetadataFileLayout.convertMetadata(metadataFile, metadataFileReader, converter);
        Pair<List<ColumnDefinition<?>>, ParquetInstructions> leafSchemaInfo = ParquetSchemaReader.convertSchema(metadataFileReader.getSchema(), metadataFileMetadata.getFileMetaData().getKeyValueMetaData(), inputInstructions);
        if (commonMetadataFile != null && commonMetadataFile.exists()) {
            ParquetFileReader commonMetadataFileReader = ParquetFileReader.create((File)commonMetadataFile, (SeekableChannelsProvider)this.channelsProvider);
            Pair<List<ColumnDefinition<?>>, ParquetInstructions> fullSchemaInfo = ParquetSchemaReader.convertSchema(commonMetadataFileReader.getSchema(), ParquetMetadataFileLayout.convertMetadata(commonMetadataFile, commonMetadataFileReader, converter).getFileMetaData().getKeyValueMetaData(), (ParquetInstructions)leafSchemaInfo.getSecond());
            ArrayList<Object> adjustedColumnDefinitions = new ArrayList<Object>();
            Map leafDefinitionsMap = ((List)leafSchemaInfo.getFirst()).stream().collect(Collectors.toMap(ColumnDefinition::getName, Function.identity()));
            for (ColumnDefinition fullDefinition : (List)fullSchemaInfo.getFirst()) {
                ColumnDefinition leafDefinition = (ColumnDefinition)leafDefinitionsMap.get(fullDefinition.getName());
                if (leafDefinition == null) {
                    adjustedColumnDefinitions.add(ParquetMetadataFileLayout.adjustPartitionDefinition(fullDefinition));
                    continue;
                }
                if (fullDefinition.equals((Object)leafDefinition)) {
                    adjustedColumnDefinitions.add(fullDefinition);
                    continue;
                }
                ArrayList differences = new ArrayList();
                fullDefinition.describeDifferences(differences, leafDefinition, "full schema", "file schema", "", false);
                throw new TableDataException(String.format("Schema mismatch between %s and %s for column %s: %s", metadataFile, commonMetadataFile, fullDefinition.getName(), differences));
            }
            this.definition = TableDefinition.of(adjustedColumnDefinitions);
            this.instructions = (ParquetInstructions)fullSchemaInfo.getSecond();
        } else {
            this.definition = TableDefinition.of((Collection)((Collection)leafSchemaInfo.getFirst()));
            this.instructions = (ParquetInstructions)leafSchemaInfo.getSecond();
        }
        List partitioningColumns = this.definition.getPartitioningColumns();
        Map<String, PartitionParser> partitionKeyToParser = partitioningColumns.stream().collect(Collectors.toMap(ColumnDefinition::getName, cd -> PartitionParser.lookupSupported((Class)cd.getDataType(), (Class)cd.getComponentType())));
        LinkedHashMap<String, TIntList> filePathToRowGroupIndices = new LinkedHashMap<String, TIntList>();
        List rowGroups = metadataFileReader.fileMetaData.getRow_groups();
        int numRowGroups = rowGroups.size();
        for (int rgi = 0; rgi < numRowGroups; ++rgi) {
            String relativePath = FilenameUtils.separatorsToSystem((String)((ColumnChunk)((RowGroup)rowGroups.get(rgi)).getColumns().get(0)).getFile_path());
            filePathToRowGroupIndices.computeIfAbsent(relativePath, fn -> new TIntArrayList()).add(rgi);
        }
        File directory = metadataFile.getParentFile();
        MutableInt partitionOrder = new MutableInt(0);
        this.keys = filePathToRowGroupIndices.entrySet().stream().map(entry -> {
            LinkedHashMap partitions;
            String relativePathString = (String)entry.getKey();
            int[] rowGroupIndices = ((TIntList)entry.getValue()).toArray();
            if (relativePathString == null || relativePathString.isEmpty()) {
                throw new TableDataException(String.format("Missing parquet file name for row groups %s in %s", Arrays.toString(rowGroupIndices), metadataFile));
            }
            LinkedHashMap linkedHashMap = partitions = partitioningColumns.isEmpty() ? null : new LinkedHashMap();
            if (partitions != null) {
                Path filePath = Paths.get(relativePathString, new String[0]);
                int numPartitions = filePath.getNameCount() - 1;
                if (numPartitions != partitioningColumns.size()) {
                    throw new TableDataException(String.format("Unexpected number of path elements in %s for partitions %s", relativePathString, partitions.keySet()));
                }
                boolean useHiveStyle = filePath.getName(0).toString().contains("=");
                for (int pi = 0; pi < numPartitions; ++pi) {
                    String partitionValueRaw;
                    String partitionKey;
                    String pathElement = filePath.getName(pi).toString();
                    if (useHiveStyle) {
                        String[] pathComponents = pathElement.split("=", 2);
                        if (pathComponents.length != 2) {
                            throw new TableDataException(String.format("Unexpected path format found for hive-style partitioning from %s for %s", relativePathString, metadataFile));
                        }
                        partitionKey = this.instructions.getColumnNameFromParquetColumnNameOrDefault(pathComponents[0]);
                        partitionValueRaw = pathComponents[1];
                    } else {
                        partitionKey = ((ColumnDefinition)partitioningColumns.get(pi)).getName();
                        partitionValueRaw = pathElement;
                    }
                    Comparable partitionValue = ((PartitionParser)partitionKeyToParser.get(partitionKey)).parse(partitionValueRaw);
                    if (partitions.containsKey(partitionKey)) {
                        throw new TableDataException(String.format("Unexpected duplicate partition key %s when parsing %s for %s", partitionKey, relativePathString, metadataFile));
                    }
                    partitions.put(partitionKey, partitionValue);
                }
            }
            URI partitionFileURI = FileUtils.convertToURI((File)new File(directory, relativePathString), (boolean)false);
            ParquetTableLocationKey tlk = new ParquetTableLocationKey(partitionFileURI, partitionOrder.getAndIncrement(), partitions, inputInstructions, this.channelsProvider);
            tlk.setFileReader(metadataFileReader);
            tlk.setMetadata(ParquetMetadataFileLayout.getParquetMetadataForFile(relativePathString, metadataFileMetadata));
            tlk.setRowGroupIndices(rowGroupIndices);
            return tlk;
        }).collect(Collectors.toList());
    }

    private static ParquetMetadata getParquetMetadataForFile(@NotNull String parquetFileRelativePath, @NotNull ParquetMetadata metadataFileMetadata) {
        ParquetMetadata fileMetadata;
        String fileMetadataString = (String)metadataFileMetadata.getFileMetaData().getKeyValueMetaData().get(ParquetUtils.getPerFileMetadataKey((String)parquetFileRelativePath));
        if (fileMetadataString != null) {
            Map<String, String> keyValueMetadata = Map.of("deephaven", fileMetadataString);
            fileMetadata = new ParquetMetadata(new FileMetaData(metadataFileMetadata.getFileMetaData().getSchema(), keyValueMetadata, metadataFileMetadata.getFileMetaData().getCreatedBy()), metadataFileMetadata.getBlocks());
        } else {
            fileMetadata = metadataFileMetadata;
        }
        return fileMetadata;
    }

    public String toString() {
        return ParquetMetadataFileLayout.class.getSimpleName() + "[" + this.metadataFile + "," + this.commonMetadataFile + "]";
    }

    private static ParquetMetadata convertMetadata(@NotNull File file, @NotNull ParquetFileReader fileReader, @NotNull ParquetMetadataConverter converter) {
        try {
            return converter.fromParquetMetadata(fileReader.fileMetaData);
        }
        catch (IOException e) {
            throw new TableDataException("Error while converting file metadata from " + file);
        }
    }

    private static ColumnDefinition<?> adjustPartitionDefinition(@NotNull ColumnDefinition<?> columnDefinition) {
        Class dataType = columnDefinition.getDataType();
        if (dataType == Boolean.TYPE) {
            return ColumnDefinition.fromGenericType((String)columnDefinition.getName(), Boolean.class, null, (ColumnDefinition.ColumnType)ColumnDefinition.ColumnType.Partitioning);
        }
        if (dataType.isPrimitive() || dataType == Boolean.class) {
            return columnDefinition.withPartitioning();
        }
        Class unboxedType = TypeUtils.getUnboxedTypeIfBoxed((Class)dataType);
        if (unboxedType != dataType) {
            return ColumnDefinition.fromGenericType((String)columnDefinition.getName(), (Class)unboxedType, null, (ColumnDefinition.ColumnType)ColumnDefinition.ColumnType.Partitioning);
        }
        if (PartitionParser.lookup((Class)dataType, (Class)columnDefinition.getComponentType()) != null) {
            return columnDefinition.withPartitioning();
        }
        return ColumnDefinition.fromGenericType((String)columnDefinition.getName(), String.class, null, (ColumnDefinition.ColumnType)ColumnDefinition.ColumnType.Partitioning);
    }

    public TableDefinition getTableDefinition() {
        return this.definition;
    }

    public ParquetInstructions getInstructions() {
        return this.instructions;
    }

    public void findKeys(@NotNull Consumer<ParquetTableLocationKey> locationKeyObserver) {
        this.keys.forEach(locationKeyObserver);
    }
}

