/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.location;

import io.deephaven.base.verify.Assert;
import io.deephaven.base.verify.Require;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.attributes.Any;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.configuration.Configuration;
import io.deephaven.engine.table.ColumnDefinition;
import io.deephaven.engine.table.impl.CodecLookup;
import io.deephaven.engine.table.impl.chunkattributes.DictionaryKeys;
import io.deephaven.engine.table.impl.locations.TableDataException;
import io.deephaven.engine.table.impl.locations.TableLocation;
import io.deephaven.engine.table.impl.locations.impl.AbstractColumnLocation;
import io.deephaven.engine.table.impl.sources.regioned.ColumnRegionByte;
import io.deephaven.engine.table.impl.sources.regioned.ColumnRegionChar;
import io.deephaven.engine.table.impl.sources.regioned.ColumnRegionChunkDictionary;
import io.deephaven.engine.table.impl.sources.regioned.ColumnRegionDouble;
import io.deephaven.engine.table.impl.sources.regioned.ColumnRegionFloat;
import io.deephaven.engine.table.impl.sources.regioned.ColumnRegionInt;
import io.deephaven.engine.table.impl.sources.regioned.ColumnRegionLong;
import io.deephaven.engine.table.impl.sources.regioned.ColumnRegionObject;
import io.deephaven.engine.table.impl.sources.regioned.ColumnRegionShort;
import io.deephaven.parquet.base.BigDecimalParquetBytesCodec;
import io.deephaven.parquet.base.BigIntegerParquetBytesCodec;
import io.deephaven.parquet.base.ColumnChunkReader;
import io.deephaven.parquet.table.ParquetInstructions;
import io.deephaven.parquet.table.location.ParquetTableLocation;
import io.deephaven.parquet.table.metadata.CodecInfo;
import io.deephaven.parquet.table.metadata.ColumnTypeInfo;
import io.deephaven.parquet.table.pagestore.ColumnChunkPageStore;
import io.deephaven.parquet.table.pagestore.PageCache;
import io.deephaven.parquet.table.pagestore.topage.ToArrayPage;
import io.deephaven.parquet.table.pagestore.topage.ToBigDecimalFromNumeric;
import io.deephaven.parquet.table.pagestore.topage.ToBigDecimalPage;
import io.deephaven.parquet.table.pagestore.topage.ToBigIntegerPage;
import io.deephaven.parquet.table.pagestore.topage.ToBooleanAsBytePage;
import io.deephaven.parquet.table.pagestore.topage.ToBytePage;
import io.deephaven.parquet.table.pagestore.topage.ToCharPage;
import io.deephaven.parquet.table.pagestore.topage.ToDoublePage;
import io.deephaven.parquet.table.pagestore.topage.ToFloatPage;
import io.deephaven.parquet.table.pagestore.topage.ToInstantPage;
import io.deephaven.parquet.table.pagestore.topage.ToIntPage;
import io.deephaven.parquet.table.pagestore.topage.ToLocalDatePage;
import io.deephaven.parquet.table.pagestore.topage.ToLocalDateTimePage;
import io.deephaven.parquet.table.pagestore.topage.ToLocalTimePage;
import io.deephaven.parquet.table.pagestore.topage.ToLongPage;
import io.deephaven.parquet.table.pagestore.topage.ToObjectPage;
import io.deephaven.parquet.table.pagestore.topage.ToPage;
import io.deephaven.parquet.table.pagestore.topage.ToShortPage;
import io.deephaven.parquet.table.pagestore.topage.ToStringPage;
import io.deephaven.parquet.table.pagestore.topage.ToStringSetPage;
import io.deephaven.parquet.table.pagestore.topage.ToVectorPage;
import io.deephaven.parquet.table.region.ParquetColumnRegionByte;
import io.deephaven.parquet.table.region.ParquetColumnRegionChar;
import io.deephaven.parquet.table.region.ParquetColumnRegionDouble;
import io.deephaven.parquet.table.region.ParquetColumnRegionFloat;
import io.deephaven.parquet.table.region.ParquetColumnRegionInt;
import io.deephaven.parquet.table.region.ParquetColumnRegionLong;
import io.deephaven.parquet.table.region.ParquetColumnRegionObject;
import io.deephaven.parquet.table.region.ParquetColumnRegionShort;
import io.deephaven.util.codec.CodecCache;
import io.deephaven.util.codec.ObjectCodec;
import io.deephaven.util.codec.SimpleByteArrayCodec;
import io.deephaven.vector.Vector;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ParquetColumnLocation<ATTR extends Values>
extends AbstractColumnLocation {
    private static final String IMPLEMENTATION_NAME = ParquetColumnLocation.class.getSimpleName();
    private static final int INITIAL_PAGE_CACHE_SIZE = Configuration.getInstance().getIntegerForClassWithDefault(ParquetColumnLocation.class, "initialPageCacheSize", 128);
    private static final int MAX_PAGE_CACHE_SIZE = Configuration.getInstance().getIntegerForClassWithDefault(ParquetColumnLocation.class, "maxPageCacheSize", 8192);
    private final String parquetColumnName;
    private volatile ColumnChunkReader[] columnChunkReaders;
    private volatile PageCache<ATTR> pageCache;
    private ColumnChunkPageStore<ATTR>[] pageStores;
    private Supplier<Chunk<ATTR>>[] dictionaryChunkSuppliers;
    private ColumnChunkPageStore<DictionaryKeys>[] dictionaryKeysPageStores;

    ParquetColumnLocation(@NotNull ParquetTableLocation tableLocation, @NotNull String columnName, @NotNull String parquetColumnName, @Nullable ColumnChunkReader[] columnChunkReaders) {
        super((TableLocation)tableLocation, columnName);
        this.parquetColumnName = parquetColumnName;
        this.columnChunkReaders = columnChunkReaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PageCache<ATTR> ensurePageCache() {
        PageCache<ATTR> localPageCache = this.pageCache;
        if (localPageCache != null) {
            return localPageCache;
        }
        ParquetColumnLocation parquetColumnLocation = this;
        synchronized (parquetColumnLocation) {
            localPageCache = this.pageCache;
            if (localPageCache != null) {
                return localPageCache;
            }
            this.pageCache = new PageCache(INITIAL_PAGE_CACHE_SIZE, MAX_PAGE_CACHE_SIZE);
            return this.pageCache;
        }
    }

    public String getImplementationName() {
        return IMPLEMENTATION_NAME;
    }

    public boolean exists() {
        return this.columnChunkReaders != null || this.pageStores != null;
    }

    private ParquetTableLocation tl() {
        return (ParquetTableLocation)this.getTableLocation();
    }

    private <SOURCE, REGION_TYPE> REGION_TYPE makeColumnRegion(@NotNull Function<ColumnDefinition<?>, SOURCE[]> sourceArrayFactory, @NotNull ColumnDefinition<?> columnDefinition, @NotNull LongFunction<REGION_TYPE> nullRegionFactory, @NotNull Function<SOURCE, REGION_TYPE> singleRegionFactory, @NotNull Function<Stream<REGION_TYPE>, REGION_TYPE> multiRegionFactory) {
        SOURCE[] sources = sourceArrayFactory.apply(columnDefinition);
        return sources.length == 1 ? this.makeSingleColumnRegion(sources[0], nullRegionFactory, singleRegionFactory) : multiRegionFactory.apply(Arrays.stream(sources).map(source -> this.makeSingleColumnRegion(source, nullRegionFactory, singleRegionFactory)));
    }

    private <SOURCE, REGION_TYPE> REGION_TYPE makeSingleColumnRegion(SOURCE source, @NotNull LongFunction<REGION_TYPE> nullRegionFactory, @NotNull Function<SOURCE, REGION_TYPE> singleRegionFactory) {
        return source == null ? nullRegionFactory.apply(this.tl().getRegionParameters().regionMask) : singleRegionFactory.apply(source);
    }

    public ColumnRegionChar<Values> makeColumnRegionChar(@NotNull ColumnDefinition<?> columnDefinition) {
        return this.makeColumnRegion(this::getPageStores, columnDefinition, ColumnRegionChar::createNull, ParquetColumnRegionChar::new, rs -> new ColumnRegionChar.StaticPageStore(this.tl().getRegionParameters(), (ColumnRegionChar[])rs.toArray(ColumnRegionChar[]::new)));
    }

    public ColumnRegionByte<Values> makeColumnRegionByte(@NotNull ColumnDefinition<?> columnDefinition) {
        return this.makeColumnRegion(this::getPageStores, columnDefinition, ColumnRegionByte::createNull, ParquetColumnRegionByte::new, rs -> new ColumnRegionByte.StaticPageStore(this.tl().getRegionParameters(), (ColumnRegionByte[])rs.toArray(ColumnRegionByte[]::new)));
    }

    public ColumnRegionShort<Values> makeColumnRegionShort(@NotNull ColumnDefinition<?> columnDefinition) {
        return this.makeColumnRegion(this::getPageStores, columnDefinition, ColumnRegionShort::createNull, ParquetColumnRegionShort::new, rs -> new ColumnRegionShort.StaticPageStore(this.tl().getRegionParameters(), (ColumnRegionShort[])rs.toArray(ColumnRegionShort[]::new)));
    }

    public ColumnRegionInt<Values> makeColumnRegionInt(@NotNull ColumnDefinition<?> columnDefinition) {
        return this.makeColumnRegion(this::getPageStores, columnDefinition, ColumnRegionInt::createNull, ParquetColumnRegionInt::new, rs -> new ColumnRegionInt.StaticPageStore(this.tl().getRegionParameters(), (ColumnRegionInt[])rs.toArray(ColumnRegionInt[]::new)));
    }

    public ColumnRegionLong<Values> makeColumnRegionLong(@NotNull ColumnDefinition<?> columnDefinition) {
        return this.makeColumnRegion(this::getPageStores, columnDefinition, ColumnRegionLong::createNull, ParquetColumnRegionLong::new, rs -> new ColumnRegionLong.StaticPageStore(this.tl().getRegionParameters(), (ColumnRegionLong[])rs.toArray(ColumnRegionLong[]::new)));
    }

    public ColumnRegionFloat<Values> makeColumnRegionFloat(@NotNull ColumnDefinition<?> columnDefinition) {
        return this.makeColumnRegion(this::getPageStores, columnDefinition, ColumnRegionFloat::createNull, ParquetColumnRegionFloat::new, rs -> new ColumnRegionFloat.StaticPageStore(this.tl().getRegionParameters(), (ColumnRegionFloat[])rs.toArray(ColumnRegionFloat[]::new)));
    }

    public ColumnRegionDouble<Values> makeColumnRegionDouble(@NotNull ColumnDefinition<?> columnDefinition) {
        return this.makeColumnRegion(this::getPageStores, columnDefinition, ColumnRegionDouble::createNull, ParquetColumnRegionDouble::new, rs -> new ColumnRegionDouble.StaticPageStore(this.tl().getRegionParameters(), (ColumnRegionDouble[])rs.toArray(ColumnRegionDouble[]::new)));
    }

    public <TYPE> ColumnRegionObject<TYPE, Values> makeColumnRegionObject(@NotNull ColumnDefinition<TYPE> columnDefinition) {
        Class dataType = columnDefinition.getDataType();
        ColumnChunkPageStore[] sources = this.getPageStores(columnDefinition);
        ColumnChunkPageStore[] dictKeySources = this.getDictionaryKeysPageStores(columnDefinition);
        Supplier[] dictionaryChunkSuppliers = this.getDictionaryChunkSuppliers(columnDefinition);
        if (sources.length == 1) {
            return this.makeSingleColumnRegionObject(dataType, sources[0], dictKeySources[0], dictionaryChunkSuppliers[0]);
        }
        return new ColumnRegionObject.StaticPageStore(this.tl().getRegionParameters(), (ColumnRegionObject[])IntStream.range(0, sources.length).mapToObj(ri -> this.makeSingleColumnRegionObject(dataType, sources[ri], dictKeySources[ri], dictionaryChunkSuppliers[ri])).toArray(ColumnRegionObject[]::new));
    }

    private <TYPE> ColumnRegionObject<TYPE, ATTR> makeSingleColumnRegionObject(@NotNull Class<TYPE> dataType, @Nullable ColumnChunkPageStore<ATTR> source, @Nullable ColumnChunkPageStore<DictionaryKeys> dictKeySource, @Nullable Supplier<Chunk<ATTR>> dictValuesSupplier) {
        if (source == null) {
            return ColumnRegionObject.createNull((long)this.tl().getRegionParameters().regionMask);
        }
        return new ParquetColumnRegionObject(source, () -> new ParquetColumnRegionLong((ColumnChunkPageStore)Require.neqNull((Object)dictKeySource, (String)"dictKeySource")), () -> ColumnRegionChunkDictionary.create((long)this.tl().getRegionParameters().regionMask, (Class)dataType, (Supplier)((Supplier)Require.neqNull((Object)dictValuesSupplier, (String)"dictValuesSupplier"))));
    }

    @NotNull
    public ColumnChunkPageStore<ATTR>[] getPageStores(@NotNull ColumnDefinition<?> columnDefinition) {
        this.fetchValues(columnDefinition);
        return this.pageStores;
    }

    public Supplier<Chunk<ATTR>>[] getDictionaryChunkSuppliers(@NotNull ColumnDefinition<?> columnDefinition) {
        this.fetchValues(columnDefinition);
        return this.dictionaryChunkSuppliers;
    }

    private ColumnChunkPageStore<DictionaryKeys>[] getDictionaryKeysPageStores(@NotNull ColumnDefinition<?> columnDefinition) {
        this.fetchValues(columnDefinition);
        return this.dictionaryKeysPageStores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchValues(@NotNull ColumnDefinition<?> columnDefinition) {
        if (this.columnChunkReaders == null) {
            return;
        }
        ParquetColumnLocation parquetColumnLocation = this;
        synchronized (parquetColumnLocation) {
            if (this.columnChunkReaders == null) {
                return;
            }
            int pageStoreCount = this.columnChunkReaders.length;
            this.pageStores = new ColumnChunkPageStore[pageStoreCount];
            this.dictionaryChunkSuppliers = new Supplier[pageStoreCount];
            this.dictionaryKeysPageStores = new ColumnChunkPageStore[pageStoreCount];
            for (int psi = 0; psi < pageStoreCount; ++psi) {
                ColumnChunkReader columnChunkReader = this.columnChunkReaders[psi];
                try {
                    ColumnChunkPageStore.CreatorResult<ATTR> creatorResult = ColumnChunkPageStore.create(this.ensurePageCache(), columnChunkReader, this.tl().getRegionParameters().regionMask, ParquetColumnLocation.makeToPage(this.tl().getColumnTypes().get(this.parquetColumnName), this.tl().getReadInstructions(), this.parquetColumnName, columnChunkReader, columnDefinition), columnDefinition);
                    this.pageStores[psi] = creatorResult.pageStore;
                    this.dictionaryChunkSuppliers[psi] = creatorResult.dictionaryChunkSupplier;
                    this.dictionaryKeysPageStores[psi] = creatorResult.dictionaryKeysPageStore;
                    continue;
                }
                catch (IOException e) {
                    throw new TableDataException("Failed to read parquet file for " + this + ", row group " + psi, (Throwable)e);
                }
            }
            this.columnChunkReaders = null;
        }
    }

    private static <ATTR extends Any, RESULT> ToPage<ATTR, RESULT> makeToPage(@Nullable ColumnTypeInfo columnTypeInfo, @NotNull ParquetInstructions readInstructions, @NotNull String parquetColumnName, @NotNull ColumnChunkReader columnChunkReader, @NotNull ColumnDefinition<?> columnDefinition) {
        PrimitiveType type = columnChunkReader.getType();
        LogicalTypeAnnotation logicalTypeAnnotation = type.getLogicalTypeAnnotation();
        String codecFromInstructions = readInstructions.getCodecName(columnDefinition.getName());
        String codecName = codecFromInstructions != null ? codecFromInstructions : (columnTypeInfo == null ? null : (String)columnTypeInfo.codec().map(CodecInfo::codecName).orElse(null));
        ColumnTypeInfo.SpecialType specialTypeName = columnTypeInfo == null ? null : (ColumnTypeInfo.SpecialType)columnTypeInfo.specialType().orElse(null);
        boolean isArray = columnChunkReader.getMaxRl() > 0;
        boolean isCodec = CodecLookup.explicitCodecPresent((String)codecName);
        if (isArray && columnChunkReader.getMaxRl() > 1) {
            throw new TableDataException("No support for nested repeated parquet columns.");
        }
        try {
            Class dataType = columnDefinition.getDataType();
            Class componentType = columnDefinition.getComponentType();
            Class pageType = isArray ? componentType : dataType;
            ToPage toPage = null;
            if (!isCodec && logicalTypeAnnotation != null) {
                toPage = logicalTypeAnnotation.accept(new LogicalTypeVisitor(parquetColumnName, columnChunkReader, pageType)).orElse(null);
            }
            if (toPage == null) {
                PrimitiveType.PrimitiveTypeName typeName = type.getPrimitiveTypeName();
                switch (typeName) {
                    case BOOLEAN: {
                        toPage = ToBooleanAsBytePage.create(pageType);
                        break;
                    }
                    case INT32: {
                        toPage = ToIntPage.create(pageType);
                        break;
                    }
                    case INT64: {
                        toPage = ToLongPage.create(pageType);
                        break;
                    }
                    case INT96: {
                        toPage = ToInstantPage.createFromInt96(pageType);
                        break;
                    }
                    case DOUBLE: {
                        toPage = ToDoublePage.create(pageType);
                        break;
                    }
                    case FLOAT: {
                        toPage = ToFloatPage.create(pageType);
                        break;
                    }
                    case BINARY: 
                    case FIXED_LEN_BYTE_ARRAY: {
                        ObjectCodec codec;
                        if (isCodec) {
                            String codecArgs = codecFromInstructions != null ? readInstructions.getCodecArgs(columnDefinition.getName()) : (String)columnTypeInfo.codec().flatMap(CodecInfo::codecArg).orElse(null);
                            codec = CodecCache.DEFAULT.getCodec(codecName, codecArgs);
                        } else {
                            String codecArgs = typeName == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY ? Integer.toString(type.getTypeLength()) : null;
                            codec = CodecCache.DEFAULT.getCodec(SimpleByteArrayCodec.class.getName(), codecArgs);
                        }
                        toPage = ToObjectPage.create(dataType, codec, columnChunkReader.getDictionarySupplier());
                        break;
                    }
                }
            }
            if (toPage == null) {
                throw new TableDataException("Unsupported parquet column type " + type.getPrimitiveTypeName() + " with logical type " + logicalTypeAnnotation);
            }
            if (specialTypeName == ColumnTypeInfo.SpecialType.StringSet) {
                Assert.assertion((boolean)isArray, (String)"isArray");
                toPage = ToStringSetPage.create(dataType, toPage);
            } else if (isArray) {
                Assert.assertion((!isCodec ? 1 : 0) != 0, (String)"!isCodec");
                if (Vector.class.isAssignableFrom(dataType)) {
                    toPage = ToVectorPage.create(dataType, componentType, toPage);
                } else if (dataType.isArray()) {
                    toPage = ToArrayPage.create(dataType, componentType, toPage);
                }
            }
            return toPage;
        }
        catch (RuntimeException except) {
            throw new TableDataException("Unexpected exception accessing column " + parquetColumnName, (Throwable)except);
        }
    }

    private static class LogicalTypeVisitor<ATTR extends Any>
    implements LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<ToPage<ATTR, ?>> {
        private final String name;
        private final ColumnChunkReader columnChunkReader;
        private final Class<?> pageType;

        LogicalTypeVisitor(@NotNull String name, @NotNull ColumnChunkReader columnChunkReader, Class<?> pageType) {
            this.name = name;
            this.columnChunkReader = columnChunkReader;
            this.pageType = pageType;
        }

        public Optional<ToPage<ATTR, ?>> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation stringLogicalType) {
            return Optional.of(ToStringPage.create(this.pageType, this.columnChunkReader.getDictionarySupplier()));
        }

        public Optional<ToPage<ATTR, ?>> visit(LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalType) {
            if (timestampLogicalType.isAdjustedToUTC()) {
                switch (timestampLogicalType.getUnit()) {
                    case MILLIS: {
                        return Optional.of(ToInstantPage.createFromMillis(this.pageType));
                    }
                    case MICROS: {
                        return Optional.of(ToInstantPage.createFromMicros(this.pageType));
                    }
                    case NANOS: {
                        return Optional.of(ToInstantPage.createFromNanos(this.pageType));
                    }
                }
                throw new IllegalArgumentException("Unsupported unit=" + timestampLogicalType.getUnit());
            }
            switch (timestampLogicalType.getUnit()) {
                case MILLIS: {
                    return Optional.of(ToLocalDateTimePage.createFromMillis(this.pageType));
                }
                case MICROS: {
                    return Optional.of(ToLocalDateTimePage.createFromMicros(this.pageType));
                }
                case NANOS: {
                    return Optional.of(ToLocalDateTimePage.createFromNanos(this.pageType));
                }
            }
            throw new IllegalArgumentException("Unsupported unit=" + timestampLogicalType.getUnit());
        }

        public Optional<ToPage<ATTR, ?>> visit(LogicalTypeAnnotation.IntLogicalTypeAnnotation intLogicalType) {
            if (intLogicalType.isSigned()) {
                switch (intLogicalType.getBitWidth()) {
                    case 8: {
                        return Optional.of(ToBytePage.create(this.pageType));
                    }
                    case 16: {
                        return Optional.of(ToShortPage.create(this.pageType));
                    }
                    case 32: {
                        return Optional.of(ToIntPage.create(this.pageType));
                    }
                    case 64: {
                        return Optional.of(ToLongPage.create(this.pageType));
                    }
                }
            } else {
                switch (intLogicalType.getBitWidth()) {
                    case 8: 
                    case 16: {
                        return Optional.of(ToCharPage.create(this.pageType));
                    }
                    case 32: {
                        return Optional.of(ToLongPage.createFromUnsignedInt(this.pageType));
                    }
                }
            }
            return Optional.empty();
        }

        public Optional<ToPage<ATTR, ?>> visit(LogicalTypeAnnotation.DateLogicalTypeAnnotation dateLogicalType) {
            return Optional.of(ToLocalDatePage.create(this.pageType));
        }

        public Optional<ToPage<ATTR, ?>> visit(LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeLogicalType) {
            switch (timeLogicalType.getUnit()) {
                case MILLIS: {
                    return Optional.of(ToLocalTimePage.createFromMillis(this.pageType));
                }
                case MICROS: {
                    return Optional.of(ToLocalTimePage.createFromMicros(this.pageType));
                }
                case NANOS: {
                    return Optional.of(ToLocalTimePage.createFromNanos(this.pageType));
                }
            }
            throw new IllegalArgumentException("Unsupported unit=" + timeLogicalType.getUnit());
        }

        public Optional<ToPage<ATTR, ?>> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType) {
            PrimitiveType type = this.columnChunkReader.getType();
            PrimitiveType.PrimitiveTypeName typeName = type.getPrimitiveTypeName();
            switch (typeName) {
                case INT32: {
                    return Optional.of(ToBigDecimalFromNumeric.createFromInt(this.pageType, decimalLogicalType.getScale()));
                }
                case INT64: {
                    return Optional.of(ToBigDecimalFromNumeric.createFromLong(this.pageType, decimalLogicalType.getScale()));
                }
                case BINARY: 
                case FIXED_LEN_BYTE_ARRAY: {
                    int encodedSizeInBytes;
                    int n = encodedSizeInBytes = typeName == PrimitiveType.PrimitiveTypeName.BINARY ? -1 : type.getTypeLength();
                    if (BigDecimal.class.equals(this.pageType)) {
                        int precision = decimalLogicalType.getPrecision();
                        int scale = decimalLogicalType.getScale();
                        try {
                            BigDecimalParquetBytesCodec.verifyPrecisionAndScale((int)precision, (int)scale, (PrimitiveType.PrimitiveTypeName)typeName);
                        }
                        catch (IllegalArgumentException exception) {
                            throw new TableDataException("Invalid scale and precision for column " + this.name + ": " + exception.getMessage());
                        }
                        return Optional.of(ToBigDecimalPage.create(this.pageType, (ObjectCodec<BigDecimal>)new BigDecimalParquetBytesCodec(precision, scale, encodedSizeInBytes), this.columnChunkReader.getDictionarySupplier()));
                    }
                    if (!BigInteger.class.equals(this.pageType)) break;
                    return Optional.of(ToBigIntegerPage.create(this.pageType, (ObjectCodec<BigInteger>)new BigIntegerParquetBytesCodec(encodedSizeInBytes), this.columnChunkReader.getDictionarySupplier()));
                }
            }
            return Optional.empty();
        }
    }
}

