/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.location;

import io.deephaven.api.SortColumn;
import io.deephaven.base.verify.Assert;
import io.deephaven.base.verify.Require;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetBuilderSequential;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.table.BasicDataIndex;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.dataindex.StandaloneDataIndex;
import io.deephaven.engine.table.impl.locations.ColumnLocation;
import io.deephaven.engine.table.impl.locations.TableDataException;
import io.deephaven.engine.table.impl.locations.TableKey;
import io.deephaven.engine.table.impl.locations.TableLocationKey;
import io.deephaven.engine.table.impl.locations.impl.AbstractTableLocation;
import io.deephaven.engine.table.impl.select.MultiSourceFunctionalColumn;
import io.deephaven.engine.table.impl.select.SourceColumn;
import io.deephaven.engine.table.impl.sources.regioned.RegionedPageStore;
import io.deephaven.parquet.base.ColumnChunkReader;
import io.deephaven.parquet.base.ParquetFileReader;
import io.deephaven.parquet.base.RowGroupReader;
import io.deephaven.parquet.table.ParquetInstructions;
import io.deephaven.parquet.table.ParquetSchemaReader;
import io.deephaven.parquet.table.ParquetTools;
import io.deephaven.parquet.table.location.ParquetColumnLocation;
import io.deephaven.parquet.table.location.ParquetTableLocationKey;
import io.deephaven.parquet.table.metadata.ColumnTypeInfo;
import io.deephaven.parquet.table.metadata.DataIndexInfo;
import io.deephaven.parquet.table.metadata.GroupingColumnInfo;
import io.deephaven.parquet.table.metadata.SortColumnInfo;
import io.deephaven.parquet.table.metadata.TableInfo;
import io.deephaven.util.channel.SeekableChannelsProvider;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.format.RowGroup;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParquetTableLocation
extends AbstractTableLocation {
    private static final String IMPLEMENTATION_NAME = ParquetColumnLocation.class.getSimpleName();
    private final ParquetInstructions readInstructions;
    private final ParquetFileReader parquetFileReader;
    private final int[] rowGroupIndices;
    private final RowGroup[] rowGroups;
    private final RegionedPageStore.Parameters regionParameters;
    private final Map<String, String[]> parquetColumnNameToPath;
    private final TableInfo tableInfo;
    private final Map<String, GroupingColumnInfo> groupingColumns;
    private final List<DataIndexInfo> dataIndexes;
    private final Map<String, ColumnTypeInfo> columnTypes;
    private final List<SortColumn> sortingColumns;
    private final String version;
    private volatile RowGroupReader[] rowGroupReaders;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParquetTableLocation(@NotNull TableKey tableKey, @NotNull ParquetTableLocationKey tableLocationKey, @NotNull ParquetInstructions readInstructions) {
        super(tableKey, (TableLocationKey)tableLocationKey, false);
        ParquetMetadata parquetMetadata;
        this.readInstructions = readInstructions;
        ParquetTableLocationKey parquetTableLocationKey = tableLocationKey;
        synchronized (parquetTableLocationKey) {
            this.parquetFileReader = tableLocationKey.getFileReader();
            parquetMetadata = tableLocationKey.getMetadata();
            this.rowGroupIndices = tableLocationKey.getRowGroupIndices();
        }
        int rowGroupCount = this.rowGroupIndices.length;
        this.rowGroups = (RowGroup[])IntStream.of(this.rowGroupIndices).mapToObj(rgi -> (RowGroup)this.parquetFileReader.fileMetaData.getRow_groups().get(rgi)).sorted(Comparator.comparingInt(RowGroup::getOrdinal)).toArray(RowGroup[]::new);
        long maxRowCount = Arrays.stream(this.rowGroups).mapToLong(RowGroup::getNum_rows).max().orElse(0L);
        this.regionParameters = new RegionedPageStore.Parameters(0x7FFFFFFFFFFL, rowGroupCount, maxRowCount);
        this.parquetColumnNameToPath = new HashMap<String, String[]>();
        for (ColumnDescriptor column : this.parquetFileReader.getSchema().getColumns()) {
            String[] path = column.getPath();
            if (path.length <= 1) continue;
            this.parquetColumnNameToPath.put(path[0], path);
        }
        this.tableInfo = ParquetSchemaReader.parseMetadata(parquetMetadata.getFileMetaData().getKeyValueMetaData()).orElse(TableInfo.builder().build());
        this.version = this.tableInfo.version();
        this.groupingColumns = this.tableInfo.groupingColumnMap();
        this.dataIndexes = this.tableInfo.dataIndexes();
        this.columnTypes = this.tableInfo.columnTypeMap();
        this.sortingColumns = SortColumnInfo.sortColumns(this.tableInfo.sortingColumns());
        if (!"file".equals(tableLocationKey.getURI().getScheme())) {
            this.handleUpdate(this.computeIndex(), Long.MIN_VALUE);
        } else {
            this.handleUpdate(this.computeIndex(), new File(tableLocationKey.getURI()).lastModified());
        }
    }

    public String getImplementationName() {
        return IMPLEMENTATION_NAME;
    }

    public void refresh() {
    }

    ParquetTableLocationKey getParquetKey() {
        return (ParquetTableLocationKey)this.getKey();
    }

    ParquetInstructions getReadInstructions() {
        return this.readInstructions;
    }

    SeekableChannelsProvider getChannelProvider() {
        return this.parquetFileReader.getChannelsProvider();
    }

    RegionedPageStore.Parameters getRegionParameters() {
        return this.regionParameters;
    }

    public Map<String, ColumnTypeInfo> getColumnTypes() {
        return this.columnTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RowGroupReader[] getRowGroupReaders() {
        RowGroupReader[] local = this.rowGroupReaders;
        if (this.rowGroupReaders != null) {
            return local;
        }
        ParquetTableLocation parquetTableLocation = this;
        synchronized (parquetTableLocation) {
            local = this.rowGroupReaders;
            if (this.rowGroupReaders != null) {
                return local;
            }
            this.rowGroupReaders = (RowGroupReader[])IntStream.of(this.rowGroupIndices).mapToObj(idx -> this.parquetFileReader.getRowGroup(idx, this.version)).sorted(Comparator.comparingInt(rgr -> rgr.getRowGroup().getOrdinal())).toArray(RowGroupReader[]::new);
            return this.rowGroupReaders;
        }
    }

    @NotNull
    public List<SortColumn> getSortedColumns() {
        return this.sortingColumns;
    }

    @NotNull
    protected ColumnLocation makeColumnLocation(@NotNull String columnName) {
        String parquetColumnName = this.readInstructions.getParquetColumnNameFromColumnNameOrDefault(columnName);
        String[] columnPath = this.parquetColumnNameToPath.get(parquetColumnName);
        List<String> nameList = columnPath == null ? Collections.singletonList(parquetColumnName) : Arrays.asList(columnPath);
        ColumnChunkReader[] columnChunkReaders = (ColumnChunkReader[])Arrays.stream(this.getRowGroupReaders()).map(rgr -> rgr.getColumnChunk(columnName, nameList)).toArray(ColumnChunkReader[]::new);
        boolean exists = Arrays.stream(columnChunkReaders).anyMatch(ccr -> ccr != null && ccr.numRows() > 0L);
        return new ParquetColumnLocation(this, columnName, parquetColumnName, (ColumnChunkReader[])(exists ? columnChunkReaders : null));
    }

    private RowSet computeIndex() {
        RowSetBuilderSequential sequentialBuilder = RowSetFactory.builderSequential();
        for (int rgi = 0; rgi < this.rowGroups.length; ++rgi) {
            long subRegionSize = this.rowGroups[rgi].getNum_rows();
            long subRegionFirstKey = (long)rgi << this.regionParameters.regionMaskNumBits;
            long subRegionLastKey = subRegionFirstKey + subRegionSize - 1L;
            sequentialBuilder.appendRange(subRegionFirstKey, subRegionLastKey);
        }
        return sequentialBuilder.build();
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public List<String[]> getDataIndexColumns() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean hasDataIndex(String ... columns) {
        if (columns.length == 1 && this.groupingColumns.containsKey(columns[0])) {
            IndexFileMetadata metadata = ParquetTableLocation.getIndexFileMetadata(this.getParquetKey().getURI(), this.tableInfo, columns);
            return metadata != null && ParquetTableLocation.parquetFileExists(metadata.fileURI);
        }
        for (DataIndexInfo dataIndex : this.dataIndexes) {
            if (!dataIndex.matchesColumns(columns)) continue;
            IndexFileMetadata metadata = ParquetTableLocation.getIndexFileMetadata(this.getParquetKey().getURI(), this.tableInfo, columns);
            return metadata != null && ParquetTableLocation.parquetFileExists(metadata.fileURI);
        }
        return false;
    }

    private static boolean parquetFileExists(@NotNull URI fileURI) {
        return !fileURI.getScheme().equals("file") || Files.exists(Path.of(fileURI), new LinkOption[0]);
    }

    @Nullable
    public BasicDataIndex loadDataIndex(String ... columns) {
        if (this.tableInfo == null) {
            return null;
        }
        IndexFileMetadata indexFileMetaData = ParquetTableLocation.getIndexFileMetadata(this.getParquetKey().getURI(), this.tableInfo, columns);
        if (indexFileMetaData == null) {
            throw new TableDataException(String.format("No index metadata for table %s with index key columns %s was present in TableInfo", this.getParquetKey().getURI(), Arrays.toString(columns)));
        }
        Table table = ParquetTableLocation.readDataIndexTable(this.getParquetKey().getURI(), indexFileMetaData, this.readInstructions);
        if (table == null) {
            return null;
        }
        return StandaloneDataIndex.from((Table)table, (String[])columns, (String)"dh_row_set");
    }

    private static URI makeRelativeURI(@NotNull URI parentFileURI, @NotNull String relativePath) {
        String parentPath = parentFileURI.getPath();
        int lastSlashIndex = parentPath.lastIndexOf(47);
        try {
            return new URI(parentFileURI.getScheme(), parentFileURI.getAuthority(), (lastSlashIndex == -1 ? parentPath : parentPath.substring(0, lastSlashIndex + 1)) + relativePath, null, null);
        }
        catch (URISyntaxException e) {
            throw new TableDataException(String.format("Failed to format relative URI for parent %s, child %s", parentFileURI, relativePath), (Throwable)e);
        }
    }

    private static IndexFileMetadata getIndexFileMetadata(@NotNull URI parentFileURI, @NotNull TableInfo info, String ... keyColumnNames) {
        GroupingColumnInfo groupingColumnInfo;
        if (keyColumnNames.length == 1 && (groupingColumnInfo = info.groupingColumnMap().get(keyColumnNames[0])) != null) {
            return new IndexFileMetadata(ParquetTableLocation.makeRelativeURI(parentFileURI, groupingColumnInfo.groupingTablePath()), groupingColumnInfo, null);
        }
        DataIndexInfo dataIndexInfo = info.dataIndexes().stream().filter(item -> item.matchesColumns(keyColumnNames)).findFirst().orElse(null);
        if (dataIndexInfo != null) {
            return new IndexFileMetadata(ParquetTableLocation.makeRelativeURI(parentFileURI, dataIndexInfo.indexTablePath()), null, dataIndexInfo);
        }
        return null;
    }

    @Nullable
    private static Table readDataIndexTable(@NotNull URI parentFileURI, @NotNull IndexFileMetadata indexFileMetaData, @NotNull ParquetInstructions parquetInstructions) {
        Table indexTable = ParquetTools.readTable(indexFileMetaData.fileURI.toString(), parquetInstructions.withTableDefinitionAndLayout(null, ParquetInstructions.ParquetFileLayout.SINGLE_FILE));
        if (indexFileMetaData.dataIndexInfo != null) {
            return indexTable;
        }
        Assert.neqNull((Object)indexFileMetaData.groupingColumnInfo, (String)"indexFileMetaData.groupingColumnInfo");
        if (indexTable.hasColumns(new String[]{"dh_key", "dh_begin_pos", "dh_end_pos"})) {
            return (Table)indexTable.view(List.of(new SourceColumn("dh_key", indexFileMetaData.groupingColumnInfo.columnName()), new MultiSourceFunctionalColumn(List.of("dh_begin_pos", "dh_end_pos"), "dh_row_set", RowSet.class, (rowKey, sources) -> RowSetFactory.fromRange((long)sources[0].getLong(rowKey), (long)(sources[1].getLong(rowKey) - 1L)))));
        }
        throw new TableDataException(String.format("Index table %s for table %s was not in the expected format. Expected columns [%s] but encountered [%s]", indexFileMetaData.fileURI, parentFileURI, String.join((CharSequence)", ", "dh_key", "dh_begin_pos", "dh_end_pos"), indexTable.getDefinition().getColumnNamesAsString()));
    }

    private static class IndexFileMetadata {
        private final URI fileURI;
        private final GroupingColumnInfo groupingColumnInfo;
        private final DataIndexInfo dataIndexInfo;

        private IndexFileMetadata(@NotNull URI fileURI, @Nullable GroupingColumnInfo groupingColumnInfo, @Nullable DataIndexInfo dataIndexInfo) {
            this.fileURI = fileURI;
            Require.requirement((boolean)(groupingColumnInfo != null ^ dataIndexInfo != null), (String)"Exactly one of groupingColumnInfo and dataIndexInfo must be non-null");
            this.groupingColumnInfo = groupingColumnInfo;
            this.dataIndexInfo = dataIndexInfo;
        }
    }
}

