/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.location;

import io.deephaven.engine.table.impl.locations.TableKey;
import io.deephaven.engine.table.impl.locations.TableLocation;
import io.deephaven.engine.table.impl.locations.TableLocationKey;
import io.deephaven.engine.table.impl.locations.impl.NonexistentTableLocation;
import io.deephaven.engine.table.impl.locations.impl.TableLocationFactory;
import io.deephaven.engine.table.impl.locations.util.TableDataRefreshService;
import io.deephaven.parquet.table.ParquetInstructions;
import io.deephaven.parquet.table.location.ParquetTableLocation;
import io.deephaven.parquet.table.location.ParquetTableLocationKey;
import java.io.File;
import java.net.URI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ParquetTableLocationFactory
implements TableLocationFactory<TableKey, ParquetTableLocationKey> {
    private final ParquetInstructions readInstructions;

    public ParquetTableLocationFactory(@NotNull ParquetInstructions readInstructions) {
        this.readInstructions = readInstructions;
    }

    @NotNull
    public TableLocation makeLocation(@NotNull TableKey tableKey, @NotNull ParquetTableLocationKey locationKey, @Nullable TableDataRefreshService refreshService) {
        URI parquetFileURI = locationKey.getURI();
        if (!"file".equals(parquetFileURI.getScheme()) || new File(parquetFileURI).exists()) {
            return new ParquetTableLocation(tableKey, locationKey, this.readInstructions);
        }
        return new NonexistentTableLocation(tableKey, (TableLocationKey)locationKey);
    }
}

