/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.location;

import io.deephaven.base.FileUtils;
import io.deephaven.engine.table.impl.locations.TableDataException;
import io.deephaven.engine.table.impl.locations.local.URITableLocationKey;
import io.deephaven.parquet.base.ParquetFileReader;
import io.deephaven.parquet.table.ParquetInstructions;
import io.deephaven.util.channel.SeekableChannelsProvider;
import io.deephaven.util.channel.SeekableChannelsProviderLoader;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.parquet.format.ColumnChunk;
import org.apache.parquet.format.RowGroup;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParquetTableLocationKey
extends URITableLocationKey {
    private static final String IMPLEMENTATION_NAME = ParquetTableLocationKey.class.getSimpleName();
    private ParquetFileReader fileReader;
    private ParquetMetadata metadata;
    private int[] rowGroupIndices;
    private SeekableChannelsProvider channelsProvider;

    public ParquetTableLocationKey(@NotNull URI parquetFileUri, int order, @Nullable Map<String, Comparable<?>> partitions, @NotNull ParquetInstructions readInstructions) {
        this(parquetFileUri, order, partitions, readInstructions, SeekableChannelsProviderLoader.getInstance().fromServiceLoader(parquetFileUri, readInstructions.getSpecialInstructions()));
    }

    public ParquetTableLocationKey(@NotNull URI parquetFileUri, int order, @Nullable Map<String, Comparable<?>> partitions, @NotNull ParquetInstructions readInstructions, @NotNull SeekableChannelsProvider channelsProvider) {
        super(ParquetTableLocationKey.validateParquetFile(parquetFileUri), order, partitions);
        this.channelsProvider = channelsProvider;
    }

    private static URI validateParquetFile(@NotNull URI parquetFileUri) {
        if (!parquetFileUri.getRawPath().endsWith(".parquet")) {
            throw new IllegalArgumentException("Parquet file must end in .parquet, found: " + parquetFileUri.getRawPath());
        }
        return parquetFileUri;
    }

    public String getImplementationName() {
        return IMPLEMENTATION_NAME;
    }

    public synchronized ParquetFileReader getFileReader() {
        if (this.fileReader != null) {
            return this.fileReader;
        }
        this.fileReader = ParquetFileReader.create((URI)this.uri, (SeekableChannelsProvider)this.channelsProvider);
        return this.fileReader;
    }

    public synchronized void setFileReader(ParquetFileReader fileReader) {
        this.fileReader = fileReader;
        this.metadata = null;
        this.rowGroupIndices = null;
    }

    public synchronized ParquetMetadata getMetadata() {
        if (this.metadata != null) {
            return this.metadata;
        }
        try {
            this.metadata = new ParquetMetadataConverter().fromParquetMetadata(this.getFileReader().fileMetaData);
            return this.metadata;
        }
        catch (IOException e) {
            throw new TableDataException("Failed to convert Parquet file metadata: " + this.getURI(), (Throwable)e);
        }
    }

    public synchronized void setMetadata(ParquetMetadata metadata) {
        this.metadata = metadata;
    }

    public synchronized int[] getRowGroupIndices() {
        if (this.rowGroupIndices != null) {
            return this.rowGroupIndices;
        }
        List rowGroups = this.getFileReader().fileMetaData.getRow_groups();
        this.rowGroupIndices = IntStream.range(0, rowGroups.size()).filter(rgi -> {
            String filePath = FilenameUtils.separatorsToSystem((String)((ColumnChunk)((RowGroup)rowGroups.get(rgi)).getColumns().get(0)).getFile_path());
            return filePath == null || FileUtils.convertToURI((String)filePath, (boolean)false).equals(this.uri);
        }).toArray();
        return this.rowGroupIndices;
    }

    public synchronized void setRowGroupIndices(int[] rowGroupIndices) {
        this.rowGroupIndices = rowGroupIndices;
    }
}

