/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.metadata;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.deephaven.annotations.BuildableStyle;
import io.deephaven.parquet.table.metadata.ImmutableCodecInfo;
import java.util.Optional;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableCodecInfo.class)
@JsonDeserialize(as=ImmutableCodecInfo.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Value.Immutable
@BuildableStyle
public abstract class CodecInfo {
    public abstract String codecName();

    public abstract Optional<String> codecArg();

    public abstract String dataType();

    public abstract Optional<String> componentType();

    @Value.Check
    final void checkCodecName() {
        if (this.codecName().isEmpty()) {
            throw new IllegalArgumentException("Empty codec name");
        }
    }

    @Value.Check
    final void checkDataType() {
        if (this.dataType().isEmpty()) {
            throw new IllegalArgumentException("Empty data type");
        }
    }

    @Value.Check
    final void checkComponentType() {
        if (this.componentType().filter(String::isEmpty).isPresent()) {
            throw new IllegalArgumentException("Empty component type");
        }
    }

    public static Builder builder() {
        return ImmutableCodecInfo.builder();
    }

    public static interface Builder {
        public Builder codecName(String var1);

        public Builder codecArg(String var1);

        public Builder dataType(String var1);

        public Builder componentType(String var1);

        public CodecInfo build();
    }
}

