/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.metadata;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.deephaven.annotations.BuildableStyle;
import io.deephaven.parquet.table.metadata.CodecInfo;
import io.deephaven.parquet.table.metadata.ImmutableColumnTypeInfo;
import java.util.Optional;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableColumnTypeInfo.class)
@JsonDeserialize(as=ImmutableColumnTypeInfo.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Value.Immutable
@BuildableStyle
public abstract class ColumnTypeInfo {
    public abstract String columnName();

    public abstract Optional<CodecInfo> codec();

    public abstract Optional<SpecialType> specialType();

    @Value.Check
    final void checkColumnName() {
        if (this.columnName().isEmpty()) {
            throw new IllegalArgumentException("Empty column name");
        }
    }

    public static Builder builder() {
        return ImmutableColumnTypeInfo.builder();
    }

    public static interface Builder {
        public Builder columnName(String var1);

        public Builder codec(CodecInfo var1);

        public Builder specialType(SpecialType var1);

        public ColumnTypeInfo build();
    }

    public static enum SpecialType {
        StringSet,
        Vector;

    }
}

