/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.metadata;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.deephaven.annotations.SimpleStyle;
import io.deephaven.engine.util.string.StringUtils;
import io.deephaven.parquet.table.metadata.ImmutableDataIndexInfo;
import java.util.Arrays;
import java.util.Set;
import org.immutables.value.Value;
import org.jetbrains.annotations.NotNull;

@JsonSerialize(as=ImmutableDataIndexInfo.class)
@JsonDeserialize(as=ImmutableDataIndexInfo.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Value.Immutable
@SimpleStyle
public abstract class DataIndexInfo {
    @Value.Parameter
    public abstract Set<String> columns();

    @Value.Parameter
    public abstract String indexTablePath();

    @Value.Check
    final void checkColumns() {
        if (this.columns().isEmpty()) {
            throw new IllegalArgumentException("No columns provided");
        }
        if (this.columns().stream().anyMatch(StringUtils::isNullOrEmpty)) {
            throw new IllegalArgumentException("Empty column name");
        }
    }

    @Value.Check
    final void checkIndexTablePath() {
        if (this.indexTablePath().isEmpty()) {
            throw new IllegalArgumentException("Empty index table path");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matchesColumns(String ... columnsToMatch) {
        Set<String> localColumns = this.columns();
        if (localColumns.size() != columnsToMatch.length) return false;
        if (!Arrays.stream(columnsToMatch).allMatch(localColumns::contains)) return false;
        return true;
    }

    public static DataIndexInfo of(@NotNull String indexTablePath, String ... columnNames) {
        return ImmutableDataIndexInfo.of(Arrays.asList(columnNames), indexTablePath);
    }
}

