/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.metadata;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.deephaven.annotations.SimpleStyle;
import io.deephaven.parquet.table.metadata.ImmutableGroupingColumnInfo;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableGroupingColumnInfo.class)
@JsonDeserialize(as=ImmutableGroupingColumnInfo.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Value.Immutable
@SimpleStyle
public abstract class GroupingColumnInfo {
    @Value.Parameter
    public abstract String columnName();

    @Value.Parameter
    public abstract String groupingTablePath();

    @Value.Check
    final void checkColumnName() {
        if (this.columnName().isEmpty()) {
            throw new IllegalArgumentException("Empty column name");
        }
    }

    @Value.Check
    final void checkGroupingTablePath() {
        if (this.groupingTablePath().isEmpty()) {
            throw new IllegalArgumentException("Empty grouping table path");
        }
    }

    public static GroupingColumnInfo of(String columnName, String groupingTablePath) {
        return ImmutableGroupingColumnInfo.of(columnName, groupingTablePath);
    }
}

