/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.parquet.table.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.deephaven.parquet.table.metadata.CodecInfo;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CodecInfo", generator="Immutables")
@Immutable
final class ImmutableCodecInfo
extends CodecInfo {
    private final String codecName;
    @Nullable
    private final String codecArg;
    private final String dataType;
    @Nullable
    private final String componentType;

    private ImmutableCodecInfo(Builder builder) {
        this.codecName = builder.codecName;
        this.codecArg = builder.codecArg;
        this.dataType = builder.dataType;
        this.componentType = builder.componentType;
    }

    @Override
    @JsonProperty(value="codecName")
    public String codecName() {
        return this.codecName;
    }

    @Override
    @JsonProperty(value="codecArg")
    public Optional<String> codecArg() {
        return Optional.ofNullable(this.codecArg);
    }

    @Override
    @JsonProperty(value="dataType")
    public String dataType() {
        return this.dataType;
    }

    @Override
    @JsonProperty(value="componentType")
    public Optional<String> componentType() {
        return Optional.ofNullable(this.componentType);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCodecInfo && this.equalTo(0, (ImmutableCodecInfo)another);
    }

    private boolean equalTo(int synthetic, ImmutableCodecInfo another) {
        return this.codecName.equals(another.codecName) && Objects.equals(this.codecArg, another.codecArg) && this.dataType.equals(another.dataType) && Objects.equals(this.componentType, another.componentType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.codecName.hashCode();
        h += (h << 5) + Objects.hashCode(this.codecArg);
        h += (h << 5) + this.dataType.hashCode();
        h += (h << 5) + Objects.hashCode(this.componentType);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CodecInfo{");
        builder.append("codecName=").append(this.codecName);
        if (this.codecArg != null) {
            builder.append(", ");
            builder.append("codecArg=").append(this.codecArg);
        }
        builder.append(", ");
        builder.append("dataType=").append(this.dataType);
        if (this.componentType != null) {
            builder.append(", ");
            builder.append("componentType=").append(this.componentType);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCodecInfo fromJson(Json json) {
        Builder builder = ImmutableCodecInfo.builder();
        if (json.codecName != null) {
            builder.codecName(json.codecName);
        }
        if (json.codecArgIsSet) {
            builder.codecArg(json.codecArg);
        }
        if (json.dataType != null) {
            builder.dataType(json.dataType);
        }
        if (json.componentTypeIsSet) {
            builder.componentType(json.componentType);
        }
        return builder.build();
    }

    private static ImmutableCodecInfo validate(ImmutableCodecInfo instance) {
        instance.checkComponentType();
        instance.checkDataType();
        instance.checkCodecName();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CodecInfo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements CodecInfo.Builder {
        private static final long INIT_BIT_CODEC_NAME = 1L;
        private static final long INIT_BIT_DATA_TYPE = 2L;
        private static final long OPT_BIT_CODEC_ARG = 1L;
        private static final long OPT_BIT_COMPONENT_TYPE = 2L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private String codecName;
        @Nullable
        private String codecArg;
        @Nullable
        private String dataType;
        @Nullable
        private String componentType;

        private Builder() {
        }

        @Override
        @JsonProperty(value="codecName")
        @CanIgnoreReturnValue
        public final Builder codecName(String codecName) {
            Builder.checkNotIsSet(this.codecNameIsSet(), "codecName");
            this.codecName = Objects.requireNonNull(codecName, "codecName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder codecArg(String codecArg) {
            Builder.checkNotIsSet(this.codecArgIsSet(), "codecArg");
            this.codecArg = Objects.requireNonNull(codecArg, "codecArg");
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="codecArg")
        @CanIgnoreReturnValue
        public final Builder codecArg(Optional<String> codecArg) {
            Builder.checkNotIsSet(this.codecArgIsSet(), "codecArg");
            this.codecArg = codecArg.orElse(null);
            this.optBits |= 1L;
            return this;
        }

        @Override
        @JsonProperty(value="dataType")
        @CanIgnoreReturnValue
        public final Builder dataType(String dataType) {
            Builder.checkNotIsSet(this.dataTypeIsSet(), "dataType");
            this.dataType = Objects.requireNonNull(dataType, "dataType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder componentType(String componentType) {
            Builder.checkNotIsSet(this.componentTypeIsSet(), "componentType");
            this.componentType = Objects.requireNonNull(componentType, "componentType");
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty(value="componentType")
        @CanIgnoreReturnValue
        public final Builder componentType(Optional<String> componentType) {
            Builder.checkNotIsSet(this.componentTypeIsSet(), "componentType");
            this.componentType = componentType.orElse(null);
            this.optBits |= 2L;
            return this;
        }

        @Override
        public ImmutableCodecInfo build() {
            this.checkRequiredAttributes();
            return ImmutableCodecInfo.validate(new ImmutableCodecInfo(this));
        }

        private boolean codecArgIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean componentTypeIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean codecNameIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean dataTypeIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of CodecInfo is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.codecNameIsSet()) {
                attributes.add("codecName");
            }
            if (!this.dataTypeIsSet()) {
                attributes.add("dataType");
            }
            return "Cannot build CodecInfo, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CodecInfo", generator="Immutables")
    static final class Json
    extends CodecInfo {
        @Nullable
        String codecName;
        @Nullable
        Optional<String> codecArg = Optional.empty();
        boolean codecArgIsSet;
        @Nullable
        String dataType;
        @Nullable
        Optional<String> componentType = Optional.empty();
        boolean componentTypeIsSet;

        Json() {
        }

        @JsonProperty(value="codecName")
        public void setCodecName(String codecName) {
            this.codecName = codecName;
        }

        @JsonProperty(value="codecArg")
        public void setCodecArg(Optional<String> codecArg) {
            this.codecArg = codecArg;
            this.codecArgIsSet = true;
        }

        @JsonProperty(value="dataType")
        public void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @JsonProperty(value="componentType")
        public void setComponentType(Optional<String> componentType) {
            this.componentType = componentType;
            this.componentTypeIsSet = true;
        }

        @Override
        public String codecName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> codecArg() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String dataType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> componentType() {
            throw new UnsupportedOperationException();
        }
    }
}

